/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.backup.BackupEmbeddedIT;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.DbRepresentation;
import org.neo4j.test.TargetDirectory;

public class BackupHaIT {
    public static final File PATH = TargetDirectory.forTest(BackupHaIT.class).cleanDirectory("db");
    public static final File BACKUP_PATH = TargetDirectory.forTest(BackupHaIT.class).cleanDirectory("backup-db");
    private DbRepresentation representation;
    private ClusterManager clusterManager;
    private ClusterManager.ManagedCluster cluster;

    @Before
    public void setup() throws Throwable {
        FileUtils.deleteDirectory((File)PATH);
        FileUtils.deleteDirectory((File)BACKUP_PATH);
        this.startCluster();
        this.representation = BackupEmbeddedIT.createSomeData((GraphDatabaseService)this.cluster.getMaster());
    }

    private void startCluster() throws Throwable {
        this.clusterManager = new ClusterManager(ClusterManager.fromXml((URI)this.getClass().getResource("/threeinstances.xml").toURI()), PATH, MapUtil.stringMap((String[])new String[]{OnlineBackupSettings.online_backup_enabled.name(), "true"})){

            protected void config(GraphDatabaseBuilder builder, String clusterName, InstanceId serverId) {
                builder.setConfig(OnlineBackupSettings.online_backup_server, ":" + (4444 + serverId.toIntegerIndex()));
            }
        };
        this.clusterManager.start();
        this.cluster = this.clusterManager.getDefaultCluster();
        this.cluster.await(ClusterManager.allSeesAllAsAvailable());
    }

    @After
    public void stopCluster() throws Throwable {
        this.clusterManager.stop();
        this.clusterManager.shutdown();
    }

    @Test
    public void makeSureBackupCanBePerformedFromClusterWithDefaultName() throws Throwable {
        this.testBackupFromCluster(null);
    }

    @Test
    public void makeSureBackupCanBePerformedFromWronglyNamedCluster() throws Throwable {
        Assert.assertEquals((long)0L, (long)BackupEmbeddedIT.runBackupToolFromOtherJvmToGetExitCode((String[])this.backupArguments("localhost:4445", BACKUP_PATH.getPath(), "non.existent")));
    }

    @Test
    public void makeSureBackupCanBeRestored() throws Throwable {
        Assert.assertEquals((long)0L, (long)BackupEmbeddedIT.runBackupToolFromOtherJvmToGetExitCode((String[])this.backupArguments("localhost:4445", BACKUP_PATH.getPath(), null)));
        DbRepresentation changedData = BackupEmbeddedIT.createSomeData((GraphDatabaseService)this.cluster.getMaster());
        this.stopCluster();
        this.cleanData();
        this.copyBackup();
        this.startCluster();
        Assert.assertThat((Object)changedData.equals((Object)DbRepresentation.of((GraphDatabaseService)this.cluster.getMaster())), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void makeSureBackupCanBePerformedFromAnyInstance() throws Throwable {
        Integer[] backupPorts;
        for (Integer port : backupPorts = new Integer[]{4445, 4446, 4447}) {
            Assert.assertEquals((long)0L, (long)BackupEmbeddedIT.runBackupToolFromOtherJvmToGetExitCode((String[])this.backupArguments("localhost:" + port, BACKUP_PATH.getPath(), null)));
            DbRepresentation changedData = BackupEmbeddedIT.createSomeData((GraphDatabaseService)this.cluster.getMaster());
            this.stopCluster();
            this.cleanData();
            this.copyBackup();
            this.startCluster();
            Assert.assertThat((Object)changedData.equals((Object)DbRepresentation.of((GraphDatabaseService)this.cluster.getMaster())), (Matcher)Matchers.equalTo((Object)false));
        }
    }

    private void copyBackup() throws IOException {
        FileUtils.copyDirectory((File)BACKUP_PATH, (File)new File(PATH, "neo4j.ha/server1"));
        FileUtils.copyDirectory((File)BACKUP_PATH, (File)new File(PATH, "neo4j.ha/server2"));
        FileUtils.copyDirectory((File)BACKUP_PATH, (File)new File(PATH, "neo4j.ha/server3"));
    }

    private void cleanData() throws IOException {
        FileUtils.cleanDirectory((File)new File(PATH, "neo4j.ha/server1"));
        FileUtils.cleanDirectory((File)new File(PATH, "neo4j.ha/server2"));
        FileUtils.cleanDirectory((File)new File(PATH, "neo4j.ha/server3"));
    }

    private void testBackupFromCluster(String askForCluster) throws Throwable {
        Assert.assertEquals((long)0L, (long)BackupEmbeddedIT.runBackupToolFromOtherJvmToGetExitCode((String[])this.backupArguments("localhost:4445", BACKUP_PATH.getPath(), askForCluster)));
        Assert.assertEquals((Object)this.representation, (Object)DbRepresentation.of((File)BACKUP_PATH));
        ClusterManager.ManagedCluster cluster = this.clusterManager.getCluster(askForCluster == null ? "neo4j.ha" : askForCluster);
        DbRepresentation newRepresentation = BackupEmbeddedIT.createSomeData((GraphDatabaseService)cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]));
        Assert.assertEquals((long)0L, (long)BackupEmbeddedIT.runBackupToolFromOtherJvmToGetExitCode((String[])this.backupArguments("localhost:4445", BACKUP_PATH.getPath(), askForCluster)));
        Assert.assertEquals((Object)newRepresentation, (Object)DbRepresentation.of((File)BACKUP_PATH));
    }

    private String[] backupArguments(String from, String to, String clusterName) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-from");
        args.add(from);
        args.add("-to");
        args.add(to);
        if (clusterName != null) {
            args.add("-cluster");
            args.add(clusterName);
        }
        return args.toArray(new String[args.size()]);
    }
}

