/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.test.LoggerRule;
import org.neo4j.test.TargetDirectory;

@Ignore(value="A good idea but the test is too high level, is fragile and takes too long.")
public class PullStormIT {
    @Rule
    public TargetDirectory.TestDirectory testDirectory = TargetDirectory.testDirForTest(this.getClass());
    @Rule
    public LoggerRule logger = new LoggerRule();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPullStorm() throws Throwable {
        ClusterManager clusterManager = new ClusterManager(ClusterManager.clusterWithAdditionalArbiters((int)2, (int)1), this.testDirectory.directory(), MapUtil.stringMap((String[])new String[]{HaSettings.pull_interval.name(), "0", HaSettings.tx_push_factor.name(), "1"}));
        clusterManager.start();
        try {
            ClusterManager.ManagedCluster cluster = clusterManager.getDefaultCluster();
            cluster.await(ClusterManager.masterAvailable((HighlyAvailableGraphDatabase[])new HighlyAvailableGraphDatabase[0]));
            cluster.await(ClusterManager.masterSeesSlavesAsAvailable((int)1));
            final HighlyAvailableGraphDatabase master = cluster.getMaster();
            Transaction tx = master.beginTx();
            for (int i = 0; i < 1000; ++i) {
                master.createNode().setProperty("foo", (Object)"bar");
            }
            tx.success();
            tx.finish();
            HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
            ClusterManager.RepairKit repairKit = cluster.fail(slave);
            for (int i = 0; i < 1000; ++i) {
                Transaction tx2 = master.beginTx();
                for (int j = 0; j < 1000; ++j) {
                    master.createNode().setProperty("foo", (Object)"bar");
                    master.createNode().setProperty("foo", (Object)"bar");
                }
                tx2.success();
                tx2.finish();
            }
            repairKit.repair();
            cluster.await(ClusterManager.masterSeesSlavesAsAvailable((int)1));
            System.out.println("Pull storm");
            ExecutorService executor = Executors.newFixedThreadPool(20);
            for (int i = 0; i < 20; ++i) {
                executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        Transaction tx = master.beginTx();
                        master.createNode().setProperty("foo", (Object)"bar");
                        tx.success();
                        tx.finish();
                    }
                });
            }
            executor.shutdown();
            executor.awaitTermination(1L, TimeUnit.MINUTES);
            System.out.println("Pull storm done");
            long masterLastCommittedTxId = this.lastCommittedTxId(master);
            for (HighlyAvailableGraphDatabase member : cluster.getAllMembers()) {
                Assert.assertEquals((long)masterLastCommittedTxId, (long)this.lastCommittedTxId(member));
            }
        }
        finally {
            System.err.println("Shutting down");
            clusterManager.shutdown();
            System.err.println("Shut down");
        }
    }

    private long lastCommittedTxId(HighlyAvailableGraphDatabase highlyAvailableGraphDatabase) {
        return ((TransactionIdStore)highlyAvailableGraphDatabase.getDependencyResolver().resolveDependency(TransactionIdStore.class)).getLastCommittedTransactionId();
    }
}

