/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.LastUpdateTime;
import org.neo4j.kernel.ha.SlaveUpdatePuller;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.InvalidEpochException;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.slave.InvalidEpochExceptionHandler;
import org.neo4j.kernel.impl.util.CountingJobScheduler;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.Neo4jJobScheduler;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.logging.BufferingLogger;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.kernel.logging.LogMarker;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.test.CleanupRule;

public class SlaveUpdatePullerTest {
    private final AtomicInteger scheduledJobs = new AtomicInteger();
    private final InstanceId instanceId = new InstanceId(1);
    private final Config config = (Config)Mockito.mock(Config.class);
    private final AvailabilityGuard availabilityGuard = (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class);
    private final LastUpdateTime lastUpdateTime = (LastUpdateTime)Mockito.mock(LastUpdateTime.class);
    private final Master master = (Master)Mockito.mock(Master.class);
    private final ErrorTrackingLogging logging = new ErrorTrackingLogging();
    private final RequestContextFactory requestContextFactory = (RequestContextFactory)Mockito.mock(RequestContextFactory.class);
    private final InvalidEpochExceptionHandler invalidEpochHandler = (InvalidEpochExceptionHandler)Mockito.mock(InvalidEpochExceptionHandler.class);
    private final JobScheduler jobScheduler = new CountingJobScheduler(this.scheduledJobs, new Neo4jJobScheduler("SlaveUpdatePullerTest"));
    private final SlaveUpdatePuller updatePuller = new SlaveUpdatePuller(this.requestContextFactory, this.master, this.lastUpdateTime, (Logging)this.logging, this.instanceId, this.availabilityGuard, this.invalidEpochHandler, this.jobScheduler);
    @Rule
    public final CleanupRule cleanup = new CleanupRule();

    @Before
    public void setUp() throws Throwable {
        Mockito.when((Object)this.config.get(HaSettings.pull_interval)).thenReturn((Object)1000L);
        Mockito.when((Object)this.config.get(ClusterSettings.server_id)).thenReturn((Object)this.instanceId);
        Mockito.when((Object)this.availabilityGuard.isAvailable(Matchers.anyLong())).thenReturn((Object)true);
        this.jobScheduler.init();
        this.jobScheduler.start();
        this.updatePuller.init();
        this.updatePuller.start();
    }

    @After
    public void tearDown() throws Throwable {
        this.updatePuller.stop();
        this.updatePuller.shutdown();
        this.jobScheduler.stop();
        this.jobScheduler.shutdown();
    }

    @Test
    public void initialisationMustBeIdempotent() throws Throwable {
        this.updatePuller.init();
        this.updatePuller.start();
        this.updatePuller.init();
        this.updatePuller.start();
        this.updatePuller.init();
        this.updatePuller.start();
        Assert.assertThat((Object)this.scheduledJobs.get(), (Matcher)org.hamcrest.Matchers.is((Object)1));
    }

    @Test
    public void shouldStopPullingAfterStop() throws Throwable {
        this.updatePuller.pullUpdates();
        ((LastUpdateTime)Mockito.verify((Object)this.lastUpdateTime, (VerificationMode)Mockito.times((int)1))).setLastUpdateTime(Matchers.anyLong());
        ((AvailabilityGuard)Mockito.verify((Object)this.availabilityGuard, (VerificationMode)Mockito.times((int)1))).isAvailable(Matchers.anyLong());
        ((Master)Mockito.verify((Object)this.master, (VerificationMode)Mockito.times((int)1))).pullUpdates((RequestContext)Matchers.any());
        this.updatePuller.shutdown();
        this.updatePuller.pullUpdates();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.lastUpdateTime, this.availabilityGuard});
    }

    @Test
    public void keepPullingUpdatesOnConsecutiveCalls() throws Throwable {
        this.updatePuller.pullUpdates();
        ((LastUpdateTime)Mockito.verify((Object)this.lastUpdateTime, (VerificationMode)Mockito.times((int)1))).setLastUpdateTime(Matchers.anyLong());
        ((AvailabilityGuard)Mockito.verify((Object)this.availabilityGuard, (VerificationMode)Mockito.times((int)1))).isAvailable(Matchers.anyLong());
        ((Master)Mockito.verify((Object)this.master, (VerificationMode)Mockito.times((int)1))).pullUpdates((RequestContext)Matchers.any());
        this.updatePuller.pullUpdates();
        ((LastUpdateTime)Mockito.verify((Object)this.lastUpdateTime, (VerificationMode)Mockito.times((int)2))).setLastUpdateTime(Matchers.anyLong());
        ((AvailabilityGuard)Mockito.verify((Object)this.availabilityGuard, (VerificationMode)Mockito.times((int)2))).isAvailable(Matchers.anyLong());
        ((Master)Mockito.verify((Object)this.master, (VerificationMode)Mockito.times((int)2))).pullUpdates((RequestContext)Matchers.any());
    }

    @Test
    public void falseOnTryPullUpdatesOnInactivePuller() throws Throwable {
        this.updatePuller.shutdown();
        boolean result = this.updatePuller.tryPullUpdates();
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void shouldThrowIfPullerInitiallyInactiveStrict() throws Throwable {
        UpdatePuller.Condition condition = (UpdatePuller.Condition)Mockito.mock(UpdatePuller.Condition.class);
        this.updatePuller.shutdown();
        try {
            this.updatePuller.pullUpdates(condition, true);
            Assert.fail((String)"Should have thrown");
        }
        catch (IllegalStateException e) {
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{condition});
        }
    }

    @Test
    public void shouldThrowIfPullerBecomesInactiveWhileWaitingStrict() throws Exception {
        UpdatePuller.Condition condition = (UpdatePuller.Condition)Mockito.mock(UpdatePuller.Condition.class);
        Mockito.when((Object)condition.evaluate(Matchers.anyInt(), Matchers.anyInt())).thenAnswer((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                SlaveUpdatePullerTest.this.updatePuller.shutdown();
                return false;
            }
        });
        try {
            this.updatePuller.pullUpdates(condition, true);
            Assert.fail((String)"Should have thrown");
        }
        catch (IllegalStateException e) {
            ((UpdatePuller.Condition)Mockito.verify((Object)condition)).evaluate(Matchers.anyInt(), Matchers.anyInt());
        }
    }

    @Test
    public void shouldHandleInvalidEpochByNotifyingItsHandler() throws Exception {
        ((Master)Mockito.doThrow(InvalidEpochException.class).when((Object)this.master)).pullUpdates((RequestContext)Matchers.any(RequestContext.class));
        this.updatePuller.pullUpdates();
        ((InvalidEpochExceptionHandler)Mockito.verify((Object)this.invalidEpochHandler)).handle();
    }

    @Test
    public void shouldCopeWithHardExceptionsLikeOutOfMemory() throws Exception {
        Mockito.when((Object)this.master.pullUpdates((RequestContext)Matchers.any(RequestContext.class))).thenThrow(new Class[]{OutOfMemoryError.class}).thenReturn((Object)Response.EMPTY);
        this.updatePuller.pullUpdates();
        Assert.assertTrue((boolean)this.logging.hasSeenError(OutOfMemoryError.class));
        this.updatePuller.pullUpdates();
    }

    private static class ErrorTrackingLogger
    extends BufferingLogger {
        private final List<Throwable> errors;

        public ErrorTrackingLogger(List<Throwable> errors) {
            this.errors = errors;
        }

        public synchronized void error(String msg, Throwable cause, boolean flush, LogMarker logMarker) {
            this.errors.add(cause);
            super.error(msg, cause, flush, logMarker);
        }
    }

    private static class ErrorTrackingLogging
    extends LifecycleAdapter
    implements Logging {
        private final List<Throwable> errors = new ArrayList<Throwable>();
        private final StringLogger logger = new ErrorTrackingLogger(this.errors);

        private ErrorTrackingLogging() {
        }

        public StringLogger getMessagesLog(Class loggingClass) {
            return this.logger;
        }

        public ConsoleLogger getConsoleLog(Class loggingClass) {
            throw new UnsupportedOperationException("Shouldn't be required");
        }

        boolean hasSeenError(Class<?> cls) {
            for (Throwable throwable : this.errors) {
                if (!throwable.getClass().equals(cls)) continue;
                return true;
            }
            return false;
        }
    }
}

