/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.cache.HPCMemoryConfig;
import org.neo4j.kernel.impl.cache.HPCSettingFunctions;
import org.neo4j.kernel.impl.cache.HighPerformanceCacheSettings;

public class HighPerformanceCacheSettingsTest {
    @Test
    public void cacheMemoryRatioShouldCalculateSaneRatio() throws Exception {
        HPCMemoryConfig config = (HPCMemoryConfig)HPCSettingFunctions.CACHE_MEMORY_RATIO.apply((Object)"100.0");
        MatcherAssert.assertThat((Object)config.nodeCacheSize(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        MatcherAssert.assertThat((Object)config.relCacheSize(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        MatcherAssert.assertThat((Object)Float.valueOf(config.nodeLookupTableFraction()), (Matcher)Matchers.greaterThan((Comparable)Float.valueOf(0.0f)));
        MatcherAssert.assertThat((Object)Float.valueOf(config.relLookupTableFraction()), (Matcher)Matchers.greaterThan((Comparable)Float.valueOf(0.0f)));
        HPCMemoryConfig otherRatio = (HPCMemoryConfig)HPCSettingFunctions.CACHE_MEMORY_RATIO.apply((Object)"50.0");
        MatcherAssert.assertThat((Object)otherRatio.nodeCacheSize(), (Matcher)Matchers.closeTo((double)(config.nodeCacheSize() / 2L), (double)10.0));
        MatcherAssert.assertThat((Object)otherRatio.relCacheSize(), (Matcher)Matchers.closeTo((double)(config.relCacheSize() / 2L), (double)10.0));
        MatcherAssert.assertThat((Object)otherRatio.nodeLookupTableFraction(), (Matcher)Matchers.closeTo((double)(config.nodeLookupTableFraction() / 2.0f), (double)10.0));
        MatcherAssert.assertThat((Object)otherRatio.relLookupTableFraction(), (Matcher)Matchers.closeTo((double)(config.relLookupTableFraction() / 2.0f), (double)10.0));
    }

    @Test
    public void explicitCacheConfigShouldOverrideRatioDefaults() throws Exception {
        Config conf = new Config(MapUtil.stringMap((String[])new String[]{HighPerformanceCacheSettings.node_cache_size.name(), "200M"}), new Class[]{HighPerformanceCacheSettings.class});
        HPCMemoryConfig memoryConfig = (HPCMemoryConfig)conf.get(HighPerformanceCacheSettings.cache_memory);
        MatcherAssert.assertThat((Object)memoryConfig.source(), (Matcher)Matchers.equalTo((Object)HPCMemoryConfig.Source.SPECIFIC));
        MatcherAssert.assertThat((Object)memoryConfig.nodeCacheSize(), (Matcher)Matchers.equalTo((Object)0xC800000L));
        MatcherAssert.assertThat((Object)memoryConfig.relCacheSize(), (Matcher)Matchers.closeTo((double)(Runtime.getRuntime().maxMemory() / 8L), (double)100.0));
        MatcherAssert.assertThat((Object)Float.valueOf(memoryConfig.relLookupTableFraction()), (Matcher)Matchers.equalTo((Object)Float.valueOf(1.0f)));
        MatcherAssert.assertThat((Object)Float.valueOf(memoryConfig.nodeLookupTableFraction()), (Matcher)Matchers.equalTo((Object)Float.valueOf(1.0f)));
    }

    @Test
    public void explicitCacheConfigShouldOverrideExplicitRatio() throws Exception {
        Config conf = new Config(MapUtil.stringMap((String[])new String[]{HighPerformanceCacheSettings.node_cache_size.name(), "200M", HighPerformanceCacheSettings.cache_memory.name(), "25"}), new Class[]{HighPerformanceCacheSettings.class});
        HPCMemoryConfig memoryConfig = (HPCMemoryConfig)conf.get(HighPerformanceCacheSettings.cache_memory);
        MatcherAssert.assertThat((Object)memoryConfig.source(), (Matcher)Matchers.equalTo((Object)HPCMemoryConfig.Source.SPECIFIC_OVERRIDING_RATIO));
        MatcherAssert.assertThat((Object)memoryConfig.nodeCacheSize(), (Matcher)Matchers.equalTo((Object)0xC800000L));
        MatcherAssert.assertThat((Object)memoryConfig.relCacheSize(), (Matcher)Matchers.closeTo((double)(Runtime.getRuntime().maxMemory() / 8L), (double)100.0));
        MatcherAssert.assertThat((Object)Float.valueOf(memoryConfig.relLookupTableFraction()), (Matcher)Matchers.equalTo((Object)Float.valueOf(1.0f)));
        MatcherAssert.assertThat((Object)Float.valueOf(memoryConfig.nodeLookupTableFraction()), (Matcher)Matchers.equalTo((Object)Float.valueOf(1.0f)));
    }

    @Test
    public void totalConfigLargerThanHeapIsNotAllowed() throws Exception {
        try {
            new Config(MapUtil.stringMap((String[])new String[]{HighPerformanceCacheSettings.node_cache_size.name(), "" + Runtime.getRuntime().maxMemory() * 100L}), new Class[]{HighPerformanceCacheSettings.class});
            TestCase.fail((String)"Should not have allowed getting this config.");
        }
        catch (InvalidSettingException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Configured object cache memory limits"));
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"exceeds 80% of available heap space"));
        }
    }
}

