/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Function2;
import org.neo4j.helpers.Settings;
import org.neo4j.kernel.impl.cache.HPCMemoryConfig;
import org.neo4j.kernel.impl.cache.HighPerformanceCacheSettings;
import org.neo4j.kernel.impl.util.function.Optional;
import org.neo4j.kernel.impl.util.function.Optionals;

public class HPCSettingFunctions {
    static String DEFAULT = new String("__DEFAULT__");
    static Function<String, HPCMemoryConfig> CACHE_MEMORY_RATIO = new Function<String, HPCMemoryConfig>(){

        public HPCMemoryConfig apply(String s) {
            HPCMemoryConfig.Source source = HPCMemoryConfig.Source.EXPLICIT_MEMORY_RATIO;
            if (s == DEFAULT) {
                s = "50.0";
                source = HPCMemoryConfig.Source.DEFAULT_MEMORY_RATIO;
            }
            long oldGenSize = (Long)HPCSettingFunctions.memoryPoolMax("java.lang:type=MemoryPool,name=G1 Old Gen").or(HPCSettingFunctions.memoryPoolMax("java.lang:type=MemoryPool,name=PS Old Gen")).or((Object)(HPCSettingFunctions.heap() / 2L)).get();
            long allocated = (long)((double)((Float)Settings.FLOAT.apply((Object)s)).floatValue() / 100.0 * (double)oldGenSize);
            return new HPCMemoryConfig((long)((double)allocated * 0.3), (long)((double)allocated * 0.4), this.asPercentageOfHeap((double)allocated * 0.1), this.asPercentageOfHeap((double)allocated * 0.1), source);
        }

        private float asPercentageOfHeap(double bytes) {
            return (float)(bytes / (double)HPCSettingFunctions.heap() * 100.0);
        }

        public String toString() {
            return "a value between 0 and 100";
        }
    };
    static Function2<HPCMemoryConfig, Function<String, String>, HPCMemoryConfig> OTHER_CACHE_SETTINGS_OVERRIDE = new Function2<HPCMemoryConfig, Function<String, String>, HPCMemoryConfig>(){

        public HPCMemoryConfig apply(HPCMemoryConfig basedOnRatio, Function<String, String> settings) {
            String explicitNodeCacheSize = (String)settings.apply((Object)HighPerformanceCacheSettings.node_cache_size.name());
            String explicitRelCacheSize = (String)settings.apply((Object)HighPerformanceCacheSettings.relationship_cache_size.name());
            String explicitNodeArrayFraction = (String)settings.apply((Object)HighPerformanceCacheSettings.node_cache_array_fraction.name());
            String explicitRelArrayFraction = (String)settings.apply((Object)HighPerformanceCacheSettings.relationship_cache_array_fraction.name());
            if (explicitNodeCacheSize != null || explicitRelCacheSize != null || explicitNodeArrayFraction != null || explicitRelArrayFraction != null) {
                long nodeCacheBytes = explicitNodeCacheSize != null ? (Long)Settings.BYTES.apply((Object)explicitNodeCacheSize) : HPCSettingFunctions.heap() / 8L;
                long relCacheBytes = explicitRelCacheSize != null ? (Long)Settings.BYTES.apply((Object)explicitRelCacheSize) : HPCSettingFunctions.heap() / 8L;
                float nodeArrRatio = explicitNodeArrayFraction != null ? ((Float)Settings.FLOAT.apply((Object)explicitNodeArrayFraction)).floatValue() : 1.0f;
                float relArrRatio = explicitRelArrayFraction != null ? ((Float)Settings.FLOAT.apply((Object)explicitRelArrayFraction)).floatValue() : 1.0f;
                HPCMemoryConfig.Source source = basedOnRatio.source() == HPCMemoryConfig.Source.DEFAULT_MEMORY_RATIO ? HPCMemoryConfig.Source.SPECIFIC : HPCMemoryConfig.Source.SPECIFIC_OVERRIDING_RATIO;
                return new HPCMemoryConfig(nodeCacheBytes, relCacheBytes, nodeArrRatio, relArrRatio, source);
            }
            return basedOnRatio;
        }

        public String toString() {
            return "cannot be used in conjunction with other object cache size settings";
        }
    };
    static Function2<HPCMemoryConfig, Function<String, String>, HPCMemoryConfig> TOTAL_NOT_ALLOWED_ABOVE_HEAP = new Function2<HPCMemoryConfig, Function<String, String>, HPCMemoryConfig>(){

        public HPCMemoryConfig apply(HPCMemoryConfig input, Function<String, String> settings) {
            if ((double)input.total() > (double)HPCSettingFunctions.heap() * 0.8) {
                throw new InvalidSettingException(HighPerformanceCacheSettings.cache_memory.name(), String.format("Configured object cache memory limits (node=%s, relationship=%s, total=%s) exceeds 80%% of available heap space (%s)", input.nodeCacheSize(), input.relCacheSize(), input.total(), HPCSettingFunctions.heap()));
            }
            return input;
        }

        public String toString() {
            return "may not be set to more than 80% of the available heap space";
        }
    };

    private static Optional<Long> memoryPoolMax(String bean) {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            CompositeDataSupport attribute = (CompositeDataSupport)server.getAttribute(new ObjectName(bean), "Usage");
            return Optionals.some((Object)((Long)attribute.get("max")));
        }
        catch (Exception e) {
            return Optionals.none();
        }
    }

    private static long heap() {
        return Runtime.getRuntime().maxMemory();
    }
}

