/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.io.File;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.test.TargetDirectory;

public class HaCacheIT {
    private static final int DENSE_NODE = 10;
    @Rule
    public final TargetDirectory.TestDirectory root = TargetDirectory.forTest(this.getClass()).testDirectory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldUpdateSlaveCacheWhenRemovingRelationshipGroupFromDenseNode() throws Throwable {
        ClusterManager manager = new ClusterManager(ClusterManager.clusterOfSize(3), this.root.directory(), MapUtil.stringMap((String[])new String[]{HaSettings.tx_push_factor.name(), "2", GraphDatabaseSettings.cache_type.name(), "strong", GraphDatabaseSettings.dense_node_threshold.name(), "10"}));
        try {
            long nodeId;
            manager.start();
            ClusterManager.ManagedCluster cluster = manager.getDefaultCluster();
            cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
            cluster.await(ClusterManager.masterSeesAllSlavesAsAvailable());
            HighlyAvailableGraphDatabase master = cluster.getMaster();
            try (Transaction tx = master.beginTx();){
                Node node = master.createNode();
                for (int i = 0; i < 10; ++i) {
                    node.createRelationshipTo(master.createNode(), (RelationshipType)DynamicRelationshipType.withName((String)"FOO"));
                }
                master.createNode().createRelationshipTo(node, (RelationshipType)DynamicRelationshipType.withName((String)"BAR"));
                tx.success();
                nodeId = node.getId();
            }
            int count = 0;
            for (HighlyAvailableGraphDatabase highlyAvailableGraphDatabase : cluster.getAllMembers()) {
                Transaction tx = highlyAvailableGraphDatabase.beginTx();
                Throwable throwable = null;
                try {
                    int these = IteratorUtil.count((Iterable)highlyAvailableGraphDatabase.getNodeById(nodeId).getRelationships());
                    Assert.assertTrue((String)String.format("expected=%s, count here=%s", count, these), (these != 0 && (count == 0 || these == count) ? 1 : 0) != 0);
                    count = these;
                    tx.success();
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
                finally {
                    if (tx == null) continue;
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    tx.close();
                }
            }
            Throwable throwable = null;
            try (Transaction tx = master.beginTx();){
                for (Relationship relationship : master.getNodeById(nodeId).getRelationships(new RelationshipType[]{DynamicRelationshipType.withName((String)"BAR")})) {
                    relationship.delete();
                }
                tx.success();
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
            try (Transaction transaction = slave.beginTx();){
                ArrayList<String> relationships = new ArrayList<String>();
                for (Relationship relationship : slave.getNodeById(nodeId).getRelationships()) {
                    relationships.add(String.format("(%d)-[%d:%s]->(%d)", relationship.getStartNode().getId(), relationship.getId(), relationship.getType().name(), relationship.getEndNode().getId()));
                }
                Assert.assertEquals((String)this.joinLines(relationships), (long)(count - 1), (long)relationships.size());
                Assert.assertEquals((long)(count - 1), (long)IteratorUtil.count((Iterable)slave.getNodeById(nodeId).getRelationships()));
                transaction.success();
            }
        }
        finally {
            manager.shutdown();
        }
    }

    @Test
    public void duplicatePropertyWhenAddingChangingAPropertyFromSlaveAndMasterRespectively() throws Throwable {
        File storeDir = this.root.directory("ha-cluster");
        FileUtils.deleteRecursively((File)storeDir);
        ClusterManager clusterManager = new ClusterManager(new ClusterManager.Builder(storeDir).withProvider(ClusterManager.clusterOfSize(3)));
        clusterManager.start();
        ClusterManager.ManagedCluster cluster = clusterManager.getDefaultCluster();
        cluster.await(ClusterManager.allSeesAllAsAvailable());
        long id = this.init((GraphDatabaseService)cluster.getMaster());
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        try (Transaction tx = slave.beginTx();){
            Node node = slave.getNodeById(id);
            node.setProperty("1", (Object)1);
            tx.success();
        }
        Thread.sleep(100L);
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        try (Transaction tx = master.beginTx();){
            Node node = master.getNodeById(id);
            node.setProperty("1", (Object)0);
            tx.success();
        }
        clusterManager.stop();
        clusterManager.shutdown();
        String masterStoreDir = new File(storeDir, "neo4j.ha/server1").getAbsolutePath();
        ConsistencyCheckService.Result result = new ConsistencyCheckService().runFullConsistencyCheck(masterStoreDir, new Config(), ProgressMonitorFactory.NONE, StringLogger.SYSTEM_ERR);
        Assert.assertTrue((boolean)result.isSuccessful());
    }

    private long init(GraphDatabaseService db) {
        long id;
        try (Transaction tx = db.beginTx();){
            Node theNode = db.createNode();
            id = theNode.getId();
            for (int i = 0; i < 1; ++i) {
                Node node = db.createNode();
                node.setProperty("" + i, (Object)("" + i));
            }
            tx.success();
        }
        tx = db.beginTx();
        var5_3 = null;
        try {
            Node node = db.getNodeById(id);
            node.setProperty("0", (Object)0);
            tx.success();
        }
        catch (Throwable throwable) {
            var5_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var5_3.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        return id;
    }

    private String joinLines(Iterable<String> lines) {
        StringBuilder result = new StringBuilder();
        for (String line : lines) {
            result.append("\n\t").append(line);
        }
        return result.toString();
    }
}

