/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.register.Registers;
import org.neo4j.test.TargetDirectory;

public class HACountsPropagationTest {
    private static final int PULL_INTERVAL = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldPropagateNodeCountsInHA() throws Throwable {
        File root = TargetDirectory.forTest(this.getClass()).cleanDirectory("shouldPropagateNodeCountsInHA");
        ClusterManager clusterManager = new ClusterManager(ClusterManager.clusterOfSize(3), root, MapUtil.stringMap((String[])new String[]{HaSettings.pull_interval.name(), "100ms"}));
        clusterManager.start();
        try {
            ClusterManager.ManagedCluster cluster = clusterManager.getDefaultCluster();
            cluster.await(ClusterManager.allSeesAllAsAvailable());
            HighlyAvailableGraphDatabase master = cluster.getMaster();
            try (Transaction tx = master.beginTx();){
                master.createNode();
                master.createNode(new Label[]{DynamicLabel.label((String)"A")});
                tx.success();
            }
            this.waitForPullUpdates();
            for (HighlyAvailableGraphDatabase db : cluster.getAllMembers()) {
                CountsTracker counts = ((NeoStore)db.dependencyResolver.resolveDependency(NeoStore.class)).getCounts();
                Assert.assertEquals((long)2L, (long)counts.nodeCount(-1, Registers.newDoubleLongRegister()).readSecond());
                Assert.assertEquals((long)1L, (long)counts.nodeCount(0, Registers.newDoubleLongRegister()).readSecond());
            }
        }
        finally {
            clusterManager.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldPropagateRelationshipCountsInHA() throws Throwable {
        File root = TargetDirectory.forTest(this.getClass()).cleanDirectory("shouldPropagateRelationshipCountsInHA");
        ClusterManager clusterManager = new ClusterManager(ClusterManager.clusterOfSize(3), root, MapUtil.stringMap((String[])new String[]{HaSettings.pull_interval.name(), "100ms"}));
        clusterManager.start();
        try {
            ClusterManager.ManagedCluster cluster = clusterManager.getDefaultCluster();
            cluster.await(ClusterManager.allSeesAllAsAvailable());
            HighlyAvailableGraphDatabase master = cluster.getMaster();
            try (Transaction tx = master.beginTx();){
                Node left = master.createNode();
                Node right = master.createNode(new Label[]{DynamicLabel.label((String)"A")});
                left.createRelationshipTo(right, (RelationshipType)DynamicRelationshipType.withName((String)"Type"));
                tx.success();
            }
            this.waitForPullUpdates();
            for (HighlyAvailableGraphDatabase db : cluster.getAllMembers()) {
                CountsTracker counts = ((NeoStore)db.dependencyResolver.resolveDependency(NeoStore.class)).getCounts();
                Assert.assertEquals((long)1L, (long)counts.relationshipCount(-1, -1, -1, Registers.newDoubleLongRegister()).readSecond());
                Assert.assertEquals((long)1L, (long)counts.relationshipCount(-1, -1, 0, Registers.newDoubleLongRegister()).readSecond());
                Assert.assertEquals((long)1L, (long)counts.relationshipCount(-1, 0, -1, Registers.newDoubleLongRegister()).readSecond());
                Assert.assertEquals((long)1L, (long)counts.relationshipCount(-1, 0, 0, Registers.newDoubleLongRegister()).readSecond());
            }
        }
        finally {
            clusterManager.shutdown();
        }
    }

    private void waitForPullUpdates() {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

