/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.backup.OnlineBackupKernelExtension;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.member.ClusterMemberAvailability;
import org.neo4j.com.Response;
import org.neo4j.com.monitor.RequestMonitor;
import org.neo4j.com.storecopy.StoreCopyClient;
import org.neo4j.com.storecopy.TransactionCommittingResponseUnpacker;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.CancellationRequest;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.StoreLockerLifecycleAdapter;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.BranchedDataException;
import org.neo4j.kernel.ha.BranchedDataPolicy;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.MasterClient214;
import org.neo4j.kernel.ha.PullerFactory;
import org.neo4j.kernel.ha.SlaveUpdatePuller;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.ha.UpdatePullerScheduler;
import org.neo4j.kernel.ha.cluster.SwitchToSlave;
import org.neo4j.kernel.ha.cluster.member.ClusterMember;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.HandshakeResult;
import org.neo4j.kernel.ha.com.slave.MasterClient;
import org.neo4j.kernel.ha.com.slave.MasterClientResolver;
import org.neo4j.kernel.ha.id.HaIdGeneratorFactory;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.store.MismatchingStoreIdException;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.kernel.logging.DevNullLoggingService;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.kernel.monitoring.Monitors;

public class SwitchToSlaveTest {
    private final StoreId storeId = new StoreId(1L, 2L, 3L, 4L);
    private final UpdatePuller updatePuller = (UpdatePuller)this.mockWithLifecycle(SlaveUpdatePuller.class);
    private final PullerFactory pullerFactory = (PullerFactory)Mockito.mock(PullerFactory.class);
    private final FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
    private final NeoStoreDataSource neoStoreDataSource = this.dataSourceMock();
    private final MasterClient masterClient = (MasterClient)Mockito.mock(MasterClient.class);

    @Test
    public void shouldHandleBranchedStoreWhenMyStoreIdDiffersFromMasterStoreId() throws Throwable {
        SwitchToSlave switchToSlave = this.newSwitchToSlaveSpy();
        Mockito.when((Object)this.neoStoreDataSource.getStoreId()).thenReturn((Object)new StoreId(42L, 42L, 42L, 42L));
        try {
            switchToSlave.checkDataConsistency(this.masterClient, this.neoStoreDataSource, new URI("cluster://localhost?serverId=1"));
            Assert.fail((String)("Should have thrown " + MismatchingStoreIdException.class.getSimpleName() + " exception"));
        }
        catch (MismatchingStoreIdException mismatchingStoreIdException) {
            // empty catch block
        }
        ((SwitchToSlave)Mockito.verify((Object)switchToSlave)).stopServicesAndHandleBranchedStore((BranchedDataPolicy)Matchers.any(BranchedDataPolicy.class));
    }

    @Test
    public void shouldHandleBranchedStoreWhenHandshakeFailsWithBranchedDataException() throws Throwable {
        SwitchToSlave switchToSlave = this.newSwitchToSlaveSpy();
        URI masterUri = new URI("cluster://localhost?serverId=1");
        MasterClient masterClient = (MasterClient)Mockito.mock(MasterClient.class);
        Mockito.when((Object)masterClient.handshake(Matchers.anyLong(), (StoreId)Matchers.any(StoreId.class))).thenThrow(new Throwable[]{new BranchedDataException("")});
        try {
            switchToSlave.checkDataConsistency(masterClient, this.dataSourceMock(), masterUri);
            Assert.fail((String)("Should have thrown " + BranchedDataException.class.getSimpleName() + " exception"));
        }
        catch (BranchedDataException branchedDataException) {
            // empty catch block
        }
        ((SwitchToSlave)Mockito.verify((Object)switchToSlave)).stopServicesAndHandleBranchedStore((BranchedDataPolicy)Matchers.any(BranchedDataPolicy.class));
    }

    @Test
    public void shouldReturnNullIfWhenFailingToPullingUpdatesFromMaster() throws Throwable {
        SwitchToSlave switchToSlave = this.newSwitchToSlaveSpy();
        Mockito.when((Object)this.fs.fileExists((File)Matchers.any(File.class))).thenReturn((Object)true);
        Mockito.when((Object)this.updatePuller.tryPullUpdates()).thenReturn((Object)false);
        URI localhost = this.getLocalhostUri();
        URI uri = switchToSlave.switchToSlave((LifeSupport)Mockito.mock(LifeSupport.class), localhost, localhost, (CancellationRequest)Mockito.mock(CancellationRequest.class));
        Assert.assertNull((Object)uri);
    }

    @Test
    public void updatesPulledAndPullingScheduledOnSwitchToSlave() throws Throwable {
        SwitchToSlave switchToSlave = this.newSwitchToSlaveSpy();
        Mockito.when((Object)this.fs.fileExists((File)Matchers.any(File.class))).thenReturn((Object)true);
        JobScheduler jobScheduler = (JobScheduler)Mockito.mock(JobScheduler.class);
        LifeSupport communicationLife = (LifeSupport)Mockito.mock(LifeSupport.class);
        URI localhost = this.getLocalhostUri();
        final UpdatePullerScheduler pullerScheduler = new UpdatePullerScheduler(this.updatePuller, jobScheduler, (Logging)Mockito.mock(Logging.class), 10L);
        Mockito.when((Object)this.pullerFactory.createUpdatePullerScheduler(this.updatePuller)).thenReturn((Object)pullerScheduler);
        ((LifeSupport)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                pullerScheduler.init();
                return null;
            }
        }).when((Object)communicationLife)).start();
        switchToSlave.switchToSlave(communicationLife, localhost, localhost, (CancellationRequest)Mockito.mock(CancellationRequest.class));
        ((UpdatePuller)Mockito.verify((Object)this.updatePuller)).tryPullUpdates();
        ((LifeSupport)Mockito.verify((Object)communicationLife)).add((Lifecycle)pullerScheduler);
        ((JobScheduler)Mockito.verify((Object)jobScheduler)).scheduleRecurring((JobScheduler.Group)Matchers.eq((Object)JobScheduler.Group.pullUpdates), (Runnable)Matchers.any(Runnable.class), Matchers.eq((long)10L), Matchers.eq((long)10L), (TimeUnit)((Object)Matchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
    }

    private URI getLocalhostUri() throws URISyntaxException {
        return new URI("cluster://127.0.0.1?serverId=1");
    }

    private SwitchToSlave newSwitchToSlaveSpy() {
        Response response = (Response)Mockito.mock(Response.class);
        Mockito.when((Object)response.response()).thenReturn((Object)new HandshakeResult(42L, 2L));
        Mockito.when((Object)this.masterClient.handshake(Matchers.anyLong(), (StoreId)Matchers.any(StoreId.class))).thenReturn((Object)response);
        Mockito.when((Object)this.masterClient.getProtocolVersion()).thenReturn((Object)MasterClient214.PROTOCOL_VERSION);
        MasterClientResolver masterClientResolver = (MasterClientResolver)Mockito.mock(MasterClientResolver.class);
        Mockito.when((Object)masterClientResolver.instantiate(Matchers.anyString(), Matchers.anyInt(), Matchers.anyString(), (Monitors)Matchers.any(Monitors.class), (StoreId)Matchers.any(StoreId.class), (LifeSupport)Matchers.any(LifeSupport.class))).thenReturn((Object)this.masterClient);
        return (SwitchToSlave)Mockito.spy((Object)new SwitchToSlave(ConsoleLogger.DEV_NULL, this.configMock(), this.neoStoreDataSource.getDependencyResolver(), (HaIdGeneratorFactory)Mockito.mock(HaIdGeneratorFactory.class), (Logging)new DevNullLoggingService(), (DelegateInvocationHandler)Mockito.mock(DelegateInvocationHandler.class), (ClusterMemberAvailability)Mockito.mock(ClusterMemberAvailability.class), (RequestContextFactory)Mockito.mock(RequestContextFactory.class), Iterables.empty(), masterClientResolver, this.updatePuller, this.pullerFactory, ByteCounterMonitor.NULL, (RequestMonitor)Mockito.mock(RequestMonitor.class), (SwitchToSlave.Monitor)Mockito.mock(SwitchToSlave.Monitor.class), (StoreCopyClient.Monitor)new StoreCopyClient.Monitor.Adapter()));
    }

    private NeoStoreDataSource dataSourceMock() {
        NeoStoreDataSource dataSource = (NeoStoreDataSource)Mockito.mock(NeoStoreDataSource.class);
        Mockito.when((Object)dataSource.getStoreId()).thenReturn((Object)this.storeId);
        DependencyResolver dependencyResolver = this.dependencyResolverMock();
        Mockito.when((Object)dataSource.getDependencyResolver()).thenReturn((Object)dependencyResolver);
        Mockito.when((Object)dependencyResolver.resolveDependency(NeoStoreDataSource.class)).thenReturn((Object)dataSource);
        return dataSource;
    }

    private Config configMock() {
        Config config = (Config)Mockito.mock(Config.class);
        Mockito.when((Object)config.get(HaSettings.branched_data_policy)).thenReturn(Mockito.mock(BranchedDataPolicy.class));
        Mockito.when((Object)config.get(InternalAbstractGraphDatabase.Configuration.store_dir)).thenReturn(Mockito.mock(File.class));
        Mockito.when((Object)config.get(HaSettings.lock_read_timeout)).thenReturn((Object)42L);
        Mockito.when((Object)config.get(HaSettings.com_chunk_size)).thenReturn((Object)42L);
        return config;
    }

    private DependencyResolver dependencyResolverMock() {
        DependencyResolver resolver = (DependencyResolver)Mockito.mock(DependencyResolver.class);
        Mockito.when((Object)resolver.resolveDependency(StoreLockerLifecycleAdapter.class)).thenReturn((Object)this.mockWithLifecycle(StoreLockerLifecycleAdapter.class));
        Mockito.when((Object)resolver.resolveDependency(DataSourceManager.class)).thenReturn((Object)this.mockWithLifecycle(DataSourceManager.class));
        Mockito.when((Object)resolver.resolveDependency(RequestContextFactory.class)).thenReturn((Object)this.mockWithLifecycle(RequestContextFactory.class));
        Mockito.when((Object)resolver.resolveDependency(TransactionCommittingResponseUnpacker.class)).thenReturn((Object)this.mockWithLifecycle(TransactionCommittingResponseUnpacker.class));
        Mockito.when((Object)resolver.resolveDependency(IndexConfigStore.class)).thenReturn((Object)this.mockWithLifecycle(IndexConfigStore.class));
        Mockito.when((Object)resolver.resolveDependency(OnlineBackupKernelExtension.class)).thenReturn((Object)this.mockWithLifecycle(OnlineBackupKernelExtension.class));
        Mockito.when((Object)resolver.resolveDependency(FileSystemAbstraction.class)).thenReturn((Object)this.fs);
        Mockito.when((Object)resolver.resolveDependency(UpdatePuller.class)).thenReturn((Object)this.updatePuller);
        TransactionIdStore transactionIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        Mockito.when((Object)transactionIdStore.getLastCommittedTransaction()).thenReturn((Object)new TransactionId(42L, 42L));
        Mockito.when((Object)transactionIdStore.getLastCommittedTransactionId()).thenReturn((Object)1L);
        Mockito.when((Object)resolver.resolveDependency(TransactionIdStore.class)).thenReturn((Object)transactionIdStore);
        ClusterMembers clusterMembers = (ClusterMembers)Mockito.mock(ClusterMembers.class);
        ClusterMember master = (ClusterMember)Mockito.mock(ClusterMember.class);
        Mockito.when((Object)master.getStoreId()).thenReturn((Object)this.storeId);
        Mockito.when((Object)master.getHARole()).thenReturn((Object)"master");
        Mockito.when((Object)master.hasRole((String)Matchers.eq((Object)"master"))).thenReturn((Object)true);
        Mockito.when((Object)master.getInstanceId()).thenReturn((Object)new InstanceId(1));
        Mockito.when((Object)clusterMembers.getMembers()).thenReturn(Collections.singleton(master));
        Mockito.when((Object)resolver.resolveDependency(ClusterMembers.class)).thenReturn((Object)clusterMembers);
        return resolver;
    }

    private <T> T mockWithLifecycle(Class<T> clazz) {
        return (T)Mockito.mock(clazz, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Lifecycle.class}));
    }
}

