/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.lock;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.Clock;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.lock.SlaveLockManager;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.community.CommunityLockManger;

public class SlaveLockManagerTest {
    private RequestContextFactory requestContextFactory;
    private Master master;
    private AvailabilityGuard availabilityGuard;
    private long availabilityTimeoutMillis;

    @Before
    public void setUp() {
        this.requestContextFactory = new RequestContextFactory(1, (DependencyResolver)Mockito.mock(DependencyResolver.class));
        this.master = (Master)Mockito.mock(Master.class);
        this.availabilityGuard = new AvailabilityGuard(Clock.SYSTEM_CLOCK);
        this.availabilityTimeoutMillis = 1000L;
    }

    @Test
    public void shutsDownLocalLocks() throws Throwable {
        Locks localLocks = (Locks)Mockito.mock(Locks.class);
        SlaveLockManager slaveLockManager = this.newSlaveLockManager(localLocks);
        slaveLockManager.shutdown();
        ((Locks)Mockito.verify((Object)localLocks)).shutdown();
    }

    @Test
    public void doesNotCreateClientsAfterShutdown() throws Throwable {
        SlaveLockManager slaveLockManager = this.newSlaveLockManager((Locks)new CommunityLockManger());
        Assert.assertNotNull((Object)slaveLockManager.newClient());
        slaveLockManager.shutdown();
        try {
            slaveLockManager.newClient();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    private SlaveLockManager newSlaveLockManager(Locks localLocks) {
        return new SlaveLockManager(localLocks, this.requestContextFactory, this.master, this.availabilityGuard, this.availabilityTimeoutMillis);
    }
}

