/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.ha;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.client.Clusters;
import org.neo4j.cluster.client.ClustersXMLSerializer;
import org.neo4j.cluster.com.NetworkReceiver;
import org.neo4j.cluster.com.NetworkSender;
import org.neo4j.cluster.member.ClusterMemberEvents;
import org.neo4j.cluster.member.ClusterMemberListener;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectInputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectOutputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectStreamFactory;
import org.neo4j.cluster.protocol.cluster.Cluster;
import org.neo4j.cluster.protocol.election.ElectionCredentialsProvider;
import org.neo4j.cluster.protocol.election.NotElectableElectionCredentialsProvider;
import org.neo4j.cluster.protocol.heartbeat.Heartbeat;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.ha.cluster.member.ClusterMember;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.kernel.ha.cluster.member.ObservedClusterMembers;
import org.neo4j.kernel.ha.com.master.Slaves;
import org.neo4j.kernel.impl.transaction.log.LogRotationControl;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.logging.LogbackWeakDependency;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;
import org.w3c.dom.Document;

public class ClusterManager
extends LifecycleAdapter {
    private static final int CLUSTER_MIN_PORT = 10000;
    private static final int CLUSTER_MAX_PORT = 20000;
    private static final int HA_MIN_PORT = 20001;
    private static final int HA_MAX_PORT = 30001;
    public static final int NF_OUT = 1;
    public static final int NF_IN = 2;
    public static final Map<String, String> CONFIG_FOR_SINGLE_JVM_CLUSTER = Collections.unmodifiableMap(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.pagecache_memory.name(), "8m"}));
    private final String localAddress;
    private final File root;
    private final Map<String, String> commonConfig;
    private final Map<Integer, Map<String, String>> instanceConfig;
    private final Map<String, ManagedCluster> clusterMap = new HashMap<String, ManagedCluster>();
    private final Provider clustersProvider;
    private final HighlyAvailableGraphDatabaseFactory dbFactory;
    private final StoreDirInitializer storeDirInitializer;
    LifeSupport life;

    public ClusterManager(Provider clustersProvider, File root, Map<String, String> commonConfig, Map<Integer, Map<String, String>> instanceConfig, HighlyAvailableGraphDatabaseFactory dbFactory) {
        this.localAddress = ClusterManager.getLocalAddress();
        this.clustersProvider = clustersProvider;
        this.root = root;
        this.commonConfig = this.withDefaults(commonConfig);
        this.instanceConfig = instanceConfig;
        this.dbFactory = dbFactory;
        this.storeDirInitializer = null;
    }

    public ClusterManager(Builder builder) {
        this.localAddress = ClusterManager.getLocalAddress();
        this.clustersProvider = builder.provider;
        this.root = builder.root;
        this.commonConfig = this.withDefaults(builder.commonConfig);
        this.instanceConfig = builder.instanceConfig;
        this.dbFactory = builder.factory;
        this.storeDirInitializer = builder.initializer;
    }

    private Map<String, String> withDefaults(Map<String, String> commonConfig) {
        HashMap<String, String> result = new HashMap<String, String>(CONFIG_FOR_SINGLE_JVM_CLUSTER);
        result.putAll(commonConfig);
        return result;
    }

    public ClusterManager(Provider clustersProvider, File root, Map<String, String> commonConfig, Map<Integer, Map<String, String>> instanceConfig) {
        this(clustersProvider, root, commonConfig, instanceConfig, new HighlyAvailableGraphDatabaseFactory());
    }

    public ClusterManager(Provider clustersProvider, File root, Map<String, String> commonConfig) {
        this(clustersProvider, root, commonConfig, Collections.emptyMap(), new HighlyAvailableGraphDatabaseFactory());
    }

    public static Provider fromXml(final URI clustersXml) {
        return new Provider(){

            @Override
            public Clusters clusters() throws Exception {
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document clustersXmlDoc = documentBuilder.parse(clustersXml.toURL().openStream());
                return new ClustersXMLSerializer(documentBuilder).read(clustersXmlDoc);
            }
        };
    }

    private static String getLocalAddress() {
        try {
            return InetAddress.getByName(null).getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static Provider clusterOfSize(int memberCount) {
        return ClusterManager.clusterOfSize(ClusterManager.getLocalAddress(), memberCount);
    }

    public static Provider clusterOfSize(String hostname, int memberCount) {
        return ClusterManager.clustersOfSize(Pair.of((Object)hostname, (Object)memberCount));
    }

    public static Provider clustersOfSize(int ... clusterSizes) {
        Pair[] clusters = new Pair[clusterSizes.length];
        for (int i = 0; i < clusterSizes.length; ++i) {
            clusters[i] = Pair.of((Object)ClusterManager.getLocalAddress(), (Object)clusterSizes[i]);
        }
        return ClusterManager.clustersOfSize(clusters);
    }

    public static Provider clustersOfSize(Pair<String, Integer> ... clusterHostsAndSizes) {
        Clusters clusters = new Clusters();
        HashSet<Integer> takenPorts = new HashSet<Integer>();
        for (int clusterCount = 0; clusterCount < clusterHostsAndSizes.length; ++clusterCount) {
            Clusters.Cluster cluster = clusterCount == 0 ? new Clusters.Cluster("neo4j.ha") : new Clusters.Cluster("neo4j.ha" + clusterCount);
            String hostname = (String)clusterHostsAndSizes[clusterCount].first();
            int memberCount = (Integer)clusterHostsAndSizes[clusterCount].other();
            try {
                for (int i = 0; i < memberCount; ++i) {
                    int port = ClusterManager.findFreePort(10000, 20000, takenPorts);
                    takenPorts.add(port);
                    cluster.getMembers().add(new Clusters.Member(hostname + ":" + port, true));
                }
                clusters.getClusters().add(cluster);
                continue;
            }
            catch (IOException e) {
                throw new AssertionError((Object)"Failed to find an open port");
            }
        }
        return ClusterManager.provided(clusters);
    }

    private static int findFreePort(int minPort, int maxPort, Set<Integer> except) throws IOException {
        for (int port = minPort; port <= maxPort; ++port) {
            if (except.contains(port)) continue;
            try {
                ServerSocket socket = new ServerSocket(port);
                socket.close();
                return port;
            }
            catch (IOException ex) {
                except.add(port);
            }
        }
        throw new IOException("No open port could be found");
    }

    public static Provider clusterWithAdditionalClients(int haMemberCount, int additionalClientCount) {
        Clusters.Cluster cluster = new Clusters.Cluster("neo4j.ha");
        HashSet<Integer> takenPorts = new HashSet<Integer>();
        try {
            int port;
            int i;
            for (i = 0; i < haMemberCount; ++i) {
                port = ClusterManager.findFreePort(10000, 20000, takenPorts);
                takenPorts.add(port);
                cluster.getMembers().add(new Clusters.Member(port, true));
            }
            for (i = 0; i < additionalClientCount; ++i) {
                port = ClusterManager.findFreePort(10000, 20000, takenPorts);
                takenPorts.add(port);
                cluster.getMembers().add(new Clusters.Member(port, false));
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)"Failed to find an open port");
        }
        Clusters clusters = new Clusters();
        clusters.getClusters().add(cluster);
        return ClusterManager.provided(clusters);
    }

    public static Provider clusterWithAdditionalArbiters(int haMemberCount, int arbiterCount) {
        Clusters.Cluster cluster = new Clusters.Cluster("neo4j.ha");
        HashSet<Integer> takenPorts = new HashSet<Integer>();
        try {
            int port;
            int i;
            for (i = 0; i < arbiterCount; ++i) {
                port = ClusterManager.findFreePort(10000, 20000, takenPorts);
                takenPorts.add(port);
                cluster.getMembers().add(new Clusters.Member(port, false));
            }
            for (i = 0; i < haMemberCount; ++i) {
                port = ClusterManager.findFreePort(10000, 20000, takenPorts);
                takenPorts.add(port);
                cluster.getMembers().add(new Clusters.Member(port, true));
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)"Failed to find an open port");
        }
        Clusters clusters = new Clusters();
        clusters.getClusters().add(cluster);
        return ClusterManager.provided(clusters);
    }

    public static Provider provided(final Clusters clusters) {
        return new Provider(){

            @Override
            public Clusters clusters() throws Throwable {
                return clusters;
            }
        };
    }

    public static Predicate<ManagedCluster> masterSeesSlavesAsAvailable(final int count) {
        return new Predicate<ManagedCluster>(){

            public boolean accept(ManagedCluster cluster) {
                return Iterables.count((Iterable)((Slaves)cluster.getMaster().getDependencyResolver().resolveDependency(Slaves.class)).getSlaves()) >= (long)count;
            }

            public String toString() {
                return "Master should see " + count + " slaves as available";
            }
        };
    }

    public static Predicate<ManagedCluster> masterSeesAllSlavesAsAvailable() {
        return new Predicate<ManagedCluster>(){

            public boolean accept(ManagedCluster cluster) {
                return Iterables.count((Iterable)((Slaves)cluster.getMaster().getDependencyResolver().resolveDependency(Slaves.class)).getSlaves()) >= (long)(cluster.size() - 1);
            }

            public String toString() {
                return "Master should see all slaves as available";
            }
        };
    }

    public static Predicate<ManagedCluster> masterAvailable(HighlyAvailableGraphDatabase ... except) {
        final HashSet<HighlyAvailableGraphDatabase> exceptSet = new HashSet<HighlyAvailableGraphDatabase>(Arrays.asList(except));
        return new Predicate<ManagedCluster>(){

            public boolean accept(ManagedCluster cluster) {
                for (HighlyAvailableGraphDatabase graphDatabaseService : cluster.getAllMembers()) {
                    if (exceptSet.contains(graphDatabaseService) || !graphDatabaseService.isAvailable(0L) || !graphDatabaseService.isMaster()) continue;
                    return true;
                }
                return false;
            }

            public String toString() {
                return "There's an available master";
            }
        };
    }

    public static Predicate<ManagedCluster> masterSeesMembers(final int count) {
        return new Predicate<ManagedCluster>(){

            public boolean accept(ManagedCluster cluster) {
                ClusterMembers members = (ClusterMembers)cluster.getMaster().getDependencyResolver().resolveDependency(ClusterMembers.class);
                return Iterables.count((Iterable)members.getMembers()) == (long)count;
            }

            public String toString() {
                return "Master should see " + count + " members";
            }
        };
    }

    public static Predicate<ManagedCluster> allSeesAllAsAvailable() {
        return new Predicate<ManagedCluster>(){

            public boolean accept(ManagedCluster cluster) {
                if (!ClusterManager.allSeesAllAsJoined().accept((Object)cluster)) {
                    return false;
                }
                for (HighlyAvailableGraphDatabase database : cluster.getAllMembers()) {
                    ClusterMembers members = (ClusterMembers)database.getDependencyResolver().resolveDependency(ClusterMembers.class);
                    for (ClusterMember clusterMember : members.getMembers()) {
                        if (!clusterMember.getHARole().equals("UNKNOWN")) continue;
                        return false;
                    }
                }
                for (HighlyAvailableGraphDatabase database : cluster.getAllMembers()) {
                    StringLogger logger = (StringLogger)database.getDependencyResolver().resolveDependency(StringLogger.class);
                    logger.debug(this.toString());
                }
                return true;
            }

            public String toString() {
                return "All instances should see all others as available";
            }
        };
    }

    public static Predicate<ManagedCluster> allSeesAllAsJoined() {
        return new Predicate<ManagedCluster>(){

            public boolean accept(ManagedCluster cluster) {
                int nrOfMembers = cluster.spec.getMembers().size();
                for (HighlyAvailableGraphDatabase database : cluster.getAllMembers()) {
                    ClusterMembers members = (ClusterMembers)database.getDependencyResolver().resolveDependency(ClusterMembers.class);
                    if (Iterables.count((Iterable)members.getMembers()) >= (long)nrOfMembers) continue;
                    return false;
                }
                for (ObservedClusterMembers clusterMembers : cluster.getArbiters()) {
                    if (Iterables.count((Iterable)clusterMembers.getMembers()) >= (long)nrOfMembers) continue;
                    return false;
                }
                return true;
            }

            public String toString() {
                return "All instances should see all others as joined";
            }
        };
    }

    public static Predicate<ManagedCluster> allAvailabilityGuardsReleased() {
        return new Predicate<ManagedCluster>(){

            public boolean accept(ManagedCluster item) {
                for (HighlyAvailableGraphDatabaseProxy member : item.members.values()) {
                    try {
                        member.get().beginTx().close();
                    }
                    catch (TransactionFailureException e) {
                        return false;
                    }
                }
                return true;
            }
        };
    }

    public static Predicate<ManagedCluster> memberSeesOtherMemberAsFailed(final HighlyAvailableGraphDatabase observer, final HighlyAvailableGraphDatabase observed) {
        return new Predicate<ManagedCluster>(){

            public boolean accept(ManagedCluster cluster) {
                InstanceId observedServerId = (InstanceId)((Config)observed.getDependencyResolver().resolveDependency(Config.class)).get(ClusterSettings.server_id);
                for (ClusterMember member : ((ClusterMembers)observer.getDependencyResolver().resolveDependency(ClusterMembers.class)).getMembers()) {
                    if (!member.getInstanceId().equals((Object)observedServerId)) continue;
                    return !member.isAlive();
                }
                throw new IllegalStateException(observed + " not a member according to " + observer);
            }
        };
    }

    public static Predicate<ManagedCluster> memberThinksItIsRole(final HighlyAvailableGraphDatabase member, final String role) {
        return new Predicate<ManagedCluster>(){

            public boolean accept(ManagedCluster cluster) {
                return role.equals(member.role());
            }
        };
    }

    public static String stateToString(ManagedCluster cluster) {
        StringBuilder buf = new StringBuilder("\n");
        for (HighlyAvailableGraphDatabase database : cluster.getAllMembers()) {
            ClusterClient client = (ClusterClient)database.getDependencyResolver().resolveDependency(ClusterClient.class);
            buf.append("Instance ").append(client.getServerId()).append(":State ").append(database.getInstanceState()).append(" (").append(client.getClusterServer()).append("):").append("\n");
            ClusterMembers members = (ClusterMembers)database.getDependencyResolver().resolveDependency(ClusterMembers.class);
            for (ClusterMember clusterMember : members.getMembers()) {
                buf.append("  ").append(clusterMember.getInstanceId()).append(":").append(clusterMember.getHARole()).append(" (is alive = ").append(clusterMember.isAlive()).append(")").append("\n");
            }
        }
        return buf.toString();
    }

    public void start() throws Throwable {
        Clusters clusters = this.clustersProvider.clusters();
        this.life = new LifeSupport();
        this.life.start();
        for (int i = 0; i < clusters.getClusters().size(); ++i) {
            Clusters.Cluster cluster = (Clusters.Cluster)clusters.getClusters().get(i);
            ManagedCluster managedCluster = new ManagedCluster(cluster);
            this.clusterMap.put(cluster.getName(), managedCluster);
            this.life.add((Lifecycle)managedCluster);
        }
    }

    public void stop() throws Throwable {
        this.life.stop();
    }

    public void shutdown() throws Throwable {
        this.life.shutdown();
    }

    public void safeShutdown() {
        try {
            this.shutdown();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private <T> T instance(Class<T> classToFind, Iterable<?> from) {
        for (Object item : from) {
            if (!classToFind.isAssignableFrom(item.getClass())) continue;
            return (T)item;
        }
        throw new AssertionError((Object)"Couldn't find the network instance to fail. Internal field, so fragile sensitive to changes though");
    }

    private Field accessible(Field field) {
        field.setAccessible(true);
        return field;
    }

    public ManagedCluster getCluster(String name) {
        if (!this.clusterMap.containsKey(name)) {
            throw new IllegalArgumentException(name);
        }
        return this.clusterMap.get(name);
    }

    public ManagedCluster getDefaultCluster() {
        return this.getCluster("neo4j.ha");
    }

    protected void config(GraphDatabaseBuilder builder, String clusterName, InstanceId serverId) {
    }

    protected void insertInitialData(GraphDatabaseService db, String name, InstanceId serverId) {
    }

    private class StartDatabaseAgainKit
    implements RepairKit {
        private final InstanceId serverId;
        private final ManagedCluster cluster;

        public StartDatabaseAgainKit(ManagedCluster cluster, InstanceId serverId) {
            this.cluster = cluster;
            this.serverId = serverId;
        }

        @Override
        public HighlyAvailableGraphDatabase repair() throws Throwable {
            this.cluster.startMember(this.serverId);
            return this.cluster.getMemberByServerId(this.serverId);
        }
    }

    private class StartNetworkAgainKit
    implements RepairKit {
        private final HighlyAvailableGraphDatabase db;
        private final NetworkReceiver networkReceiver;
        private final NetworkSender networkSender;
        private final NetworkFlag[] flags;

        StartNetworkAgainKit(HighlyAvailableGraphDatabase db, NetworkReceiver networkReceiver, NetworkSender networkSender, NetworkFlag ... flags) {
            this.db = db;
            this.networkReceiver = networkReceiver;
            this.networkSender = networkSender;
            this.flags = flags;
        }

        @Override
        public HighlyAvailableGraphDatabase repair() throws Throwable {
            if (ArrayUtil.contains((Object[])this.flags, (Object)((Object)NetworkFlag.OUT))) {
                this.networkSender.setPaused(false);
            }
            if (ArrayUtil.contains((Object[])this.flags, (Object)((Object)NetworkFlag.IN))) {
                this.networkReceiver.setPaused(false);
            }
            return this.db;
        }
    }

    public class ManagedCluster
    extends LifecycleAdapter {
        private final Clusters.Cluster spec;
        private final String name;
        private final Map<InstanceId, HighlyAvailableGraphDatabaseProxy> members = new ConcurrentHashMap<InstanceId, HighlyAvailableGraphDatabaseProxy>();
        private final List<ObservedClusterMembers> arbiters = new ArrayList<ObservedClusterMembers>();
        private final HashSet<Integer> takenHaPorts = new HashSet();

        ManagedCluster(Clusters.Cluster spec) throws URISyntaxException, IOException {
            this.spec = spec;
            this.name = spec.getName();
            for (int i = 0; i < spec.getMembers().size(); ++i) {
                this.startMember(new InstanceId(i + 1));
            }
            for (HighlyAvailableGraphDatabaseProxy member : this.members.values()) {
                ClusterManager.this.insertInitialData((GraphDatabaseService)member.get(), this.name, (InstanceId)member.get().getConfig().get(ClusterSettings.server_id));
            }
        }

        public String getInitialHostsConfigString() {
            StringBuilder result = new StringBuilder();
            for (HighlyAvailableGraphDatabase member : this.getAllMembers()) {
                result.append(result.length() > 0 ? "," : "").append(ClusterManager.this.localAddress).append(":").append(((ClusterClient)member.getDependencyResolver().resolveDependency(ClusterClient.class)).getClusterServer().getPort());
            }
            return result.toString();
        }

        public void stop() throws Throwable {
            for (HighlyAvailableGraphDatabaseProxy member : this.members.values()) {
                member.get().shutdown();
            }
        }

        public Iterable<HighlyAvailableGraphDatabase> getAllMembers() {
            return Iterables.map((org.neo4j.function.Function)new Function<HighlyAvailableGraphDatabaseProxy, HighlyAvailableGraphDatabase>(){

                public HighlyAvailableGraphDatabase apply(HighlyAvailableGraphDatabaseProxy from) {
                    return from.get();
                }
            }, this.members.values());
        }

        public Iterable<ObservedClusterMembers> getArbiters() {
            return this.arbiters;
        }

        public HighlyAvailableGraphDatabase getMaster() {
            for (HighlyAvailableGraphDatabase graphDatabaseService : this.getAllMembers()) {
                if (!graphDatabaseService.isAvailable(0L) || !graphDatabaseService.isMaster()) continue;
                return graphDatabaseService;
            }
            throw new IllegalStateException("No master found in cluster " + this.name + ClusterManager.stateToString(this));
        }

        public HighlyAvailableGraphDatabase getAnySlave(HighlyAvailableGraphDatabase ... except) {
            HashSet<HighlyAvailableGraphDatabase> exceptSet = new HashSet<HighlyAvailableGraphDatabase>(Arrays.asList(except));
            for (HighlyAvailableGraphDatabase graphDatabaseService : this.getAllMembers()) {
                if (graphDatabaseService.getInstanceState() != HighAvailabilityMemberState.SLAVE || exceptSet.contains(graphDatabaseService)) continue;
                return graphDatabaseService;
            }
            throw new IllegalStateException("No slave found in cluster " + this.name + ClusterManager.stateToString(this));
        }

        public HighlyAvailableGraphDatabase getMemberByServerId(InstanceId serverId) {
            HighlyAvailableGraphDatabase db = this.members.get(serverId).get();
            if (db == null) {
                throw new IllegalStateException("Db " + serverId + " not found at the moment in " + this.name + ClusterManager.stateToString(this));
            }
            return db;
        }

        public RepairKit shutdown(HighlyAvailableGraphDatabase db) {
            this.assertMember(db);
            InstanceId serverId = (InstanceId)((Config)db.getDependencyResolver().resolveDependency(Config.class)).get(ClusterSettings.server_id);
            this.members.remove(serverId);
            ClusterManager.this.life.remove((Object)db);
            db.shutdown();
            return new StartDatabaseAgainKit(this, serverId);
        }

        private void assertMember(HighlyAvailableGraphDatabase db) {
            for (HighlyAvailableGraphDatabaseProxy highlyAvailableGraphDatabaseProxy : this.members.values()) {
                if (!highlyAvailableGraphDatabaseProxy.get().equals((Object)db)) continue;
                return;
            }
            throw new IllegalArgumentException("Db " + db + " not a member of this cluster " + this.name + ClusterManager.stateToString(this));
        }

        public RepairKit fail(HighlyAvailableGraphDatabase db) throws Throwable {
            return this.fail(db, NetworkFlag.values());
        }

        public RepairKit fail(HighlyAvailableGraphDatabase db, NetworkFlag ... flags) throws Throwable {
            this.assertMember(db);
            ClusterClient clusterClient = (ClusterClient)db.getDependencyResolver().resolveDependency(ClusterClient.class);
            LifeSupport clusterClientLife = (LifeSupport)ClusterManager.this.accessible(clusterClient.getClass().getDeclaredField("life")).get(clusterClient);
            NetworkReceiver networkReceiver = (NetworkReceiver)ClusterManager.this.instance(NetworkReceiver.class, clusterClientLife.getLifecycleInstances());
            NetworkSender networkSender = (NetworkSender)ClusterManager.this.instance(NetworkSender.class, clusterClientLife.getLifecycleInstances());
            if (ArrayUtil.contains((Object[])flags, (Object)((Object)NetworkFlag.IN))) {
                networkReceiver.setPaused(true);
            }
            if (ArrayUtil.contains((Object[])flags, (Object)((Object)NetworkFlag.OUT))) {
                networkSender.setPaused(true);
            }
            return new StartNetworkAgainKit(db, networkReceiver, networkSender, flags);
        }

        private void startMember(InstanceId serverId) throws URISyntaxException, IOException {
            Clusters.Member member = (Clusters.Member)this.spec.getMembers().get(serverId.toIntegerIndex() - 1);
            StringBuilder initialHosts = new StringBuilder();
            for (int i = 0; i < this.spec.getMembers().size(); ++i) {
                URI uri;
                if (i > 0) {
                    initialHosts.append(",");
                }
                if ((uri = new URI("cluster://" + ((Clusters.Member)this.spec.getMembers().get(i)).getHost())).getHost() == null || uri.getHost().isEmpty() || uri.getHost().equals("0.0.0.0")) {
                    initialHosts.append(ClusterManager.this.localAddress).append(":").append(uri.getPort());
                    continue;
                }
                initialHosts.append(uri.getHost()).append(":").append(uri.getPort());
            }
            File parent = new File(ClusterManager.this.root, this.name);
            URI clusterUri = new URI("cluster://" + member.getHost());
            if (member.isFullHaMember()) {
                int clusterPort = clusterUri.getPort();
                int haPort = ClusterManager.findFreePort(20001, 30001, this.takenHaPorts);
                this.takenHaPorts.add(haPort);
                File storeDir = new File(parent, "server" + serverId);
                if (ClusterManager.this.storeDirInitializer != null) {
                    ClusterManager.this.storeDirInitializer.initializeStoreDir(serverId.toIntegerIndex(), storeDir);
                }
                GraphDatabaseBuilder builder = ClusterManager.this.dbFactory.newHighlyAvailableDatabaseBuilder(storeDir.getAbsolutePath());
                builder.setConfig(ClusterSettings.cluster_name, this.name);
                builder.setConfig(ClusterSettings.initial_hosts, initialHosts.toString());
                builder.setConfig(ClusterSettings.server_id, serverId + "");
                builder.setConfig(ClusterSettings.cluster_server, "0.0.0.0:" + clusterPort);
                builder.setConfig(HaSettings.ha_server, clusterUri.getHost() + ":" + haPort);
                builder.setConfig(OnlineBackupSettings.online_backup_enabled, "false");
                builder.setConfig(ClusterManager.this.commonConfig);
                if (ClusterManager.this.instanceConfig.containsKey(serverId.toIntegerIndex())) {
                    builder.setConfig((Map)ClusterManager.this.instanceConfig.get(serverId.toIntegerIndex()));
                }
                ClusterManager.this.config(builder, this.name, serverId);
                final HighlyAvailableGraphDatabaseProxy graphDatabase = new HighlyAvailableGraphDatabaseProxy(builder);
                this.members.put(serverId, graphDatabase);
                ClusterManager.this.life.add((Lifecycle)new LifecycleAdapter(){

                    public void stop() throws Throwable {
                        graphDatabase.get().shutdown();
                    }
                });
            } else {
                Map config = MapUtil.stringMap((String[])new String[]{ClusterSettings.cluster_name.name(), this.name, ClusterSettings.initial_hosts.name(), initialHosts.toString(), ClusterSettings.server_id.name(), serverId + "", ClusterSettings.cluster_server.name(), "0.0.0.0:" + clusterUri.getPort(), GraphDatabaseSettings.store_dir.name(), new File(parent, "arbiter" + serverId).getAbsolutePath()});
                Config config1 = new Config(config, new Class[]{InternalAbstractGraphDatabase.Configuration.class, GraphDatabaseSettings.class});
                Logging clientLogging = (Logging)ClusterManager.this.life.add((Lifecycle)LogbackWeakDependency.tryLoadLogbackService((Config)config1, (Function)LogbackWeakDependency.NEW_LOGGER_CONTEXT, (Function)LogbackWeakDependency.DEFAULT_TO_CLASSIC, (Monitors)new Monitors()));
                ObjectStreamFactory objectStreamFactory = new ObjectStreamFactory();
                ClusterClient clusterClient = new ClusterClient(new Monitors(), ClusterClient.adapt((Config)config1), clientLogging, (ElectionCredentialsProvider)new NotElectableElectionCredentialsProvider(), (ObjectInputStreamFactory)objectStreamFactory, (ObjectOutputStreamFactory)objectStreamFactory);
                this.arbiters.add(new ObservedClusterMembers(clientLogging, (Cluster)clusterClient, (Heartbeat)clusterClient, new ClusterMemberEvents(){

                    public void addClusterMemberListener(ClusterMemberListener listener) {
                    }

                    public void removeClusterMemberListener(ClusterMemberListener listener) {
                    }
                }, clusterClient.getServerId()));
                ClusterManager.this.life.add(new FutureLifecycleAdapter<ClusterClient>(clusterClient));
            }
        }

        public void await(Predicate<ManagedCluster> predicate) {
            this.await(predicate, 60);
        }

        public void await(Predicate<ManagedCluster> predicate, int maxSeconds) {
            long end = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(maxSeconds);
            while (System.currentTimeMillis() < end) {
                if (predicate.accept((Object)this)) {
                    return;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            String state = ClusterManager.stateToString(this);
            throw new IllegalStateException(String.format("Awaited condition never met, waited %s secondes for %s:%n%s", maxSeconds, predicate, state));
        }

        public int size() {
            return this.spec.getMembers().size();
        }

        public InstanceId getServerId(HighlyAvailableGraphDatabase member) {
            this.assertMember(member);
            return (InstanceId)member.getConfig().get(ClusterSettings.server_id);
        }

        public File getStoreDir(HighlyAvailableGraphDatabase member) {
            this.assertMember(member);
            return (File)member.getConfig().get(GraphDatabaseSettings.store_dir);
        }

        public void sync(HighlyAvailableGraphDatabase ... except) throws InterruptedException {
            HashSet<HighlyAvailableGraphDatabase> exceptSet = new HashSet<HighlyAvailableGraphDatabase>(Arrays.asList(except));
            for (HighlyAvailableGraphDatabase db : this.getAllMembers()) {
                if (exceptSet.contains(db)) continue;
                UpdatePuller updatePuller = (UpdatePuller)db.getDependencyResolver().resolveDependency(UpdatePuller.class);
                try {
                    if (!db.isAvailable(60000L)) continue;
                    updatePuller.pullUpdates();
                }
                catch (Exception e) {
                    throw new IllegalStateException(ClusterManager.stateToString(this), e);
                }
            }
        }

        public void force(HighlyAvailableGraphDatabase ... except) {
            HashSet<HighlyAvailableGraphDatabase> exceptSet = new HashSet<HighlyAvailableGraphDatabase>(Arrays.asList(except));
            for (HighlyAvailableGraphDatabase db : this.getAllMembers()) {
                if (exceptSet.contains(db)) continue;
                ((LogRotationControl)db.getDependencyResolver().resolveDependency(LogRotationControl.class)).forceEverything();
            }
        }

        public void info(String message) {
            for (HighlyAvailableGraphDatabase db : this.getAllMembers()) {
                Logging logging = (Logging)db.getDependencyResolver().resolveDependency(Logging.class);
                StringLogger messagesLog = logging.getMessagesLog(HighlyAvailableGraphDatabase.class);
                messagesLog.info(message);
            }
        }

        public void applyOnAll(org.neo4j.function.Function<GraphDatabaseService, Void> function) {
            for (HighlyAvailableGraphDatabase db : this.getAllMembers()) {
                function.apply((Object)db);
            }
        }
    }

    private static final class FutureLifecycleAdapter<T extends Lifecycle>
    extends LifecycleAdapter {
        private final T wrapped;
        private final ExecutorService starter;
        private Future<Void> currentFuture;

        public FutureLifecycleAdapter(T toWrap) {
            this.wrapped = toWrap;
            this.starter = Executors.newFixedThreadPool(1);
        }

        public void init() throws Throwable {
            this.currentFuture = this.starter.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        FutureLifecycleAdapter.this.wrapped.init();
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException(throwable);
                    }
                    return null;
                }
            });
        }

        public void start() throws Throwable {
            this.currentFuture.get();
            this.currentFuture = this.starter.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        FutureLifecycleAdapter.this.wrapped.start();
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException(throwable);
                    }
                    return null;
                }
            });
        }

        public void stop() throws Throwable {
            this.currentFuture.get();
            this.currentFuture = this.starter.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        FutureLifecycleAdapter.this.wrapped.stop();
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException(throwable);
                    }
                    return null;
                }
            });
        }

        public void shutdown() throws Throwable {
            this.currentFuture = this.starter.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        FutureLifecycleAdapter.this.wrapped.shutdown();
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException(throwable);
                    }
                    return null;
                }
            });
            this.currentFuture.get();
            this.starter.shutdownNow();
        }
    }

    private static final class HighlyAvailableGraphDatabaseProxy {
        private final ExecutorService executor;
        private GraphDatabaseService result;
        private Future<GraphDatabaseService> untilThen;

        public HighlyAvailableGraphDatabaseProxy(final GraphDatabaseBuilder graphDatabaseBuilder) {
            Callable<GraphDatabaseService> starter = new Callable<GraphDatabaseService>(){

                @Override
                public GraphDatabaseService call() throws Exception {
                    return graphDatabaseBuilder.newGraphDatabase();
                }
            };
            this.executor = Executors.newFixedThreadPool(1);
            this.untilThen = this.executor.submit(starter);
        }

        public HighlyAvailableGraphDatabase get() {
            if (this.result == null) {
                try {
                    this.result = this.untilThen.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    this.executor.shutdownNow();
                }
            }
            return (HighlyAvailableGraphDatabase)this.result;
        }
    }

    public static class Builder {
        private final File root;
        private final Map<Integer, Map<String, String>> instanceConfig = new HashMap<Integer, Map<String, String>>();
        private Provider provider = null;
        private Map<String, String> commonConfig = Collections.emptyMap();
        private HighlyAvailableGraphDatabaseFactory factory = new HighlyAvailableGraphDatabaseFactory();
        private StoreDirInitializer initializer;

        public Builder(File root) {
            this.root = root;
        }

        public Builder withSeedDir(final File seedDir) {
            return this.withStoreDirInitializer(new StoreDirInitializer(){

                @Override
                public void initializeStoreDir(int serverId, File storeDir) throws IOException {
                    FileUtils.copyRecursively((File)seedDir, (File)storeDir);
                }
            });
        }

        public Builder withStoreDirInitializer(StoreDirInitializer initializer) {
            this.initializer = initializer;
            return this;
        }

        public Builder withDbFactory(HighlyAvailableGraphDatabaseFactory dbFactory) {
            this.factory = dbFactory;
            return this;
        }

        public Builder withProvider(Provider provider) {
            this.provider = provider;
            return this;
        }

        public Builder withCommonConfig(Map<String, String> commonConfig) {
            this.commonConfig = commonConfig;
            return this;
        }

        public Builder withInstanceConfig(int instanceNr, Map<String, String> instanceConfig) {
            this.instanceConfig.put(instanceNr, instanceConfig);
            return this;
        }

        public ClusterManager build() {
            if (this.provider == null) {
                this.provider = ClusterManager.clusterOfSize(3);
            }
            return new ClusterManager(this);
        }
    }

    public static interface RepairKit {
        public HighlyAvailableGraphDatabase repair() throws Throwable;
    }

    public static interface Provider {
        public Clusters clusters() throws Throwable;
    }

    public static interface StoreDirInitializer {
        public void initializeStoreDir(int var1, File var2) throws IOException;
    }

    public static enum NetworkFlag {
        OUT,
        IN;

    }
}

