/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.ha;

import java.net.InetAddress;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.TestHighlyAvailableGraphDatabaseFactory;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.LoggerRule;
import org.neo4j.test.TargetDirectory;

public class ClusterTest {
    @Rule
    public LoggerRule logging = new LoggerRule();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCluster() throws Throwable {
        ClusterManager clusterManager = new ClusterManager(ClusterManager.clusterOfSize(3), TargetDirectory.forTest(this.getClass()).cleanDirectory("testCluster"), MapUtil.stringMap((String[])new String[]{HaSettings.tx_push_factor.name(), "2"}));
        try {
            clusterManager.start();
            clusterManager.getDefaultCluster().await(ClusterManager.allSeesAllAsAvailable());
            HighlyAvailableGraphDatabase master = clusterManager.getDefaultCluster().getMaster();
            Transaction tx = master.beginTx();
            Node node = master.createNode();
            long nodeId = node.getId();
            node.setProperty("foo", (Object)"bar");
            tx.success();
            tx.finish();
            HighlyAvailableGraphDatabase slave = clusterManager.getDefaultCluster().getAnySlave(new HighlyAvailableGraphDatabase[0]);
            Transaction transaction = slave.beginTx();
            try {
                node = slave.getNodeById(nodeId);
                Assert.assertThat((Object)node.getProperty("foo").toString(), (Matcher)CoreMatchers.equalTo((Object)"bar"));
            }
            finally {
                transaction.finish();
            }
        }
        finally {
            clusterManager.safeShutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClusterWithHostnames() throws Throwable {
        String hostName = InetAddress.getLocalHost().getHostName();
        ClusterManager clusterManager = new ClusterManager(ClusterManager.clusterOfSize(hostName, 3), TargetDirectory.forTest(this.getClass()).cleanDirectory("testCluster"), MapUtil.stringMap((String[])new String[]{HaSettings.tx_push_factor.name(), "2"}));
        try {
            clusterManager.start();
            clusterManager.getDefaultCluster().await(ClusterManager.allSeesAllAsAvailable());
            HighlyAvailableGraphDatabase master = clusterManager.getDefaultCluster().getMaster();
            Transaction tx = master.beginTx();
            Node node = master.createNode();
            long nodeId = node.getId();
            node.setProperty("foo", (Object)"bar");
            tx.success();
            tx.finish();
            HighlyAvailableGraphDatabase anySlave = clusterManager.getDefaultCluster().getAnySlave(new HighlyAvailableGraphDatabase[0]);
            try (Transaction ignore = anySlave.beginTx();){
                node = anySlave.getNodeById(nodeId);
                Assert.assertThat((Object)node.getProperty("foo").toString(), (Matcher)CoreMatchers.equalTo((Object)"bar"));
            }
        }
        finally {
            clusterManager.safeShutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClusterWithWildcardIP() throws Throwable {
        ClusterManager clusterManager = new ClusterManager(ClusterManager.clusterOfSize(3), TargetDirectory.forTest(this.getClass()).cleanDirectory("testCluster"), MapUtil.stringMap((String[])new String[]{HaSettings.ha_server.name(), "0.0.0.0:6001-9999", HaSettings.tx_push_factor.name(), "2"}));
        try {
            clusterManager.start();
            clusterManager.getDefaultCluster().await(ClusterManager.allSeesAllAsAvailable());
            HighlyAvailableGraphDatabase master = clusterManager.getDefaultCluster().getMaster();
            Transaction tx = master.beginTx();
            Node node = master.createNode();
            long nodeId = node.getId();
            node.setProperty("foo", (Object)"bar");
            tx.success();
            tx.finish();
            HighlyAvailableGraphDatabase anySlave = clusterManager.getDefaultCluster().getAnySlave(new HighlyAvailableGraphDatabase[0]);
            try (Transaction ignore = anySlave.beginTx();){
                node = anySlave.getNodeById(nodeId);
                Assert.assertThat((Object)node.getProperty("foo").toString(), (Matcher)CoreMatchers.equalTo((Object)"bar"));
            }
        }
        finally {
            clusterManager.safeShutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore(value="JH: Ignored for by CG in March 2013, needs revisit. I added @ignore instead of commenting out to list this in static analysis.")
    public void testArbiterStartsFirstAndThenTwoInstancesJoin() throws Throwable {
        ClusterManager clusterManager = new ClusterManager(ClusterManager.clusterWithAdditionalArbiters(2, 1), TargetDirectory.forTest(this.getClass()).cleanDirectory("testCluster"), MapUtil.stringMap((String[])new String[0]));
        try {
            clusterManager.start();
            clusterManager.getDefaultCluster().await(ClusterManager.allSeesAllAsAvailable());
            HighlyAvailableGraphDatabase master = clusterManager.getDefaultCluster().getMaster();
            Transaction tx = master.beginTx();
            master.createNode();
            tx.success();
            tx.finish();
        }
        finally {
            clusterManager.safeShutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInstancesWithConflictingClusterPorts() throws Throwable {
        HighlyAvailableGraphDatabase first = null;
        try {
            String masterStoreDir = TargetDirectory.forTest(this.getClass()).cleanDirectory("testConflictingClusterPortsMaster").getAbsolutePath();
            first = (HighlyAvailableGraphDatabase)new TestHighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(masterStoreDir).setConfig(ClusterSettings.initial_hosts, "127.0.0.1:5001").setConfig(ClusterSettings.cluster_server, "127.0.0.1:5001").setConfig(ClusterSettings.server_id, "1").setConfig(HaSettings.ha_server, "127.0.0.1:6666").newGraphDatabase();
            try {
                String slaveStoreDir = TargetDirectory.forTest(this.getClass()).cleanDirectory("testConflictingClusterPortsSlave").getAbsolutePath();
                HighlyAvailableGraphDatabase failed = (HighlyAvailableGraphDatabase)new TestHighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(slaveStoreDir).setConfig(ClusterSettings.initial_hosts, "127.0.0.1:5001").setConfig(ClusterSettings.cluster_server, "127.0.0.1:5001").setConfig(ClusterSettings.server_id, "2").setConfig(HaSettings.ha_server, "127.0.0.1:6667").newGraphDatabase();
                failed.shutdown();
                Assert.fail((String)"Should not start when ports conflict");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            if (first != null) {
                first.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInstancesWithConflictingHaPorts() throws Throwable {
        HighlyAvailableGraphDatabase first = null;
        try {
            String storeDir = TargetDirectory.forTest(this.getClass()).cleanDirectory("testConflictingHaPorts").getAbsolutePath();
            first = (HighlyAvailableGraphDatabase)new TestHighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(storeDir).setConfig(ClusterSettings.initial_hosts, "127.0.0.1:5001").setConfig(ClusterSettings.cluster_server, "127.0.0.1:5001").setConfig(ClusterSettings.server_id, "1").setConfig(HaSettings.ha_server, "127.0.0.1:6666").newGraphDatabase();
            try {
                HighlyAvailableGraphDatabase failed = (HighlyAvailableGraphDatabase)new TestHighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(storeDir).setConfig(ClusterSettings.initial_hosts, "127.0.0.1:5001").setConfig(ClusterSettings.cluster_server, "127.0.0.1:5002").setConfig(ClusterSettings.server_id, "2").setConfig(HaSettings.ha_server, "127.0.0.1:6666").newGraphDatabase();
                failed.shutdown();
                Assert.fail((String)"Should not start when ports conflict");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            if (first != null) {
                first.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void given4instanceClusterWhenMasterGoesDownThenElectNewMaster() throws Throwable {
        ClusterManager clusterManager = new ClusterManager(ClusterManager.clusterOfSize(4), TargetDirectory.forTest(this.getClass()).cleanDirectory("4instances"), MapUtil.stringMap((String[])new String[0]));
        try {
            clusterManager.start();
            ClusterManager.ManagedCluster cluster = clusterManager.getDefaultCluster();
            cluster.await(ClusterManager.allSeesAllAsAvailable());
            this.logging.getLogger().info("STOPPING MASTER");
            cluster.shutdown(cluster.getMaster());
            this.logging.getLogger().info("STOPPED MASTER");
            cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
            HighlyAvailableGraphDatabase master = cluster.getMaster();
            this.logging.getLogger().info("CREATE NODE");
            Transaction tx = master.beginTx();
            master.createNode();
            this.logging.getLogger().info("CREATED NODE");
            tx.success();
            tx.finish();
            this.logging.getLogger().info("STOPPING CLUSTER");
        }
        finally {
            clusterManager.safeShutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void givenEmptyHostListWhenClusterStartupThenFormClusterWithSingleInstance() throws Exception {
        HighlyAvailableGraphDatabase db = (HighlyAvailableGraphDatabase)new TestHighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(TargetDirectory.forTest(this.getClass()).cleanDirectory("singleinstance").getAbsolutePath()).setConfig(ClusterSettings.server_id, "1").setConfig(ClusterSettings.initial_hosts, "").newGraphDatabase();
        try {
            Assert.assertTrue((String)"Single instance cluster was not formed in time", (boolean)db.isAvailable(1000L));
        }
        finally {
            db.shutdown();
        }
    }
}

