/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import org.neo4j.backup.OnlineBackupKernelExtension;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.member.ClusterMemberAvailability;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.com.Server;
import org.neo4j.com.ServerUtil;
import org.neo4j.com.monitor.RequestMonitor;
import org.neo4j.com.storecopy.StoreCopyClient;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.com.storecopy.TransactionCommittingResponseUnpacker;
import org.neo4j.com.storecopy.TransactionObligationFulfiller;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.CancellationRequest;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.StoreLockerLifecycleAdapter;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.ha.BranchedDataException;
import org.neo4j.kernel.ha.BranchedDataPolicy;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.MasterClient210;
import org.neo4j.kernel.ha.PullerFactory;
import org.neo4j.kernel.ha.StoreOutOfDateException;
import org.neo4j.kernel.ha.StoreUnableToParticipateInClusterException;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.ha.UpdatePullerScheduler;
import org.neo4j.kernel.ha.cluster.HighAvailabilityModeSwitcher;
import org.neo4j.kernel.ha.cluster.member.ClusterMember;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.HandshakeResult;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.slave.MasterClient;
import org.neo4j.kernel.ha.com.slave.MasterClientResolver;
import org.neo4j.kernel.ha.com.slave.SlaveImpl;
import org.neo4j.kernel.ha.com.slave.SlaveServer;
import org.neo4j.kernel.ha.id.HaIdGeneratorFactory;
import org.neo4j.kernel.ha.store.ForeignStoreException;
import org.neo4j.kernel.ha.store.UnableToCopyStoreFromOldMasterException;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.store.MismatchingStoreIdException;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.transaction.log.MissingLogDataException;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.kernel.monitoring.Monitors;

public class SwitchToSlave {
    private static final Class<? extends Lifecycle>[] SERVICES_TO_RESTART_FOR_STORE_COPY = new Class[]{StoreLockerLifecycleAdapter.class, DataSourceManager.class, RequestContextFactory.class, TransactionCommittingResponseUnpacker.class, IndexConfigStore.class, OnlineBackupKernelExtension.class};
    private final Logging logging;
    private final StringLogger msgLog;
    private final ConsoleLogger console;
    private final Config config;
    private final DependencyResolver resolver;
    private final HaIdGeneratorFactory idGeneratorFactory;
    private final DelegateInvocationHandler<Master> masterDelegateHandler;
    private final ClusterMemberAvailability clusterMemberAvailability;
    private final RequestContextFactory requestContextFactory;
    private final Iterable<KernelExtensionFactory<?>> kernelExtensions;
    private final MasterClientResolver masterClientResolver;
    private final UpdatePuller updatePuller;
    private final ByteCounterMonitor byteCounterMonitor;
    private final RequestMonitor requestMonitor;
    private final PullerFactory updatePullerFactory;
    private final StoreCopyClient.Monitor storeCopyMonitor;
    private final Monitor monitor;

    public SwitchToSlave(ConsoleLogger console, Config config, DependencyResolver resolver, HaIdGeneratorFactory idGeneratorFactory, Logging logging, DelegateInvocationHandler<Master> masterDelegateHandler, ClusterMemberAvailability clusterMemberAvailability, RequestContextFactory requestContextFactory, Iterable<KernelExtensionFactory<?>> kernelExtensions, MasterClientResolver masterClientResolver, UpdatePuller updatePuller, PullerFactory pullerFactory, ByteCounterMonitor byteCounterMonitor, RequestMonitor requestMonitor, Monitor monitor, StoreCopyClient.Monitor storeCopyMonitor) {
        this.console = console;
        this.config = config;
        this.resolver = resolver;
        this.idGeneratorFactory = idGeneratorFactory;
        this.logging = logging;
        this.clusterMemberAvailability = clusterMemberAvailability;
        this.requestContextFactory = requestContextFactory;
        this.kernelExtensions = kernelExtensions;
        this.updatePuller = updatePuller;
        this.byteCounterMonitor = byteCounterMonitor;
        this.requestMonitor = requestMonitor;
        this.storeCopyMonitor = storeCopyMonitor;
        this.msgLog = logging.getMessagesLog(this.getClass());
        this.masterDelegateHandler = masterDelegateHandler;
        this.updatePullerFactory = pullerFactory;
        this.monitor = monitor;
        this.masterClientResolver = masterClientResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI switchToSlave(LifeSupport haCommunicationLife, URI me, URI masterUri, CancellationRequest cancellationRequest) throws Throwable {
        URI slaveUri;
        boolean success = false;
        this.monitor.switchToSlaveStarted();
        try {
            InstanceId myId = (InstanceId)this.config.get(ClusterSettings.server_id);
            this.console.log("ServerId " + myId + ", moving to slave for master " + masterUri);
            assert (masterUri != null);
            this.idGeneratorFactory.switchToSlave();
            this.copyStoreFromMasterIfNeeded(masterUri, me, cancellationRequest);
            if (cancellationRequest.cancellationRequested()) {
                this.msgLog.info("Switch to slave cancelled during store copy if no local store is present.");
                URI uRI = null;
                return uRI;
            }
            NeoStoreDataSource neoDataSource = (NeoStoreDataSource)this.resolver.resolveDependency(NeoStoreDataSource.class);
            neoDataSource.afterModeSwitch();
            StoreId myStoreId = neoDataSource.getStoreId();
            boolean consistencyChecksExecutedSuccessfully = this.executeConsistencyChecks(masterUri, me, neoDataSource, cancellationRequest);
            if (!consistencyChecksExecutedSuccessfully) {
                this.msgLog.info("Switch to slave cancelled due to consistency check failure.");
                URI uRI = null;
                return uRI;
            }
            if (cancellationRequest.cancellationRequested()) {
                this.msgLog.info("Switch to slave cancelled after consistency checks.");
                URI uRI = null;
                return uRI;
            }
            slaveUri = this.startHaCommunication(haCommunicationLife, neoDataSource, me, masterUri, myStoreId, cancellationRequest);
            if (slaveUri == null) {
                this.msgLog.info("Switch to slave unable to connect.");
                URI uRI = null;
                return uRI;
            }
            success = true;
            this.console.log("ServerId " + myId + ", successfully moved to slave for master " + masterUri);
        }
        finally {
            this.monitor.switchToSlaveCompleted(success);
        }
        return slaveUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyStoreFromMasterIfNeeded(URI masterUri, URI me, CancellationRequest cancellationRequest) throws Throwable {
        if (!NeoStore.isStorePresent((FileSystemAbstraction)((FileSystemAbstraction)this.resolver.resolveDependency(FileSystemAbstraction.class)), (Config)this.config)) {
            boolean success = false;
            this.monitor.storeCopyStarted();
            LifeSupport copyLife = new LifeSupport();
            try {
                boolean masterIsOld;
                MasterClient masterClient = this.newMasterClient(masterUri, me, null, copyLife);
                copyLife.start();
                boolean bl = masterIsOld = MasterClient.CURRENT.compareTo(masterClient.getProtocolVersion()) > 0;
                if (masterIsOld) {
                    throw new UnableToCopyStoreFromOldMasterException(MasterClient.CURRENT.getApplicationProtocol(), masterClient.getProtocolVersion().getApplicationProtocol());
                }
                this.copyStoreFromMaster(masterClient, cancellationRequest);
                success = true;
            }
            finally {
                this.monitor.storeCopyCompleted(success);
                copyLife.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeConsistencyChecks(URI masterUri, URI me, NeoStoreDataSource neoDataSource, CancellationRequest cancellationRequest) throws Throwable {
        LifeSupport consistencyCheckLife = new LifeSupport();
        try {
            StoreId myStoreId = neoDataSource.getStoreId();
            MasterClient masterClient = this.newMasterClient(masterUri, me, myStoreId, consistencyCheckLife);
            consistencyCheckLife.start();
            if (cancellationRequest.cancellationRequested()) {
                boolean bl = false;
                return bl;
            }
            this.checkDataConsistency(masterClient, neoDataSource, masterUri);
        }
        finally {
            consistencyCheckLife.shutdown();
        }
        return true;
    }

    void checkDataConsistency(MasterClient masterClient, NeoStoreDataSource neoDataSource, URI masterUri) throws Throwable {
        TransactionIdStore txIdStore = (TransactionIdStore)neoDataSource.getDependencyResolver().resolveDependency(TransactionIdStore.class);
        try {
            this.console.log("Checking store consistency with master");
            this.checkMyStoreIdAndMastersStoreId(neoDataSource, masterUri);
            this.checkDataConsistencyWithMaster(masterUri, masterClient, neoDataSource, txIdStore);
            this.console.log("Store is consistent");
        }
        catch (StoreUnableToParticipateInClusterException upe) {
            this.console.log("The store is inconsistent. Will treat it as branched and fetch a new one from the master");
            this.msgLog.warn("Current store is unable to participate in the cluster; fetching new store from master", (Throwable)upe);
            try {
                this.stopServicesAndHandleBranchedStore((BranchedDataPolicy)((Object)this.config.get(HaSettings.branched_data_policy)));
            }
            catch (IOException e) {
                this.msgLog.warn("Failed while trying to handle branched data", (Throwable)e);
            }
            throw upe;
        }
        catch (MismatchingStoreIdException e) {
            this.console.log("The store does not represent the same database as master. Will remove and fetch a new one from master");
            if (txIdStore.getLastCommittedTransactionId() == 1L) {
                this.msgLog.warn("Found and deleting empty store with mismatching store id", (Throwable)e);
                this.stopServicesAndHandleBranchedStore(BranchedDataPolicy.keep_none);
                throw e;
            }
            this.msgLog.error("Store cannot participate in cluster due to mismatching store IDs", (Throwable)e);
            throw new ForeignStoreException(e.getExpected(), e.getEncountered());
        }
    }

    private void checkMyStoreIdAndMastersStoreId(NeoStoreDataSource neoDataSource, URI masterUri) {
        StoreId myStoreId = neoDataSource.getStoreId();
        ClusterMembers clusterMembers = (ClusterMembers)this.resolver.resolveDependency(ClusterMembers.class);
        ClusterMember master = (ClusterMember)Iterables.single((Iterable)Iterables.filter(ClusterMembers.hasInstanceId(HighAvailabilityModeSwitcher.getServerId(masterUri)), clusterMembers.getMembers()));
        StoreId masterStoreId = master.getStoreId();
        if (!myStoreId.equals((Object)masterStoreId)) {
            throw new MismatchingStoreIdException(myStoreId, master.getStoreId());
        }
        if (!myStoreId.equalsByUpgradeId(master.getStoreId())) {
            throw new BranchedDataException("My store with " + myStoreId + " was updated independently from " + "master's store " + masterStoreId);
        }
    }

    private URI startHaCommunication(LifeSupport haCommunicationLife, NeoStoreDataSource neoDataSource, URI me, URI masterUri, StoreId storeId, CancellationRequest cancellationRequest) throws IllegalArgumentException, InterruptedException {
        MasterClient master = this.newMasterClient(masterUri, me, neoDataSource.getStoreId(), haCommunicationLife);
        TransactionObligationFulfiller obligationFulfiller = (TransactionObligationFulfiller)this.resolver.resolveDependency(TransactionObligationFulfiller.class);
        UpdatePullerScheduler updatePullerScheduler = this.updatePullerFactory.createUpdatePullerScheduler(this.updatePuller);
        SlaveImpl slaveImpl = new SlaveImpl(obligationFulfiller);
        SlaveServer server = new SlaveServer(slaveImpl, this.serverConfig(), this.logging, this.byteCounterMonitor, this.requestMonitor);
        if (cancellationRequest.cancellationRequested()) {
            return null;
        }
        this.masterDelegateHandler.setDelegate(master);
        haCommunicationLife.add((Lifecycle)updatePullerScheduler);
        haCommunicationLife.add((Lifecycle)server);
        haCommunicationLife.start();
        if (!this.catchUpWithMaster(this.updatePuller)) {
            return null;
        }
        URI slaveHaURI = this.createHaURI(me, server);
        this.clusterMemberAvailability.memberIsAvailable("slave", slaveHaURI, storeId);
        return slaveHaURI;
    }

    private boolean catchUpWithMaster(UpdatePuller updatePuller) throws IllegalArgumentException, InterruptedException {
        this.monitor.catchupStarted();
        RequestContext catchUpRequestContext = this.requestContextFactory.newRequestContext();
        this.console.log("Catching up with master. I'm at " + catchUpRequestContext);
        if (!updatePuller.tryPullUpdates()) {
            return false;
        }
        this.console.log("Now caught up with master");
        this.monitor.catchupCompleted();
        return true;
    }

    private Server.Configuration serverConfig() {
        return new Server.Configuration(){

            public long getOldChannelThreshold() {
                return (Long)SwitchToSlave.this.config.get(HaSettings.lock_read_timeout);
            }

            public int getMaxConcurrentTransactions() {
                return (Integer)SwitchToSlave.this.config.get(HaSettings.max_concurrent_channels_per_slave);
            }

            public int getChunkSize() {
                return ((Long)SwitchToSlave.this.config.get(HaSettings.com_chunk_size)).intValue();
            }

            public HostnamePort getServerAddress() {
                return (HostnamePort)SwitchToSlave.this.config.get(HaSettings.ha_server);
            }
        };
    }

    private URI createHaURI(URI me, Server<?, ?> server) {
        String hostString = ServerUtil.getHostString((InetSocketAddress)server.getSocketAddress());
        int port = server.getSocketAddress().getPort();
        InstanceId serverId = (InstanceId)this.config.get(ClusterSettings.server_id);
        String host = hostString.contains("0.0.0.0") ? me.getHost() : hostString;
        return URI.create("ha://" + host + ":" + port + "?serverId=" + serverId);
    }

    private void copyStoreFromMaster(final MasterClient masterClient, CancellationRequest cancellationRequest) throws Throwable {
        FileSystemAbstraction fs = (FileSystemAbstraction)this.resolver.resolveDependency(FileSystemAbstraction.class);
        PageCache pageCache = (PageCache)this.resolver.resolveDependency(PageCache.class);
        this.console.log("Copying store from master");
        new StoreCopyClient(this.config, this.kernelExtensions, this.console, this.logging, fs, pageCache, this.storeCopyMonitor).copyStore(new StoreCopyClient.StoreCopyRequester(){

            public Response<?> copyStore(StoreWriter writer) {
                return masterClient.copyStore(new RequestContext(0L, ((InstanceId)SwitchToSlave.this.config.get(ClusterSettings.server_id)).toIntegerIndex(), 0, 1L, 0L), writer);
            }

            public void done() {
            }
        }, cancellationRequest);
        this.startServicesAgain();
        this.console.log("Finished copying store from master");
    }

    private MasterClient newMasterClient(URI masterUri, URI me, StoreId storeId, LifeSupport life) {
        MasterClient masterClient = this.masterClientResolver.instantiate(masterUri.getHost(), masterUri.getPort(), me.getHost(), (Monitors)this.resolver.resolveDependency(Monitors.class), storeId, life);
        if (masterClient.getProtocolVersion().compareTo(MasterClient210.PROTOCOL_VERSION) < 0) {
            this.idGeneratorFactory.enableCompatibilityMode();
        }
        return masterClient;
    }

    private void startServicesAgain() throws Throwable {
        for (Class<? extends Lifecycle> serviceClass : SERVICES_TO_RESTART_FOR_STORE_COPY) {
            ((Lifecycle)this.resolver.resolveDependency(serviceClass)).start();
        }
    }

    void stopServicesAndHandleBranchedStore(BranchedDataPolicy branchPolicy) throws Throwable {
        for (int i = SERVICES_TO_RESTART_FOR_STORE_COPY.length - 1; i >= 0; --i) {
            Class<? extends Lifecycle> serviceClass = SERVICES_TO_RESTART_FOR_STORE_COPY[i];
            ((Lifecycle)this.resolver.resolveDependency(serviceClass)).stop();
        }
        branchPolicy.handle((File)this.config.get(InternalAbstractGraphDatabase.Configuration.store_dir));
    }

    private void checkDataConsistencyWithMaster(URI availableMasterId, Master master, NeoStoreDataSource neoDataSource, TransactionIdStore transactionIdStore) {
        HandshakeResult handshake;
        TransactionId myLastCommittedTxData = transactionIdStore.getLastCommittedTransaction();
        long myLastCommittedTx = myLastCommittedTxData.transactionId();
        try (Response<HandshakeResult> response = master.handshake(myLastCommittedTx, neoDataSource.getStoreId());){
            handshake = (HandshakeResult)response.response();
            this.requestContextFactory.setEpoch(handshake.epoch());
        }
        catch (BranchedDataException e) {
            throw new BranchedDataException("The database stored on this machine has diverged from that of the master. This will be automatically resolved.", e);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof MissingLogDataException) {
                throw new StoreOutOfDateException("The master is missing the log required to complete the consistency check", e.getCause());
            }
            throw e;
        }
        long myChecksum = myLastCommittedTxData.checksum();
        if (myChecksum != handshake.txChecksum()) {
            String msg = "The cluster contains two logically different versions of the database.. This will be automatically resolved. Details: I (server_id:" + this.config.get(ClusterSettings.server_id) + ") think checksum for txId (" + myLastCommittedTx + ") is " + myChecksum + ", but master (server_id:" + HighAvailabilityModeSwitcher.getServerId(availableMasterId) + ") says that it's " + handshake.txChecksum() + ", where handshake is " + handshake;
            throw new BranchedDataException(msg);
        }
        this.msgLog.info("Checksum for last committed tx ok with lastTxId=" + myLastCommittedTx + " with checksum=" + myChecksum, true);
    }

    public static interface Monitor {
        public void switchToSlaveStarted();

        public void switchToSlaveCompleted(boolean var1);

        public void storeCopyStarted();

        public void storeCopyCompleted(boolean var1);

        public void catchupStarted();

        public void catchupCompleted();
    }
}

