/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.File;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.test.ha.ClusterManager;
import org.neo4j.test.ha.ClusterRule;

public class HaLoggingIT {
    @Rule
    public final ClusterRule clusterRule = new ClusterRule(this.getClass());
    protected ClusterManager.ManagedCluster cluster;

    @Before
    public void setup() throws Exception {
        this.cluster = this.clusterRule.provider(ClusterManager.clusterWithAdditionalClients(2, 1)).availabilityChecks(Arrays.asList(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]), ClusterManager.masterSeesMembers(3), ClusterManager.allSeesAllAsJoined())).startCluster();
    }

    @Test
    public void logging_continues_after_role_switch() throws Exception {
        String logMessage = "Just a test for that logging continues as expected";
        HighlyAvailableGraphDatabase db = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        LogService logService = (LogService)db.getDependencyResolver().resolveDependency(LogService.class);
        logService.getInternalLog(this.getClass()).info(logMessage, new Object[]{true});
        HighlyAvailableGraphDatabase master = this.cluster.getMaster();
        this.cluster.shutdown(master);
        this.cluster.await(ClusterManager.masterAvailable(master));
        this.cluster.await(ClusterManager.masterSeesMembers(2));
        logService.getInternalLog(this.getClass()).info(logMessage);
        int count = this.findLoggingLines(db, logMessage);
        Assert.assertEquals((long)2L, (long)count);
    }

    private int findLoggingLines(HighlyAvailableGraphDatabase db, String toLookFor) {
        int count = 0;
        for (String line : IteratorUtil.asIterable((File)new File(this.cluster.getStoreDir(db), "messages.log"), (String)"UTF-8")) {
            if (!line.endsWith(toLookFor)) continue;
            ++count;
        }
        return count;
    }
}

