/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.com.master;

import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.com.RequestContext;
import org.neo4j.com.ResourceReleaser;
import org.neo4j.com.Response;
import org.neo4j.com.TransactionNotPresentOnMasterException;
import org.neo4j.com.TransactionObligationResponse;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.com.master.HandshakeResult;
import org.neo4j.kernel.ha.com.master.MasterImpl;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.OtherThreadRule;

public class MasterImplTest {
    @Rule
    public final OtherThreadRule<Void> otherThread = new OtherThreadRule();

    @Test
    public void givenStartedAndInaccessibleWhenNewLockSessionThrowException() throws Throwable {
        MasterImpl.SPI spi = (MasterImpl.SPI)Mockito.mock(MasterImpl.SPI.class);
        Config config = this.config(20);
        Mockito.when((Object)spi.isAccessible()).thenReturn((Object)false);
        MasterImpl instance = new MasterImpl(spi, (MasterImpl.Monitor)Mockito.mock(MasterImpl.Monitor.class), config);
        instance.start();
        try {
            instance.newLockSession(new RequestContext(0L, 1, 2, 0L, 0L));
            Assert.fail();
        }
        catch (TransactionFailureException e) {
            // empty catch block
        }
    }

    @Test
    public void givenStartedAndAccessibleWhenNewLockSessionThenSucceeds() throws Throwable {
        MasterImpl.SPI spi = MasterImplTest.mockedSpi();
        Config config = this.config(20);
        Mockito.when((Object)spi.isAccessible()).thenReturn((Object)true);
        Mockito.when((Object)spi.getTransactionChecksum(org.mockito.Matchers.anyLong())).thenReturn((Object)1L);
        MasterImpl instance = new MasterImpl(spi, (MasterImpl.Monitor)Mockito.mock(MasterImpl.Monitor.class), config);
        instance.start();
        HandshakeResult handshake = (HandshakeResult)instance.handshake(1L, new StoreId()).response();
        try {
            instance.newLockSession(new RequestContext(handshake.epoch(), 1, 2, 0L, 0L));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void failingToStartTxShouldNotLeadToNPE() throws Throwable {
        MasterImpl.SPI spi = MasterImplTest.mockedSpi();
        Config config = this.config(20);
        Mockito.when((Object)spi.isAccessible()).thenReturn((Object)true);
        Mockito.when((Object)spi.acquireClient()).thenThrow(new Throwable[]{new RuntimeException("Nope")});
        Mockito.when((Object)spi.getTransactionChecksum(org.mockito.Matchers.anyLong())).thenReturn((Object)1L);
        this.mockEmptyResponse(spi);
        MasterImpl instance = new MasterImpl(spi, (MasterImpl.Monitor)Mockito.mock(MasterImpl.Monitor.class), config);
        instance.start();
        Response response = instance.handshake(1L, new StoreId());
        HandshakeResult handshake = (HandshakeResult)response.response();
        try {
            instance.newLockSession(new RequestContext(handshake.epoch(), 1, 2, 0L, 0L));
            Assert.fail((String)"Should have failed.");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(RuntimeException.class));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Nope"));
        }
    }

    private void mockEmptyResponse(MasterImpl.SPI spi) {
        Mockito.when((Object)spi.packEmptyResponse(org.mockito.Matchers.any())).thenAnswer(new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                return new TransactionObligationResponse(invocation.getArguments()[0], StoreId.DEFAULT, 1L, ResourceReleaser.NO_OP);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotEndLockSessionWhereThereIsAnActiveLockAcquisition() throws Throwable {
        final CountDownLatch latch = new CountDownLatch(1);
        try {
            MasterImpl.SPI spi = MasterImplTest.mockedSpi();
            Mockito.when((Object)spi.isAccessible()).thenReturn((Object)true);
            Locks.Client client = (Locks.Client)Mockito.mock(Locks.Client.class);
            ((Locks.Client)Mockito.doAnswer((Answer)new Answer<Void>(){

                public Void answer(InvocationOnMock invocation) throws Throwable {
                    latch.await();
                    return null;
                }
            }).when((Object)client)).acquireExclusive((Locks.ResourceType)org.mockito.Matchers.any(Locks.ResourceType.class), (long[])org.mockito.Matchers.anyVararg());
            Mockito.when((Object)spi.acquireClient()).thenReturn((Object)client);
            Config config = this.config(20);
            final MasterImpl master = new MasterImpl(spi, (MasterImpl.Monitor)Mockito.mock(MasterImpl.Monitor.class), config, 20);
            master.start();
            HandshakeResult handshake = (HandshakeResult)master.handshake(1L, new StoreId()).response();
            final RequestContext context = new RequestContext(handshake.epoch(), 1, 2, 0L, 0L);
            master.newLockSession(context);
            Future acquireFuture = this.otherThread.execute((OtherThreadExecutor.WorkerCommand)new OtherThreadExecutor.WorkerCommand<Void, Void>(){

                public Void doWork(Void state) throws Exception {
                    master.acquireExclusiveLock(context, (Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
                    return null;
                }
            });
            this.otherThread.get().waitUntilWaiting();
            master.endLockSession(context, false);
            ((Locks.Client)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)0))).close();
            latch.countDown();
            acquireFuture.get();
            ((Locks.Client)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)1))).close();
        }
        finally {
            latch.countDown();
        }
    }

    @Test
    public void shouldNotAllowCommitIfThereIsNoMatchingLockSession() throws Throwable {
        MasterImpl.SPI spi = (MasterImpl.SPI)Mockito.mock(MasterImpl.SPI.class);
        Config config = this.config(20);
        Mockito.when((Object)spi.isAccessible()).thenReturn((Object)true);
        Mockito.when((Object)spi.getTransactionChecksum(org.mockito.Matchers.anyLong())).thenReturn((Object)1L);
        this.mockEmptyResponse(spi);
        MasterImpl master = new MasterImpl(spi, (MasterImpl.Monitor)Mockito.mock(MasterImpl.Monitor.class), config);
        master.start();
        HandshakeResult handshake = (HandshakeResult)master.handshake(1L, new StoreId()).response();
        RequestContext ctx = new RequestContext(handshake.epoch(), 1, 2, 0L, 0L);
        try {
            master.commit(ctx, (TransactionRepresentation)Mockito.mock(TransactionRepresentation.class));
            Assert.fail((String)"Should have failed.");
        }
        catch (TransactionNotPresentOnMasterException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)new TransactionNotPresentOnMasterException(ctx).getMessage()));
        }
    }

    @Test
    public void shouldAllowCommitIfClientHoldsNoLocks() throws Throwable {
        MasterImpl.SPI spi = (MasterImpl.SPI)Mockito.mock(MasterImpl.SPI.class);
        Config config = this.config(20);
        Locks.Client locks = (Locks.Client)Mockito.mock(Locks.Client.class);
        Mockito.when((Object)locks.trySharedLock((Locks.ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()})).thenReturn((Object)true);
        Mockito.when((Object)spi.isAccessible()).thenReturn((Object)true);
        Mockito.when((Object)spi.getTransactionChecksum(org.mockito.Matchers.anyLong())).thenReturn((Object)1L);
        Mockito.when((Object)spi.acquireClient()).thenReturn((Object)locks);
        this.mockEmptyResponse(spi);
        MasterImpl master = new MasterImpl(spi, (MasterImpl.Monitor)Mockito.mock(MasterImpl.Monitor.class), config);
        master.start();
        HandshakeResult handshake = (HandshakeResult)master.handshake(1L, new StoreId()).response();
        int no_lock_session = -1;
        RequestContext ctx = new RequestContext(handshake.epoch(), 1, no_lock_session, 0L, 0L);
        TransactionRepresentation tx = (TransactionRepresentation)Mockito.mock(TransactionRepresentation.class);
        master.commit(ctx, tx);
        ((MasterImpl.SPI)Mockito.verify((Object)spi)).applyPreparedTransaction(tx);
    }

    private Config config(int lockReadTimeout) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(HaSettings.lock_read_timeout.name(), lockReadTimeout + "s");
        params.put(ClusterSettings.server_id.name(), "1");
        return new Config(params, new Class[]{HaSettings.class});
    }

    public static MasterImpl.SPI mockedSpi() {
        return MasterImplTest.mockedSpi(StoreId.DEFAULT);
    }

    public static MasterImpl.SPI mockedSpi(final StoreId storeId) {
        MasterImpl.SPI mock = (MasterImpl.SPI)Mockito.mock(MasterImpl.SPI.class);
        Mockito.when((Object)mock.storeId()).thenReturn((Object)storeId);
        Mockito.when((Object)mock.packEmptyResponse(org.mockito.Matchers.any())).thenAnswer(new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                return new TransactionObligationResponse(invocation.getArguments()[0], storeId, 1L, ResourceReleaser.NO_OP);
            }
        });
        return mock;
    }
}

