/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.Map;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.neo4j.cluster.BindingListener;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.com.BindingNotifier;
import org.neo4j.cluster.logging.NettyLoggerFactory;
import org.neo4j.cluster.member.ClusterMemberAvailability;
import org.neo4j.cluster.member.ClusterMemberEvents;
import org.neo4j.cluster.member.ClusterMemberListener;
import org.neo4j.cluster.member.paxos.MemberIsAvailable;
import org.neo4j.cluster.member.paxos.PaxosClusterMemberAvailability;
import org.neo4j.cluster.member.paxos.PaxosClusterMemberEvents;
import org.neo4j.cluster.protocol.atomicbroadcast.AtomicBroadcast;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectInputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectOutputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectStreamFactory;
import org.neo4j.cluster.protocol.cluster.Cluster;
import org.neo4j.cluster.protocol.cluster.ClusterConfiguration;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.cluster.protocol.election.Election;
import org.neo4j.cluster.protocol.election.ElectionCredentialsProvider;
import org.neo4j.cluster.protocol.election.NotElectableElectionCredentialsProvider;
import org.neo4j.cluster.protocol.heartbeat.Heartbeat;
import org.neo4j.cluster.protocol.snapshot.Snapshot;
import org.neo4j.com.monitor.RequestMonitor;
import org.neo4j.com.storecopy.ResponseUnpacker;
import org.neo4j.com.storecopy.StoreCopyClient;
import org.neo4j.com.storecopy.TransactionCommittingResponseUnpacker;
import org.neo4j.function.Factory;
import org.neo4j.function.Predicate;
import org.neo4j.function.Supplier;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.helpers.Function2;
import org.neo4j.helpers.NamedThreadFactory;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.DatabaseAvailability;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.KernelHealth;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.ha.BranchedDataMigrator;
import org.neo4j.kernel.ha.CommitProcessSwitcher;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighAvailabilityDiagnostics;
import org.neo4j.kernel.ha.HighAvailabilityLogger;
import org.neo4j.kernel.ha.HighAvailabilityMemberInfoProvider;
import org.neo4j.kernel.ha.LabelTokenCreatorModeSwitcher;
import org.neo4j.kernel.ha.LastUpdateTime;
import org.neo4j.kernel.ha.PropertyKeyCreatorModeSwitcher;
import org.neo4j.kernel.ha.RelationshipTypeCreatorModeSwitcher;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.ha.UpdatePullerClient;
import org.neo4j.kernel.ha.UpdatePullingTransactionObligationFulfiller;
import org.neo4j.kernel.ha.cluster.DefaultElectionCredentialsProvider;
import org.neo4j.kernel.ha.cluster.HANewSnapshotFunction;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberChangeEvent;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberContext;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberListener;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberStateMachine;
import org.neo4j.kernel.ha.cluster.HighAvailabilityModeSwitcher;
import org.neo4j.kernel.ha.cluster.SimpleHighAvailabilityMemberContext;
import org.neo4j.kernel.ha.cluster.SwitchToMaster;
import org.neo4j.kernel.ha.cluster.SwitchToSlave;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.kernel.ha.cluster.member.HighAvailabilitySlaves;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.DefaultSlaveFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.master.MasterImpl;
import org.neo4j.kernel.ha.com.master.MasterServer;
import org.neo4j.kernel.ha.com.master.SlaveFactory;
import org.neo4j.kernel.ha.com.master.Slaves;
import org.neo4j.kernel.ha.com.slave.InvalidEpochExceptionHandler;
import org.neo4j.kernel.ha.com.slave.MasterClientResolver;
import org.neo4j.kernel.ha.com.slave.SlaveServer;
import org.neo4j.kernel.ha.id.HaIdGeneratorFactory;
import org.neo4j.kernel.ha.lock.LockManagerModeSwitcher;
import org.neo4j.kernel.ha.management.ClusterDatabaseInfoProvider;
import org.neo4j.kernel.ha.management.HighlyAvailableKernelData;
import org.neo4j.kernel.ha.transaction.CommitPusher;
import org.neo4j.kernel.ha.transaction.OnDiskLastTxIdGetter;
import org.neo4j.kernel.ha.transaction.TransactionPropagator;
import org.neo4j.kernel.impl.api.CommitProcessFactory;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionHeaderInformation;
import org.neo4j.kernel.impl.api.TransactionRepresentationStoreApplier;
import org.neo4j.kernel.impl.api.index.IndexUpdatesValidator;
import org.neo4j.kernel.impl.core.ReadOnlyTokenCreator;
import org.neo4j.kernel.impl.core.TokenCreator;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.storemigration.UpgradeConfiguration;
import org.neo4j.kernel.impl.storemigration.UpgradeNotAllowedByDatabaseModeException;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.state.NeoStoreInjectedTransactionValidator;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.info.DiagnosticsProvider;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;

public class HighlyAvailableGraphDatabase
extends InternalAbstractGraphDatabase {
    private final LifeSupport paxosLife = new LifeSupport();
    private final Dependencies dependencies = new Dependencies((Supplier)new Supplier<DependencyResolver>(){

        public DependencyResolver get() {
            return HighlyAvailableGraphDatabase.this.dependencyResolver;
        }
    });
    private RequestContextFactory requestContextFactory;
    private ClusterMembers members;
    private DelegateInvocationHandler<Master> masterDelegateInvocationHandler;
    private Master master;
    private HighAvailabilityMemberStateMachine memberStateMachine;
    private LastUpdateTime lastUpdateTime;
    private HighAvailabilityMemberContext memberContext;
    private ClusterClient clusterClient;
    private ClusterMemberAvailability clusterMemberAvailability;
    private HighAvailabilityModeSwitcher highAvailabilityModeSwitcher;
    private long stateSwitchTimeoutMillis;
    private TransactionCommittingResponseUnpacker responseUnpacker;
    private Supplier<KernelAPI> kernelProvider;
    private InvalidEpochExceptionHandler invalidEpochHandler;

    public HighlyAvailableGraphDatabase(String storeDir, Map<String, String> params, Iterable<KernelExtensionFactory<?>> kernelExtensions, Monitors monitors) {
        this(storeDir, params, (InternalAbstractGraphDatabase.Dependencies)GraphDatabaseDependencies.newDependencies().settingsClasses(new Class[]{GraphDatabaseSettings.class, ClusterSettings.class, HaSettings.class}).kernelExtensions(kernelExtensions).monitors(monitors));
    }

    public HighlyAvailableGraphDatabase(String storeDir, Map<String, String> params, Iterable<KernelExtensionFactory<?>> kernelExtensions) {
        this(storeDir, params, (InternalAbstractGraphDatabase.Dependencies)GraphDatabaseDependencies.newDependencies().settingsClasses(new Class[]{GraphDatabaseSettings.class, ClusterSettings.class, HaSettings.class}).kernelExtensions(kernelExtensions));
    }

    public HighlyAvailableGraphDatabase(String storeDir, Map<String, String> params, InternalAbstractGraphDatabase.Dependencies dependencies) {
        super(storeDir, params, dependencies);
        this.run();
    }

    protected void create() {
        this.life.add((Object)new BranchedDataMigrator(this.storeDir));
        this.masterDelegateInvocationHandler = new DelegateInvocationHandler<Master>(Master.class);
        this.master = (Master)Proxy.newProxyInstance(Master.class.getClassLoader(), new Class[]{Master.class}, this.masterDelegateInvocationHandler);
        InstanceId serverId = (InstanceId)this.config.get(ClusterSettings.server_id);
        this.requestContextFactory = (RequestContextFactory)((Object)this.dependencies.satisfyDependency((Object)new RequestContextFactory(serverId.toIntegerIndex(), this.getDependencyResolver())));
        this.responseUnpacker = (TransactionCommittingResponseUnpacker)this.dependencies.satisfyDependency((Object)new TransactionCommittingResponseUnpacker(this.getDependencyResolver()));
        this.kernelProvider = new Supplier<KernelAPI>(){

            public KernelAPI get() {
                return HighlyAvailableGraphDatabase.this.neoDataSource.getKernel();
            }
        };
        super.create();
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new NettyLoggerFactory(this.logService.getInternalLogProvider()));
        this.life.add((Object)this.requestContextFactory);
        this.life.add((Object)this.responseUnpacker);
        UpdatePuller updatePuller = (UpdatePuller)this.dependencies.satisfyDependency(this.life.add((Object)new UpdatePuller(this.memberStateMachine, this.requestContextFactory, this.master, this.lastUpdateTime, this.logService.getInternalLogProvider(), serverId, this.invalidEpochHandler)));
        this.dependencies.satisfyDependency(this.life.add((Object)new UpdatePullerClient((Long)this.config.get(HaSettings.pull_interval), this.jobScheduler, this.logService.getInternalLogProvider(), updatePuller, this.availabilityGuard)));
        this.dependencies.satisfyDependency(this.life.add((Object)new UpdatePullingTransactionObligationFulfiller(updatePuller, this.memberStateMachine, serverId, (DependencyResolver)this.dependencies)));
        this.stateSwitchTimeoutMillis = (Long)this.config.get(HaSettings.state_switch_timeout);
        this.life.add((Object)this.paxosLife);
        this.life.add((Object)new DatabaseAvailability(this.availabilityGuard, this.transactionMonitor));
        this.life.add((Object)new StartupWaiter());
        this.diagnosticsManager.appendProvider((DiagnosticsProvider)new HighAvailabilityDiagnostics(this.memberStateMachine, this.clusterClient));
    }

    protected UpgradeConfiguration createUpgradeConfiguration() {
        return new HAUpgradeConfiguration();
    }

    protected void createDatabaseAvailability() {
    }

    public void start() {
        this.life.start();
    }

    public void stop() {
        this.life.stop();
    }

    public Transaction beginTx() {
        this.availabilityGuard.checkAvailability(this.stateSwitchTimeoutMillis, TransactionFailureException.class);
        return super.beginTx();
    }

    public IndexManager index() {
        this.availabilityGuard.checkAvailability(this.stateSwitchTimeoutMillis, TransactionFailureException.class);
        return super.index();
    }

    protected void createTxHook() {
        DelegateInvocationHandler<ClusterMemberEvents> clusterEventsDelegateInvocationHandler = new DelegateInvocationHandler<ClusterMemberEvents>(ClusterMemberEvents.class);
        DelegateInvocationHandler<HighAvailabilityMemberContext> memberContextDelegateInvocationHandler = new DelegateInvocationHandler<HighAvailabilityMemberContext>(HighAvailabilityMemberContext.class);
        DelegateInvocationHandler<ClusterMemberAvailability> clusterMemberAvailabilityDelegateInvocationHandler = new DelegateInvocationHandler<ClusterMemberAvailability>(ClusterMemberAvailability.class);
        ClusterMemberEvents clusterEvents = (ClusterMemberEvents)this.dependencies.satisfyDependency((Object)((ClusterMemberEvents)Proxy.newProxyInstance(ClusterMemberEvents.class.getClassLoader(), new Class[]{ClusterMemberEvents.class, Lifecycle.class}, clusterEventsDelegateInvocationHandler)));
        this.memberContext = (HighAvailabilityMemberContext)Proxy.newProxyInstance(HighAvailabilityMemberContext.class.getClassLoader(), new Class[]{HighAvailabilityMemberContext.class}, memberContextDelegateInvocationHandler);
        this.clusterMemberAvailability = (ClusterMemberAvailability)this.dependencies.satisfyDependency((Object)((ClusterMemberAvailability)Proxy.newProxyInstance(ClusterMemberAvailability.class.getClassLoader(), new Class[]{ClusterMemberAvailability.class}, clusterMemberAvailabilityDelegateInvocationHandler)));
        Object electionCredentialsProvider = (Boolean)this.config.get(HaSettings.slave_only) != false ? new NotElectableElectionCredentialsProvider() : new DefaultElectionCredentialsProvider((InstanceId)this.config.get(ClusterSettings.server_id), new OnDiskLastTxIdGetter((GraphDatabaseAPI)this), new HighAvailabilityMemberInfoProvider(){

            @Override
            public HighAvailabilityMemberState getHighAvailabilityMemberState() {
                return HighlyAvailableGraphDatabase.this.memberStateMachine.getCurrentState();
            }
        });
        ObjectStreamFactory objectStreamFactory = new ObjectStreamFactory();
        this.clusterClient = (ClusterClient)this.dependencies.satisfyDependency((Object)new ClusterClient(this.monitors, ClusterClient.adapt((Config)this.config), this.logService, (ElectionCredentialsProvider)electionCredentialsProvider, (ObjectInputStreamFactory)objectStreamFactory, (ObjectOutputStreamFactory)objectStreamFactory));
        PaxosClusterMemberEvents localClusterEvents = new PaxosClusterMemberEvents((Snapshot)this.clusterClient, (Cluster)this.clusterClient, (Heartbeat)this.clusterClient, (AtomicBroadcast)this.clusterClient, this.logService.getInternalLogProvider(), (Predicate)new Predicate<PaxosClusterMemberEvents.ClusterMembersSnapshot>(){

            public boolean test(PaxosClusterMemberEvents.ClusterMembersSnapshot item) {
                for (MemberIsAvailable member : item.getCurrentAvailableMembers()) {
                    if (!member.getRoleUri().getScheme().equals("ha") || !HighAvailabilityModeSwitcher.getServerId(member.getRoleUri()).equals(HighlyAvailableGraphDatabase.this.config.get(ClusterSettings.server_id))) continue;
                    HighlyAvailableGraphDatabase.this.msgLog.error(String.format("Instance %s has the same serverId as ours (%s) - will not join this cluster", member.getRoleUri(), ((InstanceId)HighlyAvailableGraphDatabase.this.config.get(ClusterSettings.server_id)).toIntegerIndex()));
                    return true;
                }
                return true;
            }
        }, (Function2)new HANewSnapshotFunction(), (ObjectInputStreamFactory)objectStreamFactory, (ObjectOutputStreamFactory)objectStreamFactory, (NamedThreadFactory.Monitor)this.monitors.newMonitor(NamedThreadFactory.Monitor.class, new String[0]));
        this.clusterClient.addClusterListener((ClusterListener)new ClusterListener.Adapter(){
            boolean hasRequestedElection = true;

            public void enteredCluster(ClusterConfiguration clusterConfiguration) {
                HighlyAvailableGraphDatabase.this.clusterClient.performRoleElections();
            }

            public void elected(String role, InstanceId instanceId, URI electedMember) {
                if (this.hasRequestedElection && role.equals("coordinator")) {
                    HighlyAvailableGraphDatabase.this.clusterClient.removeClusterListener((ClusterListener)this);
                }
            }
        });
        SimpleHighAvailabilityMemberContext localMemberContext = new SimpleHighAvailabilityMemberContext(this.clusterClient.getServerId(), (Boolean)this.config.get(HaSettings.slave_only));
        PaxosClusterMemberAvailability localClusterMemberAvailability = new PaxosClusterMemberAvailability(this.clusterClient.getServerId(), (BindingNotifier)this.clusterClient, (AtomicBroadcast)this.clusterClient, this.logService.getInternalLogProvider(), (ObjectInputStreamFactory)objectStreamFactory, (ObjectOutputStreamFactory)objectStreamFactory);
        memberContextDelegateInvocationHandler.setDelegate(localMemberContext);
        clusterEventsDelegateInvocationHandler.setDelegate((ClusterMemberEvents)localClusterEvents);
        clusterMemberAvailabilityDelegateInvocationHandler.setDelegate((ClusterMemberAvailability)localClusterMemberAvailability);
        this.members = (ClusterMembers)this.dependencies.satisfyDependency((Object)new ClusterMembers((Cluster)this.clusterClient, (Heartbeat)this.clusterClient, clusterEvents, (InstanceId)this.config.get(ClusterSettings.server_id)));
        this.memberStateMachine = new HighAvailabilityMemberStateMachine(this.memberContext, this.availabilityGuard, this.members, clusterEvents, (Election)this.clusterClient, this.logService.getInternalLogProvider());
        HighAvailabilityLogger highAvailabilityLogger = new HighAvailabilityLogger(this.logService.getUserLogProvider(), (InstanceId)this.config.get(ClusterSettings.server_id));
        this.availabilityGuard.addListener((AvailabilityGuard.AvailabilityListener)highAvailabilityLogger);
        clusterEvents.addClusterMemberListener((ClusterMemberListener)highAvailabilityLogger);
        this.clusterClient.addClusterListener((ClusterListener)highAvailabilityLogger);
        this.paxosLife.add((Object)this.clusterClient);
        this.paxosLife.add((Object)this.memberStateMachine);
        this.paxosLife.add((Object)clusterEvents);
        this.paxosLife.add((Object)localClusterMemberAvailability);
    }

    public void assertSchemaWritesAllowed() throws InvalidTransactionTypeKernelException {
        if (!this.isMaster()) {
            throw new InvalidTransactionTypeKernelException("Modifying the database schema can only be done on the master server, this server is a slave. Please issue schema modification commands directly to the master.");
        }
    }

    protected TransactionHeaderInformationFactory createHeaderInformationFactory() {
        return new TransactionHeaderInformationFactory.WithRandomBytes(){

            protected TransactionHeaderInformation createUsing(byte[] additionalHeader) {
                return new TransactionHeaderInformation(HighlyAvailableGraphDatabase.this.memberContext.getElectedMasterId().toIntegerIndex(), HighlyAvailableGraphDatabase.this.memberContext.getMyId().toIntegerIndex(), additionalHeader);
            }
        };
    }

    protected CommitProcessFactory getCommitProcessFactory() {
        final DelegateInvocationHandler<TransactionCommitProcess> commitProcessDelegate = new DelegateInvocationHandler<TransactionCommitProcess>(TransactionCommitProcess.class);
        DefaultSlaveFactory slaveFactory = (DefaultSlaveFactory)this.dependencies.satisfyDependency((Object)new DefaultSlaveFactory(this.logService.getInternalLogProvider(), this.monitors, ((Long)this.config.get(HaSettings.com_chunk_size)).intValue()));
        Slaves slaves = (Slaves)this.dependencies.satisfyDependency(this.life.add((Object)new HighAvailabilitySlaves(this.members, (Cluster)this.clusterClient, slaveFactory)));
        final TransactionPropagator pusher = (TransactionPropagator)this.life.add((Object)new TransactionPropagator(TransactionPropagator.from(this.config), this.msgLog, slaves, new CommitPusher(this.jobScheduler)));
        return new CommitProcessFactory(){

            public TransactionCommitProcess create(LogicalTransactionStore logicalTransactionStore, KernelHealth kernelHealth, NeoStore neoStore, TransactionRepresentationStoreApplier storeApplier, NeoStoreInjectedTransactionValidator txValidator, IndexUpdatesValidator indexUpdatesValidator, TransactionApplicationMode mode, Config config) {
                if (((Boolean)config.get(GraphDatabaseSettings.read_only)).booleanValue()) {
                    return InternalAbstractGraphDatabase.defaultCommitProcessFactory.create(logicalTransactionStore, kernelHealth, neoStore, storeApplier, txValidator, indexUpdatesValidator, mode, config);
                }
                TransactionCommitProcess inner = InternalAbstractGraphDatabase.defaultCommitProcessFactory.create(logicalTransactionStore, kernelHealth, neoStore, storeApplier, txValidator, indexUpdatesValidator, mode, config);
                new CommitProcessSwitcher(pusher, HighlyAvailableGraphDatabase.this.master, commitProcessDelegate, HighlyAvailableGraphDatabase.this.requestContextFactory, HighlyAvailableGraphDatabase.this.memberStateMachine, txValidator, inner);
                return (TransactionCommitProcess)Proxy.newProxyInstance(TransactionCommitProcess.class.getClassLoader(), new Class[]{TransactionCommitProcess.class}, (InvocationHandler)commitProcessDelegate);
            }
        };
    }

    protected IdGeneratorFactory createIdGeneratorFactory() {
        this.idGeneratorFactory = new HaIdGeneratorFactory(this.masterDelegateInvocationHandler, this.logService.getInternalLogProvider(), this.requestContextFactory);
        Log userLog = this.logService.getUserLog(HighAvailabilityModeSwitcher.class);
        this.invalidEpochHandler = new InvalidEpochExceptionHandler(){

            @Override
            public void handle() {
                HighlyAvailableGraphDatabase.this.highAvailabilityModeSwitcher.forceElections();
            }
        };
        MasterClientResolver masterClientResolver = new MasterClientResolver(this.logService.getInternalLogProvider(), (ResponseUnpacker)this.responseUnpacker, this.invalidEpochHandler, ((Long)this.config.get(HaSettings.read_timeout)).intValue(), ((Long)this.config.get(HaSettings.lock_read_timeout)).intValue(), (Integer)this.config.get(HaSettings.max_concurrent_channels_per_slave), ((Long)this.config.get(HaSettings.com_chunk_size)).intValue());
        SwitchToSlave switchToSlaveInstance = new SwitchToSlave(this.logService, this.config, this.getDependencyResolver(), (HaIdGeneratorFactory)this.idGeneratorFactory, this.masterDelegateInvocationHandler, this.clusterMemberAvailability, this.requestContextFactory, this.kernelExtensions.listFactories(), masterClientResolver, (ByteCounterMonitor)this.monitors.newMonitor(ByteCounterMonitor.class, SlaveServer.class, new String[0]), (RequestMonitor)this.monitors.newMonitor(RequestMonitor.class, SlaveServer.class, new String[0]), (SwitchToSlave.Monitor)this.monitors.newMonitor(SwitchToSlave.Monitor.class, new String[0]), (StoreCopyClient.Monitor)this.monitors.newMonitor(StoreCopyClient.Monitor.class, new String[0]));
        SwitchToMaster switchToMasterInstance = new SwitchToMaster(this.logService, (GraphDatabaseAPI)this, (HaIdGeneratorFactory)this.idGeneratorFactory, this.config, (Supplier<SlaveFactory>)this.dependencies.provideDependency(SlaveFactory.class), this.masterDelegateInvocationHandler, this.clusterMemberAvailability, this.dataSourceManager, (ByteCounterMonitor)this.monitors.newMonitor(ByteCounterMonitor.class, MasterServer.class, new String[0]), (RequestMonitor)this.monitors.newMonitor(RequestMonitor.class, MasterServer.class, new String[0]), (MasterImpl.Monitor)this.monitors.newMonitor(MasterImpl.Monitor.class, MasterImpl.class, new String[0]));
        this.highAvailabilityModeSwitcher = new HighAvailabilityModeSwitcher(switchToSlaveInstance, switchToMasterInstance, (Election)this.clusterClient, this.clusterMemberAvailability, this.getDependencyResolver(), (InstanceId)this.config.get(ClusterSettings.server_id), this.logService);
        this.clusterClient.addBindingListener((BindingListener)this.highAvailabilityModeSwitcher);
        this.memberStateMachine.addHighAvailabilityMemberListener(this.highAvailabilityModeSwitcher);
        this.paxosLife.add((Object)this.highAvailabilityModeSwitcher);
        ((HaIdGeneratorFactory)this.idGeneratorFactory).switchToMaster();
        return this.idGeneratorFactory;
    }

    protected Locks createLockManager() {
        DelegateInvocationHandler<Locks> lockManagerDelegate = new DelegateInvocationHandler<Locks>(Locks.class);
        Locks lockManager = (Locks)Proxy.newProxyInstance(Locks.class.getClassLoader(), new Class[]{Locks.class}, lockManagerDelegate);
        new LockManagerModeSwitcher(this.memberStateMachine, lockManagerDelegate, this.masterDelegateInvocationHandler, this.requestContextFactory, this.availabilityGuard, this.config, new Factory<Locks>(){

            public Locks newInstance() {
                return HighlyAvailableGraphDatabase.super.createLockManager();
            }
        });
        return lockManager;
    }

    protected TokenCreator createRelationshipTypeCreator() {
        if (((Boolean)this.config.get(GraphDatabaseSettings.read_only)).booleanValue()) {
            return new ReadOnlyTokenCreator();
        }
        DelegateInvocationHandler<TokenCreator> relationshipTypeCreatorDelegate = new DelegateInvocationHandler<TokenCreator>(TokenCreator.class);
        TokenCreator relationshipTypeCreator = (TokenCreator)Proxy.newProxyInstance(TokenCreator.class.getClassLoader(), new Class[]{TokenCreator.class}, relationshipTypeCreatorDelegate);
        new RelationshipTypeCreatorModeSwitcher(this.memberStateMachine, relationshipTypeCreatorDelegate, this.masterDelegateInvocationHandler, this.requestContextFactory, this.kernelProvider, this.idGeneratorFactory);
        return relationshipTypeCreator;
    }

    protected TokenCreator createPropertyKeyCreator() {
        if (((Boolean)this.config.get(GraphDatabaseSettings.read_only)).booleanValue()) {
            return new ReadOnlyTokenCreator();
        }
        DelegateInvocationHandler<TokenCreator> propertyKeyCreatorDelegate = new DelegateInvocationHandler<TokenCreator>(TokenCreator.class);
        TokenCreator propertyTokenCreator = (TokenCreator)Proxy.newProxyInstance(TokenCreator.class.getClassLoader(), new Class[]{TokenCreator.class}, propertyKeyCreatorDelegate);
        new PropertyKeyCreatorModeSwitcher(this.memberStateMachine, propertyKeyCreatorDelegate, this.masterDelegateInvocationHandler, this.requestContextFactory, this.kernelProvider, this.idGeneratorFactory);
        return propertyTokenCreator;
    }

    protected TokenCreator createLabelIdCreator() {
        if (((Boolean)this.config.get(GraphDatabaseSettings.read_only)).booleanValue()) {
            return new ReadOnlyTokenCreator();
        }
        DelegateInvocationHandler<TokenCreator> labelIdCreatorDelegate = new DelegateInvocationHandler<TokenCreator>(TokenCreator.class);
        TokenCreator labelIdCreator = (TokenCreator)Proxy.newProxyInstance(TokenCreator.class.getClassLoader(), new Class[]{TokenCreator.class}, labelIdCreatorDelegate);
        new LabelTokenCreatorModeSwitcher(this.memberStateMachine, labelIdCreatorDelegate, this.masterDelegateInvocationHandler, this.requestContextFactory, this.kernelProvider, this.idGeneratorFactory);
        return labelIdCreator;
    }

    protected KernelData createKernelData() {
        this.lastUpdateTime = new LastUpdateTime();
        OnDiskLastTxIdGetter txIdGetter = new OnDiskLastTxIdGetter((GraphDatabaseAPI)this);
        ClusterDatabaseInfoProvider databaseInfo = new ClusterDatabaseInfoProvider(this.members, txIdGetter, this.lastUpdateTime);
        return new HighlyAvailableKernelData(this, this.members, databaseInfo);
    }

    protected void registerRecovery() {
        this.memberStateMachine.addHighAvailabilityMemberListener(new HighAvailabilityMemberListener(){

            @Override
            public void masterIsElected(HighAvailabilityMemberChangeEvent event) {
            }

            @Override
            public void masterIsAvailable(HighAvailabilityMemberChangeEvent event) {
                if (event.getOldState().equals((Object)HighAvailabilityMemberState.TO_MASTER) && event.getNewState().equals((Object)HighAvailabilityMemberState.MASTER)) {
                    this.doAfterRecoveryAndStartup(true);
                }
            }

            @Override
            public void slaveIsAvailable(HighAvailabilityMemberChangeEvent event) {
                if (event.getOldState().equals((Object)HighAvailabilityMemberState.TO_SLAVE) && event.getNewState().equals((Object)HighAvailabilityMemberState.SLAVE)) {
                    this.doAfterRecoveryAndStartup(false);
                }
            }

            @Override
            public void instanceStops(HighAvailabilityMemberChangeEvent event) {
            }

            private void doAfterRecoveryAndStartup(boolean isMaster) {
                try {
                    HighlyAvailableGraphDatabase.this.doAfterRecoveryAndStartup(isMaster);
                }
                catch (Throwable throwable) {
                    HighlyAvailableGraphDatabase.this.msgLog.error("Post recovery error", throwable);
                    try {
                        HighlyAvailableGraphDatabase.this.memberStateMachine.stop();
                    }
                    catch (Throwable throwable1) {
                        HighlyAvailableGraphDatabase.this.msgLog.warn("Could not stop", throwable1);
                    }
                    try {
                        HighlyAvailableGraphDatabase.this.memberStateMachine.start();
                    }
                    catch (Throwable throwable1) {
                        HighlyAvailableGraphDatabase.this.msgLog.warn("Could not start", throwable1);
                    }
                }
            }
        });
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this.storeDir + "]";
    }

    public HighAvailabilityMemberState getInstanceState() {
        return this.memberStateMachine.getCurrentState();
    }

    public String role() {
        return this.members.getSelf().getHARole();
    }

    public boolean isMaster() {
        return this.memberStateMachine.getCurrentState() == HighAvailabilityMemberState.MASTER;
    }

    public DependencyResolver getDependencyResolver() {
        return this.dependencies;
    }

    private class StartupWaiter
    extends LifecycleAdapter {
        private StartupWaiter() {
        }

        public void start() throws Throwable {
            HighlyAvailableGraphDatabase.this.availabilityGuard.isAvailable(HighlyAvailableGraphDatabase.this.stateSwitchTimeoutMillis);
        }
    }

    private static final class HAUpgradeConfiguration
    implements UpgradeConfiguration {
        private HAUpgradeConfiguration() {
        }

        public void checkConfigurationAllowsAutomaticUpgrade() {
            throw new UpgradeNotAllowedByDatabaseModeException();
        }
    }
}

