/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.net.URI;
import org.neo4j.function.Supplier;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.SlaveLabelTokenCreator;
import org.neo4j.kernel.ha.cluster.AbstractModeSwitcher;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberStateMachine;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.impl.core.DefaultLabelIdCreator;
import org.neo4j.kernel.impl.core.TokenCreator;

public class LabelTokenCreatorModeSwitcher
extends AbstractModeSwitcher<TokenCreator> {
    private final DelegateInvocationHandler<Master> master;
    private final RequestContextFactory requestContextFactory;
    private final Supplier<KernelAPI> kernelSupplier;
    private final IdGeneratorFactory idGeneratorFactory;

    public LabelTokenCreatorModeSwitcher(HighAvailabilityMemberStateMachine stateMachine, DelegateInvocationHandler<TokenCreator> delegate, DelegateInvocationHandler<Master> master, RequestContextFactory requestContextFactory, Supplier<KernelAPI> kernelSupplier, IdGeneratorFactory idGeneratorFactory) {
        super(stateMachine, delegate);
        this.master = master;
        this.requestContextFactory = requestContextFactory;
        this.kernelSupplier = kernelSupplier;
        this.idGeneratorFactory = idGeneratorFactory;
    }

    @Override
    protected TokenCreator getMasterImpl() {
        return new DefaultLabelIdCreator(this.kernelSupplier, this.idGeneratorFactory);
    }

    @Override
    protected TokenCreator getSlaveImpl(URI serverHaUri) {
        return new SlaveLabelTokenCreator(this.master.cement(), this.requestContextFactory);
    }
}

