/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.ha.transaction.TransactionPropagator;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.state.NeoStoreInjectedTransactionValidator;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;

public class MasterTransactionCommitProcess
implements TransactionCommitProcess {
    private final TransactionPropagator pusher;
    private final NeoStoreInjectedTransactionValidator validator;
    private final TransactionCommitProcess inner;

    public MasterTransactionCommitProcess(TransactionCommitProcess commitProcess, TransactionPropagator pusher, NeoStoreInjectedTransactionValidator validator) {
        this.inner = commitProcess;
        this.pusher = pusher;
        this.validator = validator;
    }

    public long commit(TransactionRepresentation representation, LockGroup locks, CommitEvent commitEvent) throws TransactionFailureException {
        this.validator.assertInjectionAllowed(representation.getLatestCommittedTxWhenStarted());
        long result = this.inner.commit(representation, locks, commitEvent);
        this.pusher.committed(result, representation.getAuthorId());
        return result;
    }
}

