/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.IOException;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;

public class SlaveTransactionCommitProcess
implements TransactionCommitProcess {
    private final Master master;
    private final RequestContextFactory requestContextFactory;

    public SlaveTransactionCommitProcess(Master master, RequestContextFactory requestContextFactory) {
        this.master = master;
        this.requestContextFactory = requestContextFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long commit(TransactionRepresentation representation, LockGroup locks, CommitEvent commitEvent) throws TransactionFailureException {
        try {
            RequestContext context = this.requestContextFactory.newRequestContext(representation.getLockSessionId());
            try (Response<Long> response = this.master.commit(context, representation);){
                long l = (Long)response.response();
                return l;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

