/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.concurrent.TimeUnit;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class UpdatePullerClient
extends LifecycleAdapter {
    private final JobScheduler scheduler;
    private final Log log;
    private final UpdatePuller updatePuller;
    private final AvailabilityGuard availabilityGuard;
    private final long pullIntervalMillis;
    private JobScheduler.JobHandle intervalJobHandle;

    public UpdatePullerClient(long pullIntervalMillis, JobScheduler scheduler, LogProvider logProvider, UpdatePuller updatePullingThread, AvailabilityGuard availabilityGuard) {
        this.pullIntervalMillis = pullIntervalMillis;
        this.scheduler = scheduler;
        this.availabilityGuard = availabilityGuard;
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
        this.updatePuller = updatePullingThread;
    }

    public void pullUpdates() throws InterruptedException {
        if (!this.updatePuller.isActive() || !this.availabilityGuard.isAvailable(5000L)) {
            return;
        }
        this.updatePuller.await(UpdatePuller.NEXT_TICKET, false);
    }

    public void init() throws Throwable {
        if (this.pullIntervalMillis > 0L) {
            this.intervalJobHandle = this.scheduler.scheduleRecurring(JobScheduler.Group.pullUpdates, new Runnable(){

                @Override
                public void run() {
                    try {
                        UpdatePullerClient.this.pullUpdates();
                    }
                    catch (InterruptedException e) {
                        UpdatePullerClient.this.log.error("Pull updates failed", (Throwable)e);
                    }
                }
            }, this.pullIntervalMillis, this.pullIntervalMillis, TimeUnit.MILLISECONDS);
        }
    }

    public void shutdown() throws Throwable {
        if (this.intervalJobHandle != null) {
            this.intervalJobHandle.cancel(false);
        }
    }
}

