/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.backup;

import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.member.ClusterMemberEvents;
import org.neo4j.cluster.member.ClusterMemberListener;
import org.neo4j.cluster.member.paxos.PaxosClusterMemberEvents;
import org.neo4j.cluster.protocol.atomicbroadcast.AtomicBroadcast;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectInputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectOutputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectStreamFactory;
import org.neo4j.cluster.protocol.cluster.Cluster;
import org.neo4j.cluster.protocol.cluster.ClusterConfiguration;
import org.neo4j.cluster.protocol.cluster.ClusterEntryDeniedException;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.cluster.protocol.election.ElectionCredentialsProvider;
import org.neo4j.cluster.protocol.election.NotElectableElectionCredentialsProvider;
import org.neo4j.cluster.protocol.heartbeat.Heartbeat;
import org.neo4j.cluster.protocol.snapshot.Snapshot;
import org.neo4j.function.Predicate;
import org.neo4j.function.Predicates;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Function2;
import org.neo4j.helpers.NamedThreadFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.cluster.HANewSnapshotFunction;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.LifecycleException;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public final class HaBackupProvider {
    public URI resolve(String address, Args args, LogService logService) {
        Log log = logService.getInternalLog(HaBackupProvider.class);
        log.debug("Asking cluster member(s) at '" + address + "' for master");
        String clusterName = args.get(ClusterSettings.cluster_name.name(), null);
        if (clusterName == null) {
            clusterName = args.get(ClusterSettings.cluster_name.name(), ClusterSettings.cluster_name.getDefaultValue());
        }
        try {
            String master = this.getMasterServerInCluster(HaBackupProvider.normalizeAddress(address), clusterName, logService);
            log.debug("Found master '" + master + "' in cluster");
            return URI.create(master);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private static String normalizeAddress(String address) {
        int index = address.indexOf("://");
        if (index != -1) {
            return address.substring(index + 3);
        }
        return address;
    }

    private String getMasterServerInCluster(String from, String clusterName, LogService logService) {
        LifeSupport life = new LifeSupport();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(ClusterSettings.server_id.name(), "-1");
        params.put(ClusterSettings.cluster_name.name(), clusterName);
        params.put(ClusterSettings.initial_hosts.name(), from);
        params.put(ClusterSettings.instance_name.name(), "Backup");
        params.put(ClusterClient.clusterJoinTimeout.name(), "20s");
        Config config = null;
        ObjectStreamFactory objectStreamFactory = new ObjectStreamFactory();
        Monitors monitors = new Monitors();
        final ClusterClient clusterClient = (ClusterClient)life.add((Object)new ClusterClient(monitors, ClusterClient.adapt(config), logService, (ElectionCredentialsProvider)new NotElectableElectionCredentialsProvider(), (ObjectInputStreamFactory)objectStreamFactory, (ObjectOutputStreamFactory)objectStreamFactory));
        ClusterMemberEvents events = (ClusterMemberEvents)life.add((Object)new PaxosClusterMemberEvents((Snapshot)clusterClient, (Cluster)clusterClient, (Heartbeat)clusterClient, (AtomicBroadcast)clusterClient, (LogProvider)FormattedLogProvider.toOutputStream((OutputStream)System.out), Predicates.alwaysTrue(), (Function2)new HANewSnapshotFunction(), (ObjectInputStreamFactory)objectStreamFactory, (ObjectOutputStreamFactory)objectStreamFactory, (NamedThreadFactory.Monitor)monitors.newMonitor(NamedThreadFactory.Monitor.class, new String[0])));
        clusterClient.addClusterListener((ClusterListener)new ClusterListener.Adapter(){

            public void enteredCluster(ClusterConfiguration clusterConfiguration) {
                clusterClient.performRoleElections();
                clusterClient.removeClusterListener((ClusterListener)this);
            }
        });
        final Semaphore infoReceivedLatch = new Semaphore(0);
        final AtomicReference backupUri = new AtomicReference();
        events.addClusterMemberListener((ClusterMemberListener)new ClusterMemberListener.Adapter(){
            Map<InstanceId, URI> backupUris = new HashMap<InstanceId, URI>();
            InstanceId master = null;

            public void memberIsAvailable(String role, InstanceId clusterUri, URI roleUri, StoreId storeId) {
                if (this.master != null && this.backupUris.containsKey(this.master)) {
                    backupUri.set(this.backupUris.get(this.master));
                    infoReceivedLatch.release();
                }
            }

            public void coordinatorIsElected(InstanceId coordinatorId) {
            }
        });
        try {
            life.start();
            if (!infoReceivedLatch.tryAcquire(20L, TimeUnit.SECONDS)) {
                throw new RuntimeException("Could not find backup server in cluster " + clusterName + " at " + from + ", " + "operation timed out");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (LifecycleException e) {
            Throwable ex = Exceptions.peel((Throwable)e, (Predicate)Predicates.instanceOf(LifecycleException.class));
            if (ex != null && ex instanceof ClusterEntryDeniedException) {
                throw new RuntimeException("Another backup client is currently performing backup; concurrent backups are not allowed");
            }
            ex = Exceptions.peel((Throwable)e, (Predicate)Predicates.instanceOf(TimeoutException.class));
            if (ex != null) {
                throw new RuntimeException("Could not find backup server in cluster " + clusterName + " at " + from + ", " + "operation timed out");
            }
            throw new RuntimeException(Exceptions.peel((Throwable)e, (Predicate)new Predicate<Throwable>(){

                public boolean test(Throwable item) {
                    return !(item instanceof LifecycleException);
                }
            }));
        }
        finally {
            life.shutdown();
        }
        return ((URI)backupUri.get()).toString();
    }
}

