/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.net.URI;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.cluster.BindingListener;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.member.ClusterMemberAvailability;
import org.neo4j.cluster.protocol.election.Election;
import org.neo4j.function.Function;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.CancellationRequest;
import org.neo4j.helpers.Functions;
import org.neo4j.helpers.NamedThreadFactory;
import org.neo4j.helpers.Uris;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberChangeEvent;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberListener;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.ha.cluster.SwitchToMaster;
import org.neo4j.kernel.ha.cluster.SwitchToSlave;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.store.InconsistentlyUpgradedClusterException;
import org.neo4j.kernel.impl.store.MismatchingStoreIdException;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.store.UnableToCopyStoreFromOldMasterException;
import org.neo4j.kernel.impl.store.UnavailableMembersException;
import org.neo4j.kernel.impl.transaction.log.NoSuchLogVersionException;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;

public class HighAvailabilityModeSwitcher
implements HighAvailabilityMemberListener,
BindingListener,
Lifecycle {
    public static final String MASTER = "master";
    public static final String SLAVE = "slave";
    public static final String UNKNOWN = "UNKNOWN";
    public static final String INADDR_ANY = "0.0.0.0";
    private volatile URI masterHaURI;
    private volatile URI slaveHaURI;
    private CancellationHandle cancellationHandle;
    private URI availableMasterId;
    private SwitchToSlave switchToSlave;
    private SwitchToMaster switchToMaster;
    private final Election election;
    private final ClusterMemberAvailability clusterMemberAvailability;
    private final InstanceId instanceId;
    private final DependencyResolver dependencyResolver;
    private final Log msgLog;
    private final Log userLog;
    private LifeSupport haCommunicationLife;
    private ScheduledExecutorService modeSwitcherExecutor;
    private volatile URI me;
    private volatile Future<?> modeSwitcherFuture;
    private volatile HighAvailabilityMemberState currentTargetState;
    private final AtomicBoolean canAskForElections = new AtomicBoolean(true);

    public static InstanceId getServerId(URI haUri) {
        return (InstanceId)ClusterSettings.INSTANCE_ID.apply(Functions.withDefaults((Function)Functions.constant((Object)"-1"), (Function)Uris.parameter((String)"serverId")).apply((Object)haUri));
    }

    public HighAvailabilityModeSwitcher(SwitchToSlave switchToSlave, SwitchToMaster switchToMaster, Election election, ClusterMemberAvailability clusterMemberAvailability, DependencyResolver dependencyResolver, InstanceId instanceId, LogService logService) {
        this.switchToSlave = switchToSlave;
        this.switchToMaster = switchToMaster;
        this.election = election;
        this.clusterMemberAvailability = clusterMemberAvailability;
        this.instanceId = instanceId;
        this.msgLog = logService.getInternalLog(this.getClass());
        this.userLog = logService.getUserLog(this.getClass());
        this.haCommunicationLife = new LifeSupport();
        this.dependencyResolver = dependencyResolver;
    }

    public void listeningAt(URI myUri) {
        this.me = myUri;
    }

    public synchronized void init() throws Throwable {
        this.modeSwitcherExecutor = this.createExecutor();
        this.haCommunicationLife.init();
    }

    public synchronized void start() throws Throwable {
        this.haCommunicationLife.start();
    }

    public synchronized void stop() throws Throwable {
        this.haCommunicationLife.stop();
    }

    public synchronized void shutdown() throws Throwable {
        this.modeSwitcherExecutor.shutdown();
        this.modeSwitcherExecutor.awaitTermination(60L, TimeUnit.SECONDS);
        this.haCommunicationLife.shutdown();
        this.switchToMaster.close();
        this.switchToMaster = null;
        this.switchToSlave = null;
    }

    @Override
    public void masterIsElected(HighAvailabilityMemberChangeEvent event) {
        if (event.getNewState() == event.getOldState() && event.getOldState() == HighAvailabilityMemberState.MASTER) {
            this.clusterMemberAvailability.memberIsAvailable(MASTER, this.masterHaURI, this.resolveStoreId());
        } else {
            this.stateChanged(event);
        }
    }

    @Override
    public void masterIsAvailable(HighAvailabilityMemberChangeEvent event) {
        if (event.getNewState() == event.getOldState() && event.getOldState() == HighAvailabilityMemberState.SLAVE) {
            this.clusterMemberAvailability.memberIsAvailable(SLAVE, this.slaveHaURI, this.resolveStoreId());
        } else {
            this.stateChanged(event);
        }
    }

    @Override
    public void slaveIsAvailable(HighAvailabilityMemberChangeEvent event) {
    }

    @Override
    public void instanceStops(HighAvailabilityMemberChangeEvent event) {
        this.stateChanged(event);
    }

    public void forceElections() {
        if (this.canAskForElections.compareAndSet(true, false)) {
            this.clusterMemberAvailability.memberIsUnavailable(SLAVE);
            this.election.performRoleElections();
        }
    }

    private void stateChanged(HighAvailabilityMemberChangeEvent event) {
        if (event.getNewState() == event.getOldState()) {
            if (event.getServerHaUri() != null) {
                this.availableMasterId = event.getServerHaUri();
            }
            return;
        }
        this.availableMasterId = event.getServerHaUri();
        this.currentTargetState = event.getNewState();
        switch (event.getNewState()) {
            case TO_MASTER: {
                if (event.getOldState().equals((Object)HighAvailabilityMemberState.SLAVE)) {
                    this.clusterMemberAvailability.memberIsUnavailable(SLAVE);
                }
                this.switchToMaster();
                break;
            }
            case TO_SLAVE: {
                this.switchToSlave();
                break;
            }
            case PENDING: {
                if (event.getOldState().equals((Object)HighAvailabilityMemberState.SLAVE)) {
                    this.clusterMemberAvailability.memberIsUnavailable(SLAVE);
                } else if (event.getOldState().equals((Object)HighAvailabilityMemberState.MASTER)) {
                    this.clusterMemberAvailability.memberIsUnavailable(MASTER);
                }
                this.switchToPending();
                break;
            }
        }
    }

    private void switchToMaster() {
        final CancellationHandle cancellationHandle = new CancellationHandle();
        this.startModeSwitching(new Runnable(){

            @Override
            public void run() {
                if (cancellationHandle.cancellationRequested()) {
                    HighAvailabilityModeSwitcher.this.msgLog.info("Switch to master cancelled in the beginning of switching to master.");
                    return;
                }
                if (HighAvailabilityModeSwitcher.this.currentTargetState != HighAvailabilityMemberState.TO_MASTER) {
                    return;
                }
                HighAvailabilityModeSwitcher.this.haCommunicationLife.shutdown();
                HighAvailabilityModeSwitcher.this.haCommunicationLife = new LifeSupport();
                try {
                    HighAvailabilityModeSwitcher.this.masterHaURI = HighAvailabilityModeSwitcher.this.switchToMaster.switchToMaster(HighAvailabilityModeSwitcher.this.haCommunicationLife, HighAvailabilityModeSwitcher.this.me);
                    HighAvailabilityModeSwitcher.this.canAskForElections.set(true);
                }
                catch (Throwable e) {
                    HighAvailabilityModeSwitcher.this.msgLog.error("Failed to switch to master", e);
                    HighAvailabilityModeSwitcher.this.election.demote(HighAvailabilityModeSwitcher.this.instanceId);
                }
            }
        }, cancellationHandle);
    }

    private void switchToSlave() {
        if (HighAvailabilityModeSwitcher.getServerId(this.availableMasterId).equals((Object)this.instanceId)) {
            this.msgLog.error("I (" + this.me + ") tried to switch to slave for myself as master (" + this.availableMasterId + ")");
            return;
        }
        final AtomicLong wait = new AtomicLong();
        final CancellationHandle cancellationHandle = new CancellationHandle();
        this.startModeSwitching(new Runnable(){

            @Override
            public void run() {
                if (HighAvailabilityModeSwitcher.this.currentTargetState != HighAvailabilityMemberState.TO_SLAVE) {
                    return;
                }
                try {
                    HighAvailabilityModeSwitcher.this.haCommunicationLife.shutdown();
                    HighAvailabilityModeSwitcher.this.haCommunicationLife = new LifeSupport();
                    URI resultingSlaveHaURI = HighAvailabilityModeSwitcher.this.switchToSlave.switchToSlave(HighAvailabilityModeSwitcher.this.haCommunicationLife, HighAvailabilityModeSwitcher.this.me, HighAvailabilityModeSwitcher.this.availableMasterId, cancellationHandle);
                    if (resultingSlaveHaURI == null) {
                        HighAvailabilityModeSwitcher.this.msgLog.info("Switch to slave is effectively cancelled");
                    } else {
                        HighAvailabilityModeSwitcher.this.slaveHaURI = resultingSlaveHaURI;
                        HighAvailabilityModeSwitcher.this.canAskForElections.set(true);
                    }
                }
                catch (InconsistentlyUpgradedClusterException | UnableToCopyStoreFromOldMasterException | UnavailableMembersException e) {
                    HighAvailabilityModeSwitcher.this.userLog.error("UNABLE TO START UP AS SLAVE: %s", new Object[]{e.getMessage()});
                    HighAvailabilityModeSwitcher.this.msgLog.error("Unable to start up as slave", e);
                    HighAvailabilityModeSwitcher.this.clusterMemberAvailability.memberIsUnavailable(HighAvailabilityModeSwitcher.SLAVE);
                    ClusterClient clusterClient = (ClusterClient)HighAvailabilityModeSwitcher.this.dependencyResolver.resolveDependency(ClusterClient.class);
                    try {
                        clusterClient.leave();
                        clusterClient.stop();
                        HighAvailabilityModeSwitcher.this.haCommunicationLife.shutdown();
                    }
                    catch (Throwable t) {
                        HighAvailabilityModeSwitcher.this.msgLog.error("Unable to stop cluster client", t);
                    }
                    HighAvailabilityModeSwitcher.this.modeSwitcherExecutor.schedule(this, 5L, TimeUnit.SECONDS);
                    throw e;
                }
                catch (MismatchingStoreIdException | NoSuchLogVersionException e) {
                    this.run();
                }
                catch (Throwable t) {
                    HighAvailabilityModeSwitcher.this.msgLog.error("Error while trying to switch to slave", t);
                    wait.set(1L + wait.get() * 2L);
                    wait.set(Math.min(wait.get(), 300L));
                    HighAvailabilityModeSwitcher.this.modeSwitcherFuture = HighAvailabilityModeSwitcher.this.modeSwitcherExecutor.schedule(this, wait.get(), TimeUnit.SECONDS);
                    HighAvailabilityModeSwitcher.this.msgLog.info("Attempting to switch to slave in %ds", new Object[]{wait.get()});
                }
            }
        }, cancellationHandle);
    }

    private void switchToPending() {
        this.msgLog.info("I am %s, moving to pending", new Object[]{this.instanceId});
        this.startModeSwitching(new Runnable(){

            @Override
            public void run() {
                HighAvailabilityModeSwitcher.this.haCommunicationLife.shutdown();
                HighAvailabilityModeSwitcher.this.haCommunicationLife = new LifeSupport();
            }
        }, new CancellationHandle());
        try {
            this.modeSwitcherFuture.get(10L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized void startModeSwitching(Runnable switcher, CancellationHandle cancellationHandle) {
        if (this.modeSwitcherFuture != null) {
            this.cancellationHandle.cancel();
            try {
                this.modeSwitcherFuture.get();
            }
            catch (InconsistentlyUpgradedClusterException | UnableToCopyStoreFromOldMasterException | UnavailableMembersException e) {
                throw e;
            }
            catch (Exception e) {
                this.msgLog.warn("Got exception from cancelled task", (Throwable)e);
            }
        }
        this.cancellationHandle = cancellationHandle;
        this.modeSwitcherFuture = this.modeSwitcherExecutor.submit(switcher);
    }

    private StoreId resolveStoreId() {
        return (StoreId)this.dependencyResolver.resolveDependency(StoreId.class);
    }

    ScheduledExecutorService createExecutor() {
        return Executors.newSingleThreadScheduledExecutor((ThreadFactory)NamedThreadFactory.named((String)"HA Mode switcher"));
    }

    private static class CancellationHandle
    implements CancellationRequest {
        private volatile boolean cancelled = false;

        private CancellationHandle() {
        }

        public boolean cancellationRequested() {
            return this.cancelled;
        }

        public void cancel() {
            assert (!this.cancelled) : "Should not cancel on the same request twice";
            this.cancelled = true;
        }
    }
}

