/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.com.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.com.TransactionNotPresentOnMasterException;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.function.Consumer;
import org.neo4j.function.Factory;
import org.neo4j.helpers.Clock;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.com.master.HandshakeResult;
import org.neo4j.kernel.ha.com.master.InvalidEpochException;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.id.IdAllocation;
import org.neo4j.kernel.ha.lock.LockResult;
import org.neo4j.kernel.ha.lock.LockStatus;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.transaction.IllegalResourceException;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.collection.ConcurrentAccessException;
import org.neo4j.kernel.impl.util.collection.NoSuchEntryException;
import org.neo4j.kernel.impl.util.collection.TimedRepository;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class MasterImpl
extends LifecycleAdapter
implements Master {
    public static final int TX_TIMEOUT_ADDITION = 5000;
    public static final int UNFINISHED_TRANSACTION_CLEANUP_DELAY = 1000;
    private final SPI spi;
    private final Config config;
    private final Monitor monitor;
    private final long epoch;
    private TimedRepository<RequestContext, Locks.Client> slaveLockSessions;
    private JobScheduler.JobHandle staleSlaveReaperJob;
    private final int unfinishedSessionsCheckInterval;

    public MasterImpl(SPI spi, Monitor monitor, Config config) {
        this(spi, monitor, config, 1000);
    }

    public MasterImpl(SPI spi, Monitor monitor, Config config, int staleSlaveReapIntervalMillis) {
        this.spi = spi;
        this.unfinishedSessionsCheckInterval = staleSlaveReapIntervalMillis;
        this.config = config;
        this.monitor = monitor;
        this.epoch = this.generateEpoch();
    }

    private long generateEpoch() {
        return (long)((InstanceId)this.config.get(ClusterSettings.server_id)).toIntegerIndex() << 48 | System.currentTimeMillis();
    }

    public void start() throws Throwable {
        this.slaveLockSessions = new TimedRepository((Factory)new org.neo4j.helpers.Factory<Locks.Client>(){

            public Locks.Client newInstance() {
                return MasterImpl.this.spi.acquireClient();
            }
        }, (Consumer)new Consumer<Locks.Client>(){

            public void accept(Locks.Client value) {
                value.close();
            }
        }, (Long)this.config.get(HaSettings.lock_read_timeout) + 5000L, Clock.SYSTEM_CLOCK);
        this.staleSlaveReaperJob = this.spi.scheduleRecurringJob(JobScheduler.Group.slaveLocksTimeout, this.unfinishedSessionsCheckInterval, (Runnable)this.slaveLockSessions);
    }

    public void stop() {
        this.staleSlaveReaperJob.cancel(false);
        this.slaveLockSessions = null;
    }

    private void assertCorrectEpoch(RequestContext context) {
        if (this.epoch != context.getEpoch()) {
            throw new InvalidEpochException(this.epoch, context.getEpoch());
        }
    }

    @Override
    public Response<IdAllocation> allocateIds(RequestContext context, IdType idType) {
        this.assertCorrectEpoch(context);
        IdAllocation result = this.spi.allocateIds(idType);
        return this.spi.packEmptyResponse(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response<Long> commit(RequestContext context, TransactionRepresentation preparedTransaction) throws IOException, TransactionFailureException {
        Response<Long> response;
        this.assertCorrectEpoch(context);
        if (context.getEventIdentifier() == -1) {
            try (Locks.Client locks = this.spi.acquireClient();){
                Response<Long> response2 = this.commit0(context, preparedTransaction, locks);
                return response2;
            }
        }
        Locks.Client locks = (Locks.Client)this.slaveLockSessions.acquire((Object)context);
        try {
            response = this.commit0(context, preparedTransaction, locks);
        }
        catch (Throwable throwable) {
            try {
                this.slaveLockSessions.release((Object)context);
                throw throwable;
            }
            catch (ConcurrentAccessException | NoSuchEntryException e) {
                throw new TransactionNotPresentOnMasterException(context);
            }
        }
        this.slaveLockSessions.release((Object)context);
        return response;
    }

    private Response<Long> commit0(RequestContext context, TransactionRepresentation preparedTransaction, Locks.Client locks) throws IOException, TransactionFailureException {
        if (locks.trySharedLock((Locks.ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()})) {
            long txId = this.spi.applyPreparedTransaction(preparedTransaction);
            return this.spi.packTransactionObligationResponse(context, txId);
        }
        throw new TransactionFailureException((Status)Status.Schema.ModifiedConcurrently, "Failed to commit, because another transaction is making schema changes. Slave commits are disallowed while schema changes are being committed. Retrying the transaction should yield a successful result.", new Object[0]);
    }

    @Override
    public Response<Integer> createRelationshipType(RequestContext context, String name) {
        this.assertCorrectEpoch(context);
        return this.spi.packTransactionObligationResponse(context, this.spi.createRelationshipType(name));
    }

    @Override
    public Response<Integer> createPropertyKey(RequestContext context, String name) {
        this.assertCorrectEpoch(context);
        return this.spi.packTransactionObligationResponse(context, this.spi.getOrCreateProperty(name));
    }

    @Override
    public Response<Integer> createLabel(RequestContext context, String name) {
        this.assertCorrectEpoch(context);
        return this.spi.packTransactionObligationResponse(context, this.spi.getOrCreateLabel(name));
    }

    @Override
    public Response<Void> pullUpdates(RequestContext context) {
        return this.spi.packTransactionStreamResponse(context, null);
    }

    @Override
    public Response<HandshakeResult> handshake(long txId, StoreId storeId) {
        try {
            long checksum = this.spi.getTransactionChecksum(txId);
            return this.spi.packEmptyResponse(new HandshakeResult(checksum, this.epoch));
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't get master ID for transaction id " + txId, e);
        }
    }

    @Override
    public Response<Void> copyStore(RequestContext requestContext, StoreWriter writer) {
        RequestContext context;
        try (StoreWriter storeWriter = writer;){
            context = this.spi.flushStoresAndStreamStoreFiles(storeWriter);
        }
        return this.spi.packTransactionStreamResponse(context, null);
    }

    @Override
    public Response<Void> newLockSession(RequestContext context) throws TransactionFailureException {
        this.monitor.initializeTx(context);
        if (!this.spi.isAccessible()) {
            throw new TransactionFailureException((Status)Status.General.DatabaseUnavailable, "Database is currently not available", new Object[0]);
        }
        this.assertCorrectEpoch(context);
        try {
            this.slaveLockSessions.begin((Object)context);
        }
        catch (ConcurrentAccessException e) {
            throw new TransactionFailureException((Status)Status.Transaction.ConcurrentRequest, (Throwable)e, "The lock session requested to start is already in use. Please retry your request in a few seconds.", new Object[0]);
        }
        return this.spi.packTransactionObligationResponse(context, null);
    }

    @Override
    public Response<Void> endLockSession(RequestContext context, boolean success) {
        this.assertCorrectEpoch(context);
        this.slaveLockSessions.end((Object)context);
        return this.spi.packTransactionObligationResponse(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response<LockResult> acquireExclusiveLock(RequestContext context, Locks.ResourceType type, long ... resourceIds) {
        Locks.Client session;
        this.assertCorrectEpoch(context);
        try {
            session = (Locks.Client)this.slaveLockSessions.acquire((Object)context);
        }
        catch (ConcurrentAccessException | NoSuchEntryException e) {
            return this.spi.packTransactionObligationResponse(context, new LockResult("Unable to acquire exclusive lock: " + e.getMessage()));
        }
        try {
            session.acquireExclusive(type, resourceIds);
            Response<LockResult> e = this.spi.packTransactionObligationResponse(context, new LockResult(LockStatus.OK_LOCKED));
            return e;
        }
        catch (DeadlockDetectedException e) {
            Response<LockResult> response = this.spi.packTransactionObligationResponse(context, new LockResult("Can't acquire exclusive lock, because it would have caused a deadlock: " + e.getMessage()));
            return response;
        }
        catch (IllegalResourceException e) {
            Response<LockResult> response = this.spi.packTransactionObligationResponse(context, new LockResult(LockStatus.NOT_LOCKED));
            return response;
        }
        finally {
            this.slaveLockSessions.release((Object)context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response<LockResult> acquireSharedLock(RequestContext context, Locks.ResourceType type, long ... resourceIds) {
        Locks.Client session;
        this.assertCorrectEpoch(context);
        try {
            session = (Locks.Client)this.slaveLockSessions.acquire((Object)context);
        }
        catch (ConcurrentAccessException | NoSuchEntryException e) {
            return this.spi.packTransactionObligationResponse(context, new LockResult("Unable to acquire shared lock: " + e.getMessage()));
        }
        try {
            session.acquireShared(type, resourceIds);
            Response<LockResult> e = this.spi.packTransactionObligationResponse(context, new LockResult(LockStatus.OK_LOCKED));
            return e;
        }
        catch (DeadlockDetectedException e) {
            Response<LockResult> response = this.spi.packTransactionObligationResponse(context, new LockResult(e.getMessage()));
            return response;
        }
        catch (IllegalResourceException e) {
            Response<LockResult> response = this.spi.packTransactionObligationResponse(context, new LockResult(LockStatus.NOT_LOCKED));
            return response;
        }
        finally {
            this.slaveLockSessions.release((Object)context);
        }
    }

    public Map<Integer, Collection<RequestContext>> getOngoingTransactions() {
        HashMap<Integer, Collection<RequestContext>> result = new HashMap<Integer, Collection<RequestContext>>();
        Set contexts = this.slaveLockSessions.keys();
        for (RequestContext context : contexts.toArray(new RequestContext[contexts.size()])) {
            ArrayList<RequestContext> txs = (ArrayList<RequestContext>)result.get(context.machineId());
            if (txs == null) {
                txs = new ArrayList<RequestContext>();
                result.put(context.machineId(), txs);
            }
            txs.add(context);
        }
        return result;
    }

    public static interface SPI {
        public boolean isAccessible();

        public IdAllocation allocateIds(IdType var1);

        public StoreId storeId();

        public long applyPreparedTransaction(TransactionRepresentation var1) throws IOException, TransactionFailureException;

        public Integer createRelationshipType(String var1);

        public long getTransactionChecksum(long var1) throws IOException;

        public RequestContext flushStoresAndStreamStoreFiles(StoreWriter var1);

        public <T> Response<T> packEmptyResponse(T var1);

        public <T> Response<T> packTransactionStreamResponse(RequestContext var1, T var2);

        public <T> Response<T> packTransactionObligationResponse(RequestContext var1, T var2);

        public int getOrCreateLabel(String var1);

        public int getOrCreateProperty(String var1);

        public Locks.Client acquireClient();

        public JobScheduler.JobHandle scheduleRecurringJob(JobScheduler.Group var1, long var2, Runnable var4);
    }

    public static interface Monitor {
        public void initializeTx(RequestContext var1);
    }
}

