/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.com.master;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.jboss.netty.channel.Channel;
import org.neo4j.com.RequestContext;
import org.neo4j.com.RequestType;
import org.neo4j.com.Response;
import org.neo4j.com.Server;
import org.neo4j.com.TransactionNotPresentOnMasterException;
import org.neo4j.com.TxChecksumVerifier;
import org.neo4j.com.monitor.RequestMonitor;
import org.neo4j.helpers.Clock;
import org.neo4j.kernel.ha.HaRequestType210;
import org.neo4j.kernel.ha.MasterClient214;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.master.MasterImpl;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.logging.LogProvider;

public class MasterServer
extends Server<Master, Void> {
    public static final int FRAME_LENGTH = 0x1000000;

    public MasterServer(Master requestTarget, LogProvider logProvider, Server.Configuration config, TxChecksumVerifier txVerifier, ByteCounterMonitor byteCounterMonitor, RequestMonitor requestMonitor) {
        super((Object)requestTarget, config, logProvider, 0x1000000, MasterClient214.PROTOCOL_VERSION, txVerifier, Clock.SYSTEM_CLOCK, byteCounterMonitor, requestMonitor);
    }

    protected RequestType<Master> getRequestContext(byte id) {
        return HaRequestType210.values()[id];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishOffChannel(Channel channel, RequestContext context) {
        try {
            Response<Void> ignored = ((Master)this.getRequestTarget()).endLockSession(context, false);
            Throwable throwable = null;
            if (ignored != null) {
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                } else {
                    ignored.close();
                }
            }
        }
        catch (TransactionNotPresentOnMasterException transactionNotPresentOnMasterException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, Collection<RequestContext>> getSlaveInformation() {
        Map channels;
        HashSet<Integer> machineIds = new HashSet<Integer>();
        Map map = channels = this.getConnectedSlaveChannels();
        synchronized (map) {
            for (RequestContext context : channels.values()) {
                machineIds.add(context.machineId());
            }
        }
        Map<Integer, Collection<RequestContext>> ongoingTransactions = ((MasterImpl)this.getRequestTarget()).getOngoingTransactions();
        for (Integer machineId : machineIds) {
            if (ongoingTransactions.containsKey(machineId)) continue;
            ongoingTransactions.put(machineId, Collections.emptyList());
        }
        return new TreeMap<Integer, Collection<RequestContext>>(ongoingTransactions);
    }
}

