/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.lock;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.impl.locking.DumpLocksVisitor;
import org.neo4j.kernel.impl.locking.LockType;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.logging.FormattedLog;
import org.neo4j.logging.Log;

public class LocalDeadlockDetectedException
extends DeadlockDetectedException {
    public LocalDeadlockDetectedException(Locks.Client lockClient, Locks lockManager, Locks.ResourceType resourceType, long[] resourceIds, LockType type) {
        super(LocalDeadlockDetectedException.constructHelpfulDiagnosticsMessage(lockClient, lockManager, resourceType, resourceIds, type));
    }

    private static String constructHelpfulDiagnosticsMessage(Locks.Client client, Locks lockManager, Locks.ResourceType resourceType, long[] resourceIds, LockType type) {
        StringWriter stringWriter = new StringWriter();
        stringWriter.append(String.format("%s tried to apply local %s lock on %s(%s) after acquired on master. Currently these locks exist:%n", client, type, resourceType, Arrays.toString(resourceIds)));
        lockManager.accept((Locks.Visitor)new DumpLocksVisitor((Log)FormattedLog.toWriter((Writer)stringWriter)));
        return stringWriter.toString();
    }
}

