/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.lock.forseti;

import java.util.concurrent.ConcurrentMap;
import org.neo4j.collection.pool.LinkedQueuePool;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongIntMap;
import org.neo4j.collection.primitive.PrimitiveLongVisitor;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.ha.lock.forseti.ExclusiveLock;
import org.neo4j.kernel.ha.lock.forseti.ForsetiLockManager;
import org.neo4j.kernel.ha.lock.forseti.SharedLock;
import org.neo4j.kernel.impl.locking.AcquireLockTimeoutException;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.util.collection.SimpleBitSet;
import org.neo4j.kernel.impl.util.concurrent.WaitStrategy;

public class ForsetiClient
implements Locks.Client {
    private final int myId;
    private final ConcurrentMap<Long, ForsetiLockManager.Lock>[] lockMaps;
    private final WaitStrategy<AcquireLockTimeoutException>[] waitStrategies;
    private final LinkedQueuePool<ForsetiClient> clientPool;
    private final PrimitiveLongIntMap[] sharedLockCounts;
    private final PrimitiveLongIntMap[] exclusiveLockCounts;
    private final SimpleBitSet waitList = new SimpleBitSet(64);
    private final ExclusiveLock myExclusiveLock = new ExclusiveLock(this);
    private final ReleaseSharedLocksVisitor releaseSharedLockVisitor = new ReleaseSharedLocksVisitor();
    private final ReleaseExclusiveLocksVisitor releaseExclusiveLockVisitor = new ReleaseExclusiveLocksVisitor();
    private final ReleaseExclusiveLocksAndClearSharedVisitor releaseExclusiveAndClearSharedVisitor = new ReleaseExclusiveLocksAndClearSharedVisitor();
    private final ReleaseSharedDontCheckExclusiveVisitor releaseSharedDontCheckExclusiveVisitor = new ReleaseSharedDontCheckExclusiveVisitor();

    public ForsetiClient(int id, ConcurrentMap<Long, ForsetiLockManager.Lock>[] lockMaps, WaitStrategy<AcquireLockTimeoutException>[] waitStrategies, LinkedQueuePool<ForsetiClient> clientPool) {
        this.myId = id;
        this.lockMaps = lockMaps;
        this.waitStrategies = waitStrategies;
        this.clientPool = clientPool;
        this.sharedLockCounts = new PrimitiveLongIntMap[lockMaps.length];
        this.exclusiveLockCounts = new PrimitiveLongIntMap[lockMaps.length];
        for (int i = 0; i < this.sharedLockCounts.length; ++i) {
            this.sharedLockCounts[i] = Primitive.longIntMap();
            this.exclusiveLockCounts[i] = Primitive.longIntMap();
        }
    }

    public void acquireShared(Locks.ResourceType resourceType, long ... resourceIds) throws AcquireLockTimeoutException {
        ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap = this.lockMaps[resourceType.typeId()];
        PrimitiveLongIntMap heldShareLocks = this.sharedLockCounts[resourceType.typeId()];
        PrimitiveLongIntMap heldExclusiveLocks = this.exclusiveLockCounts[resourceType.typeId()];
        for (long resourceId : resourceIds) {
            int heldCount = heldShareLocks.get(resourceId);
            if (heldCount != -1) {
                heldShareLocks.put(resourceId, heldCount + 1);
                continue;
            }
            if (heldExclusiveLocks.containsKey(resourceId)) {
                heldShareLocks.put(resourceId, 1);
                continue;
            }
            int tries = 0;
            SharedLock mySharedLock = null;
            while (true) {
                ForsetiLockManager.Lock existingLock;
                if ((existingLock = (ForsetiLockManager.Lock)lockMap.get(resourceId)) == null) {
                    if (mySharedLock == null) {
                        mySharedLock = new SharedLock(this);
                    }
                    if (lockMap.putIfAbsent(resourceId, mySharedLock) != null) continue;
                    break;
                }
                if (existingLock instanceof SharedLock) {
                    if (((SharedLock)existingLock).acquire(this)) {
                        break;
                    }
                } else if (!(existingLock instanceof ExclusiveLock)) {
                    throw new UnsupportedOperationException("Unknown lock type: " + existingLock);
                }
                this.waitStrategies[resourceType.typeId()].apply((long)tries++);
                this.markAsWaitingFor(existingLock, resourceType, resourceId);
            }
            this.clearWaitList();
            heldShareLocks.put(resourceId, 1);
        }
    }

    public void acquireExclusive(Locks.ResourceType resourceType, long ... resourceIds) throws AcquireLockTimeoutException {
        ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap = this.lockMaps[resourceType.typeId()];
        PrimitiveLongIntMap heldLocks = this.exclusiveLockCounts[resourceType.typeId()];
        for (long resourceId : resourceIds) {
            SharedLock sharedLock;
            ForsetiLockManager.Lock existingLock;
            int heldCount = heldLocks.get(resourceId);
            if (heldCount != -1) {
                heldLocks.put(resourceId, heldCount + 1);
                continue;
            }
            int tries = 0;
            while (!((existingLock = lockMap.putIfAbsent(resourceId, this.myExclusiveLock)) == null || tries > 50 && existingLock instanceof SharedLock && this.tryUpgradeSharedToExclusive(resourceType, lockMap, resourceId, sharedLock = (SharedLock)existingLock))) {
                this.waitStrategies[resourceType.typeId()].apply((long)tries++);
                this.markAsWaitingFor(existingLock, resourceType, resourceId);
            }
            this.clearWaitList();
            heldLocks.put(resourceId, 1);
        }
    }

    public boolean tryExclusiveLock(Locks.ResourceType resourceType, long ... resourceIds) {
        ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap = this.lockMaps[resourceType.typeId()];
        PrimitiveLongIntMap heldLocks = this.exclusiveLockCounts[resourceType.typeId()];
        for (long resourceId : resourceIds) {
            int heldCount = heldLocks.get(resourceId);
            if (heldCount != -1) {
                heldLocks.put(resourceId, heldCount + 1);
                continue;
            }
            ForsetiLockManager.Lock lock = lockMap.putIfAbsent(resourceId, this.myExclusiveLock);
            if (lock != null) {
                SharedLock sharedLock;
                if (lock instanceof SharedLock && this.sharedLockCounts[resourceType.typeId()].containsKey(resourceId) && (sharedLock = (SharedLock)lock).tryAcquireUpdateLock(this)) {
                    if (sharedLock.numberOfHolders() == 1) {
                        lockMap.put(resourceId, this.myExclusiveLock);
                        heldLocks.put(resourceId, 1);
                        continue;
                    }
                    sharedLock.releaseUpdateLock(this);
                    return false;
                }
                return false;
            }
            heldLocks.put(resourceId, 1);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean trySharedLock(Locks.ResourceType resourceType, long ... resourceIds) {
        ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap = this.lockMaps[resourceType.typeId()];
        PrimitiveLongIntMap heldShareLocks = this.sharedLockCounts[resourceType.typeId()];
        PrimitiveLongIntMap heldExclusiveLocks = this.exclusiveLockCounts[resourceType.typeId()];
        for (long resourceId : resourceIds) {
            block7: {
                ForsetiLockManager.Lock existingLock;
                int heldCount = heldShareLocks.get(resourceId);
                if (heldCount != -1) {
                    heldShareLocks.put(resourceId, heldCount + 1);
                    continue;
                }
                if (heldExclusiveLocks.containsKey(resourceId)) {
                    heldShareLocks.put(resourceId, 1);
                    continue;
                }
                while (true) {
                    if ((existingLock = (ForsetiLockManager.Lock)lockMap.get(resourceId)) == null) {
                        if (lockMap.putIfAbsent(resourceId, new SharedLock(this)) != null) continue;
                    } else {
                        if (!(existingLock instanceof SharedLock)) break;
                        if (!((SharedLock)existingLock).acquire(this)) {
                            if (((SharedLock)existingLock).isUpdateLock()) return false;
                            continue;
                        }
                    }
                    break block7;
                    break;
                }
                if (!(existingLock instanceof ExclusiveLock)) throw new UnsupportedOperationException("Unknown lock type: " + existingLock);
                return false;
            }
            heldShareLocks.put(resourceId, 1);
        }
        return true;
    }

    public void releaseShared(Locks.ResourceType resourceType, long ... resourceIds) {
        for (long resourceId : resourceIds) {
            if (this.releaseLocalLock(resourceType, resourceId, this.sharedLockCounts[resourceType.typeId()]) || this.exclusiveLockCounts[resourceType.typeId()].containsKey(resourceId)) continue;
            this.releaseGlobalLock(this.lockMaps[resourceType.typeId()], resourceId);
        }
    }

    public void releaseExclusive(Locks.ResourceType resourceType, long ... resourceIds) {
        for (long resourceId : resourceIds) {
            if (this.releaseLocalLock(resourceType, resourceId, this.exclusiveLockCounts[resourceType.typeId()])) continue;
            if (this.sharedLockCounts[resourceType.typeId()].containsKey(resourceId)) {
                this.lockMaps[resourceType.typeId()].put(resourceId, new SharedLock(this));
                continue;
            }
            this.releaseGlobalLock(this.lockMaps[resourceType.typeId()], resourceId);
        }
    }

    public void releaseAllShared() {
        for (int i = 0; i < this.sharedLockCounts.length; ++i) {
            PrimitiveLongIntMap localLocks = this.sharedLockCounts[i];
            if (localLocks == null) continue;
            int size = localLocks.size();
            localLocks.visitKeys(this.releaseSharedLockVisitor.initialize(this.exclusiveLockCounts[i], this.lockMaps[i]));
            if (size <= 32) {
                localLocks.clear();
                continue;
            }
            this.sharedLockCounts[i] = Primitive.longIntMap();
        }
    }

    public void releaseAllExclusive() {
        for (int i = 0; i < this.exclusiveLockCounts.length; ++i) {
            PrimitiveLongIntMap localLocks = this.exclusiveLockCounts[i];
            if (localLocks == null) continue;
            int size = localLocks.size();
            localLocks.visitKeys(this.releaseExclusiveLockVisitor.initialize(this.sharedLockCounts[i], this.lockMaps[i]));
            if (size <= 32) {
                localLocks.clear();
                continue;
            }
            this.exclusiveLockCounts[i] = Primitive.longIntMap();
        }
    }

    public void releaseAll() {
        for (int i = 0; i < this.exclusiveLockCounts.length; ++i) {
            int size;
            PrimitiveLongIntMap exclusiveLocks = this.exclusiveLockCounts[i];
            PrimitiveLongIntMap sharedLocks = this.sharedLockCounts[i];
            if (exclusiveLocks != null) {
                size = exclusiveLocks.size();
                exclusiveLocks.visitKeys(this.releaseExclusiveAndClearSharedVisitor.initialize(sharedLocks, this.lockMaps[i]));
                if (size <= 32) {
                    exclusiveLocks.clear();
                } else {
                    this.exclusiveLockCounts[i] = Primitive.longIntMap();
                }
            }
            if (sharedLocks == null) continue;
            size = sharedLocks.size();
            sharedLocks.visitKeys(this.releaseSharedDontCheckExclusiveVisitor.initialize(this.lockMaps[i]));
            if (size <= 32) {
                sharedLocks.clear();
                continue;
            }
            this.sharedLockCounts[i] = Primitive.longIntMap();
        }
    }

    public void close() {
        this.releaseAll();
        this.clientPool.release((Object)this);
    }

    public int getLockSessionId() {
        return this.myId;
    }

    public int waitListSize() {
        return this.waitList.size();
    }

    public void copyWaitListTo(SimpleBitSet other) {
        other.put(this.waitList);
    }

    public boolean isWaitingFor(int clientId) {
        return clientId != this.myId && this.waitList.contains(clientId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ForsetiClient that = (ForsetiClient)o;
        return this.myId == that.myId;
    }

    public int hashCode() {
        return this.myId;
    }

    public String toString() {
        return String.format("ForsetiClient[%d]", this.myId);
    }

    private void releaseGlobalLock(ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap, long resourceId) {
        ForsetiLockManager.Lock lock = (ForsetiLockManager.Lock)lockMap.get(resourceId);
        if (lock instanceof ExclusiveLock) {
            lockMap.remove(resourceId);
        } else if (lock instanceof SharedLock && ((SharedLock)lock).release(this)) {
            lockMap.remove(resourceId);
        }
    }

    private boolean releaseLocalLock(Locks.ResourceType type, long resourceId, PrimitiveLongIntMap localLocks) {
        int lockCount = localLocks.remove(resourceId);
        if (lockCount == -1) {
            throw new IllegalStateException(this + " cannot release lock that it does not hold: " + type + "[" + resourceId + "].");
        }
        if (lockCount > 1) {
            localLocks.put(resourceId, lockCount - 1);
            return true;
        }
        return false;
    }

    private boolean tryUpgradeSharedToExclusive(Locks.ResourceType resourceType, ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap, long resourceId, SharedLock sharedLock) throws AcquireLockTimeoutException {
        int tries = 0;
        if (!this.sharedLockCounts[resourceType.typeId()].containsKey(resourceId)) {
            if (!sharedLock.acquire(this)) {
                return false;
            }
            try {
                if (this.tryUpgradeToExclusiveWithShareLockHeld(resourceType, lockMap, resourceId, sharedLock, tries)) {
                    return true;
                }
                this.releaseGlobalLock(lockMap, resourceId);
                return false;
            }
            catch (Throwable e) {
                this.releaseGlobalLock(lockMap, resourceId);
                throw e;
            }
        }
        return this.tryUpgradeToExclusiveWithShareLockHeld(resourceType, lockMap, resourceId, sharedLock, tries);
    }

    private boolean tryUpgradeToExclusiveWithShareLockHeld(Locks.ResourceType resourceType, ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap, long resourceId, SharedLock sharedLock, int tries) throws AcquireLockTimeoutException {
        if (sharedLock.tryAcquireUpdateLock(this)) {
            try {
                while (sharedLock.numberOfHolders() > 1) {
                    this.waitStrategies[resourceType.typeId()].apply((long)tries++);
                    this.markAsWaitingFor(sharedLock, resourceType, resourceId);
                }
                lockMap.put(resourceId, this.myExclusiveLock);
                return true;
            }
            catch (DeadlockDetectedException e) {
                sharedLock.releaseUpdateLock(this);
                throw e;
            }
            catch (Throwable e) {
                sharedLock.releaseUpdateLock(this);
                this.clearWaitList();
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    private void clearWaitList() {
        this.waitList.clear();
        this.waitList.put(this.myId);
    }

    private void markAsWaitingFor(ForsetiLockManager.Lock lock, Locks.ResourceType type, long resourceId) {
        this.clearWaitList();
        lock.copyHolderWaitListsInto(this.waitList);
        if (lock.anyHolderIsWaitingFor(this.myId) && lock.holderWaitListSize() >= this.waitListSize()) {
            this.waitList.clear();
            throw new DeadlockDetectedException(this + " can't acquire " + lock + " on " + type + "(" + resourceId + "), because holders of that lock " + "are waiting for " + this + ".\n Wait list:" + lock.describeWaitList());
        }
    }

    public String describeWaitList() {
        StringBuilder sb = new StringBuilder(String.format("%nClient[%d] waits for [", this.id()));
        PrimitiveIntIterator iter = this.waitList.iterator();
        int i = 0;
        while (iter.hasNext()) {
            sb.append(i > 0 ? "," : "").append(iter.next());
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public int id() {
        return this.myId;
    }

    private class ReleaseExclusiveLocksAndClearSharedVisitor
    implements PrimitiveLongVisitor<RuntimeException> {
        private PrimitiveLongIntMap sharedLockCounts;
        private ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap;

        private ReleaseExclusiveLocksAndClearSharedVisitor() {
        }

        private PrimitiveLongVisitor<RuntimeException> initialize(PrimitiveLongIntMap sharedLockCounts, ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap) {
            this.sharedLockCounts = sharedLockCounts;
            this.lockMap = lockMap;
            return this;
        }

        public boolean visited(long resourceId) {
            ForsetiClient.this.releaseGlobalLock(this.lockMap, resourceId);
            if (this.sharedLockCounts != null) {
                this.sharedLockCounts.remove(resourceId);
            }
            return false;
        }
    }

    private class ReleaseExclusiveLocksVisitor
    implements PrimitiveLongVisitor<RuntimeException> {
        private PrimitiveLongIntMap sharedLockCounts;
        private ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap;

        private ReleaseExclusiveLocksVisitor() {
        }

        private PrimitiveLongVisitor<RuntimeException> initialize(PrimitiveLongIntMap sharedLockCounts, ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap) {
            this.sharedLockCounts = sharedLockCounts;
            this.lockMap = lockMap;
            return this;
        }

        public boolean visited(long resourceId) {
            if (this.sharedLockCounts.containsKey(resourceId)) {
                this.lockMap.put(resourceId, new SharedLock(ForsetiClient.this));
            } else {
                ForsetiClient.this.releaseGlobalLock(this.lockMap, resourceId);
            }
            return false;
        }
    }

    private class ReleaseSharedDontCheckExclusiveVisitor
    implements PrimitiveLongVisitor<RuntimeException> {
        private ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap;

        private ReleaseSharedDontCheckExclusiveVisitor() {
        }

        private PrimitiveLongVisitor<RuntimeException> initialize(ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap) {
            this.lockMap = lockMap;
            return this;
        }

        public boolean visited(long resourceId) {
            ForsetiClient.this.releaseGlobalLock(this.lockMap, resourceId);
            return false;
        }
    }

    private class ReleaseSharedLocksVisitor
    implements PrimitiveLongVisitor<RuntimeException> {
        private PrimitiveLongIntMap exclusiveLockCounts;
        private ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap;

        private ReleaseSharedLocksVisitor() {
        }

        private PrimitiveLongVisitor<RuntimeException> initialize(PrimitiveLongIntMap exclusiveLockCounts, ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap) {
            this.exclusiveLockCounts = exclusiveLockCounts;
            this.lockMap = lockMap;
            return this;
        }

        public boolean visited(long resourceId) {
            if (!this.exclusiveLockCounts.containsKey(resourceId)) {
                ForsetiClient.this.releaseGlobalLock(this.lockMap, resourceId);
            }
            return false;
        }
    }
}

