/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.transaction;

import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.core.LastTxIdGetter;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.transaction.state.NeoStoreSupplier;

public class OnDiskLastTxIdGetter
implements LastTxIdGetter {
    private final GraphDatabaseAPI graphdb;

    public OnDiskLastTxIdGetter(GraphDatabaseAPI graphdb) {
        this.graphdb = graphdb;
    }

    public long getLastTxId() {
        NeoStore neoStore = this.getNeoStore();
        return neoStore.getLastCommittedTransactionId();
    }

    private NeoStore getNeoStore() {
        NeoStoreSupplier neoStoreSupplier = (NeoStoreSupplier)this.graphdb.getDependencyResolver().resolveDependency(NeoStoreSupplier.class);
        return (NeoStore)neoStoreSupplier.get();
    }
}

