/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.com.ComException;
import org.neo4j.com.ResourceReleaser;
import org.neo4j.com.Response;
import org.neo4j.com.TransactionStream;
import org.neo4j.com.TransactionStreamResponse;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.com.master.Slave;
import org.neo4j.kernel.ha.com.master.SlavePriorities;
import org.neo4j.kernel.ha.com.master.SlavePriority;
import org.neo4j.kernel.ha.com.master.Slaves;
import org.neo4j.kernel.ha.transaction.CommitPusher;
import org.neo4j.kernel.ha.transaction.TransactionPropagator;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.Neo4jJobScheduler;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.test.CleanupRule;

public class TestMasterCommittingAtSlave {
    private static final int MasterServerId = 0;
    private Iterable<Slave> slaves;
    private AssertableLogProvider logProvider = new AssertableLogProvider();
    AssertableLogProvider.LogMatcher communicationLogMessage = new AssertableLogProvider.LogMatcher(Matchers.any(String.class), Is.is((Object)AssertableLogProvider.Level.ERROR), Matchers.containsString((String)"communication"), Matchers.any(Object[].class), Matchers.any(Throwable.class));
    private static final FileSystemAbstraction FS = new DefaultFileSystemAbstraction();
    @Rule
    public final CleanupRule cleanup = new CleanupRule();

    @Test
    public void commitSuccessfullyToTheFirstOne() throws Exception {
        TransactionPropagator propagator = this.newPropagator(3, 1, SlavePriorities.givenOrder(), new boolean[0]);
        propagator.committed(2L, 0);
        this.assertCalls((FakeSlave)this.slaves.iterator().next(), 2L);
        this.logProvider.assertNone(this.communicationLogMessage);
    }

    @Test
    public void commitACoupleOfTransactionsSuccessfully() throws Exception {
        TransactionPropagator propagator = this.newPropagator(3, 1, SlavePriorities.givenOrder(), new boolean[0]);
        propagator.committed(2L, 0);
        propagator.committed(3L, 0);
        propagator.committed(4L, 0);
        this.assertCalls((FakeSlave)this.slaves.iterator().next(), 2L, 3L, 4L);
        this.logProvider.assertNone(this.communicationLogMessage);
    }

    @Test
    public void commitFailureAtFirstOneShouldMoveOnToNext() throws Exception {
        TransactionPropagator propagator = this.newPropagator(3, 1, SlavePriorities.givenOrder(), true);
        propagator.committed(2L, 0);
        Iterator<Slave> slaveIt = this.slaves.iterator();
        this.assertCalls((FakeSlave)slaveIt.next(), new long[0]);
        this.assertCalls((FakeSlave)slaveIt.next(), 2L);
        this.logProvider.assertNone(this.communicationLogMessage);
    }

    @Test
    public void commitSuccessfullyAtThreeSlaves() throws Exception {
        TransactionPropagator propagator = this.newPropagator(5, 3, SlavePriorities.givenOrder(), new boolean[0]);
        propagator.committed(2L, 0);
        propagator.committed(3L, 1);
        propagator.committed(4L, 2);
        Iterator<Slave> slaveIt = this.slaves.iterator();
        this.assertCalls((FakeSlave)slaveIt.next(), 2L, 4L);
        this.assertCalls((FakeSlave)slaveIt.next(), 2L, 3L);
        this.assertCalls((FakeSlave)slaveIt.next(), 2L, 3L, 4L);
        this.assertCalls((FakeSlave)slaveIt.next(), new long[0]);
        this.assertCalls((FakeSlave)slaveIt.next(), new long[0]);
        this.logProvider.assertNone(this.communicationLogMessage);
    }

    @Test
    public void commitSuccessfullyOnSomeOfThreeSlaves() throws Exception {
        TransactionPropagator propagator = this.newPropagator(5, 3, SlavePriorities.givenOrder(), false, true, true);
        propagator.committed(2L, 0);
        Iterator<Slave> slaveIt = this.slaves.iterator();
        this.assertCalls((FakeSlave)slaveIt.next(), 2L);
        slaveIt.next();
        slaveIt.next();
        this.assertCalls((FakeSlave)slaveIt.next(), 2L);
        this.assertCalls((FakeSlave)slaveIt.next(), 2L);
        this.logProvider.assertNone(this.communicationLogMessage);
    }

    @Test
    public void roundRobinSingleSlave() throws Exception {
        TransactionPropagator propagator = this.newPropagator(3, 1, SlavePriorities.roundRobin(), new boolean[0]);
        for (long tx = 2L; tx <= 6L; ++tx) {
            propagator.committed(tx, 0);
        }
        Iterator<Slave> slaveIt = this.slaves.iterator();
        this.assertCalls((FakeSlave)slaveIt.next(), 2L, 5L);
        this.assertCalls((FakeSlave)slaveIt.next(), 3L, 6L);
        this.assertCalls((FakeSlave)slaveIt.next(), 4L);
        this.logProvider.assertNone(this.communicationLogMessage);
    }

    @Test
    public void roundRobinSomeFailing() throws Exception {
        TransactionPropagator propagator = this.newPropagator(4, 2, SlavePriorities.roundRobin(), false, true);
        for (long tx = 2L; tx <= 6L; ++tx) {
            propagator.committed(tx, 0);
        }
        Iterator<Slave> slaveIt = this.slaves.iterator();
        this.assertCalls((FakeSlave)slaveIt.next(), 2L, 5L, 6L);
        slaveIt.next();
        this.assertCalls((FakeSlave)slaveIt.next(), 2L, 3L, 4L, 6L);
        this.assertCalls((FakeSlave)slaveIt.next(), 3L, 4L, 5L);
        this.logProvider.assertNone(this.communicationLogMessage);
    }

    @Test
    public void notEnoughSlavesSuccessful() throws Exception {
        TransactionPropagator propagator = this.newPropagator(3, 2, SlavePriorities.givenOrder(), true, true);
        propagator.committed(2L, 0);
        Iterator<Slave> slaveIt = this.slaves.iterator();
        slaveIt.next();
        slaveIt.next();
        this.assertCalls((FakeSlave)slaveIt.next(), 2L);
        this.logProvider.assertNone(this.communicationLogMessage);
    }

    @Test
    public void testFixedPriorityStrategy() {
        int[] serverIds = new int[]{55, 101, 66};
        SlavePriority fixed = SlavePriorities.fixed();
        ArrayList<FakeSlave> slaves = new ArrayList<FakeSlave>(3);
        slaves.add(new FakeSlave(false, serverIds[0]));
        slaves.add(new FakeSlave(false, serverIds[1]));
        slaves.add(new FakeSlave(false, serverIds[2]));
        Iterator sortedSlaves = fixed.prioritize(slaves).iterator();
        Assert.assertEquals((long)serverIds[1], (long)((Slave)sortedSlaves.next()).getServerId());
        Assert.assertEquals((long)serverIds[2], (long)((Slave)sortedSlaves.next()).getServerId());
        Assert.assertEquals((long)serverIds[0], (long)((Slave)sortedSlaves.next()).getServerId());
        Assert.assertTrue((!sortedSlaves.hasNext() ? 1 : 0) != 0);
    }

    private void assertCalls(FakeSlave slave, long ... txs) {
        for (long tx : txs) {
            Long slaveTx = slave.popCalledTx();
            Assert.assertNotNull((Object)slaveTx);
            Assert.assertEquals((Object)tx, (Object)slaveTx);
        }
        Assert.assertFalse((boolean)slave.moreTxs());
    }

    private TransactionPropagator newPropagator(int slaveCount, int replication, SlavePriority slavePriority, boolean ... failingSlaves) throws Exception {
        this.slaves = this.instantiateSlaves(slaveCount, failingSlaves);
        Config config = new Config(MapUtil.stringMap((String[])new String[]{HaSettings.tx_push_factor.name(), "" + replication, ClusterSettings.server_id.name(), "0"}));
        Neo4jJobScheduler scheduler = (Neo4jJobScheduler)this.cleanup.add((Object)new Neo4jJobScheduler());
        TransactionPropagator result = new TransactionPropagator(TransactionPropagator.from((Config)config, (SlavePriority)slavePriority), (Log)NullLog.getInstance(), new Slaves(){

            public Iterable<Slave> getSlaves() {
                return TestMasterCommittingAtSlave.this.slaves;
            }
        }, new CommitPusher((JobScheduler)scheduler));
        try {
            scheduler.init();
            scheduler.start();
            result.init();
            result.start();
        }
        catch (Throwable e) {
            throw Exceptions.launderedException((Throwable)e);
        }
        return result;
    }

    private Iterable<Slave> instantiateSlaves(int count, boolean[] failingSlaves) {
        ArrayList<Slave> slaves = new ArrayList<Slave>();
        for (int i = 0; i < count; ++i) {
            slaves.add(new FakeSlave(i < failingSlaves.length && failingSlaves[i], i + 0 + 1));
        }
        return slaves;
    }

    private static class FakeSlave
    implements Slave {
        private volatile Queue<Long> calledWithTxId = new LinkedList<Long>();
        private final boolean failing;
        private final int serverId;

        FakeSlave(boolean failing, int serverId) {
            this.failing = failing;
            this.serverId = serverId;
        }

        public Response<Void> pullUpdates(long txId) {
            if (this.failing) {
                throw new ComException("Told to fail");
            }
            this.calledWithTxId.add(txId);
            return new TransactionStreamResponse(null, new StoreId(), TransactionStream.EMPTY, ResourceReleaser.NO_OP);
        }

        Long popCalledTx() {
            return this.calledWithTxId.poll();
        }

        boolean moreTxs() {
            return !this.calledWithTxId.isEmpty();
        }

        public int getServerId() {
            return this.serverId;
        }

        public String toString() {
            return "FakeSlave[" + this.serverId + "]";
        }
    }
}

