/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.net.URI;
import java.util.HashSet;
import java.util.LinkedList;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.member.ClusterMemberEvents;
import org.neo4j.cluster.member.ClusterMemberListener;
import org.neo4j.cluster.protocol.election.Election;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberChangeEvent;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberContext;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberListener;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberStateMachine;
import org.neo4j.kernel.ha.cluster.SimpleHighAvailabilityMemberContext;
import org.neo4j.kernel.ha.cluster.member.ClusterMember;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class HighAvailabilityMemberStateMachineTest {
    @Test
    public void shouldStartFromPending() throws Exception {
        HighAvailabilityMemberContext context = (HighAvailabilityMemberContext)Mockito.mock(HighAvailabilityMemberContext.class);
        AvailabilityGuard guard = (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class);
        ClusterMembers members = (ClusterMembers)Mockito.mock(ClusterMembers.class);
        ClusterMemberEvents events = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        Election election = (Election)Mockito.mock(Election.class);
        HighAvailabilityMemberStateMachine toTest = new HighAvailabilityMemberStateMachine(context, guard, members, events, election, (LogProvider)NullLogProvider.getInstance());
        Assert.assertThat((Object)toTest.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.PENDING));
    }

    @Test
    public void shouldMoveToToMasterFromPendingOnMasterElectedForItself() throws Throwable {
        InstanceId me = new InstanceId(1);
        SimpleHighAvailabilityMemberContext context = new SimpleHighAvailabilityMemberContext(me, false);
        AvailabilityGuard guard = (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class);
        ClusterMembers members = (ClusterMembers)Mockito.mock(ClusterMembers.class);
        ClusterMemberEvents events = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        final HashSet listener = new HashSet();
        ((ClusterMemberEvents)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                listener.add((ClusterMemberListener)invocation.getArguments()[0]);
                return null;
            }
        }).when((Object)events)).addClusterMemberListener((ClusterMemberListener)Matchers.any());
        Election election = (Election)Mockito.mock(Election.class);
        HighAvailabilityMemberStateMachine toTest = new HighAvailabilityMemberStateMachine((HighAvailabilityMemberContext)context, guard, members, events, election, (LogProvider)NullLogProvider.getInstance());
        toTest.init();
        ClusterMemberListener theListener = (ClusterMemberListener)listener.iterator().next();
        theListener.coordinatorIsElected(me);
        Assert.assertThat((Object)listener.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)toTest.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.TO_MASTER));
    }

    @Test
    public void shouldRemainToPendingOnMasterElectedForSomeoneElse() throws Throwable {
        InstanceId me = new InstanceId(1);
        SimpleHighAvailabilityMemberContext context = new SimpleHighAvailabilityMemberContext(me, false);
        AvailabilityGuard guard = (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class);
        ClusterMembers members = (ClusterMembers)Mockito.mock(ClusterMembers.class);
        ClusterMemberEvents events = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        final HashSet listener = new HashSet();
        ((ClusterMemberEvents)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                listener.add((ClusterMemberListener)invocation.getArguments()[0]);
                return null;
            }
        }).when((Object)events)).addClusterMemberListener((ClusterMemberListener)Matchers.any());
        Election election = (Election)Mockito.mock(Election.class);
        HighAvailabilityMemberStateMachine toTest = new HighAvailabilityMemberStateMachine((HighAvailabilityMemberContext)context, guard, members, events, election, (LogProvider)NullLogProvider.getInstance());
        toTest.init();
        ClusterMemberListener theListener = (ClusterMemberListener)listener.iterator().next();
        theListener.coordinatorIsElected(new InstanceId(2));
        Assert.assertThat((Object)listener.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)toTest.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.PENDING));
    }

    @Test
    public void shouldSwitchToToSlaveOnMasterAvailableForSomeoneElse() throws Throwable {
        InstanceId me = new InstanceId(1);
        SimpleHighAvailabilityMemberContext context = new SimpleHighAvailabilityMemberContext(me, false);
        AvailabilityGuard guard = (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class);
        ClusterMembers members = (ClusterMembers)Mockito.mock(ClusterMembers.class);
        ClusterMemberEvents events = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        final HashSet listener = new HashSet();
        ((ClusterMemberEvents)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                listener.add((ClusterMemberListener)invocation.getArguments()[0]);
                return null;
            }
        }).when((Object)events)).addClusterMemberListener((ClusterMemberListener)Matchers.any());
        Election election = (Election)Mockito.mock(Election.class);
        HighAvailabilityMemberStateMachine toTest = new HighAvailabilityMemberStateMachine((HighAvailabilityMemberContext)context, guard, members, events, election, (LogProvider)NullLogProvider.getInstance());
        toTest.init();
        ClusterMemberListener theListener = (ClusterMemberListener)listener.iterator().next();
        HAStateChangeListener probe = new HAStateChangeListener();
        toTest.addHighAvailabilityMemberListener((HighAvailabilityMemberListener)probe);
        theListener.memberIsAvailable("master", new InstanceId(2), URI.create("ha://whatever"), StoreId.DEFAULT);
        Assert.assertThat((Object)listener.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)toTest.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.TO_SLAVE));
        Assert.assertThat((Object)probe.masterIsAvailable, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void whenInMasterStateLosingQuorumShouldPutInPending() throws Throwable {
        InstanceId me = new InstanceId(1);
        InstanceId other = new InstanceId(2);
        SimpleHighAvailabilityMemberContext context = new SimpleHighAvailabilityMemberContext(me, false);
        AvailabilityGuard guard = (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class);
        ClusterMembers members = (ClusterMembers)Mockito.mock(ClusterMembers.class);
        ClusterMemberEvents events = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        LinkedList<ClusterMember> membersList = new LinkedList<ClusterMember>();
        ClusterMember otherMemberMock = (ClusterMember)Mockito.mock(ClusterMember.class);
        Mockito.when((Object)otherMemberMock.getInstanceId()).thenReturn((Object)other);
        Mockito.when((Object)otherMemberMock.isAlive()).thenReturn((Object)false);
        membersList.add(otherMemberMock);
        membersList.add(new ClusterMember(me));
        Mockito.when((Object)members.getMembers()).thenReturn(membersList);
        final HashSet listener = new HashSet();
        ((ClusterMemberEvents)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                listener.add((ClusterMemberListener)invocation.getArguments()[0]);
                return null;
            }
        }).when((Object)events)).addClusterMemberListener((ClusterMemberListener)Matchers.any());
        Election election = (Election)Mockito.mock(Election.class);
        HighAvailabilityMemberStateMachine toTest = new HighAvailabilityMemberStateMachine((HighAvailabilityMemberContext)context, guard, members, events, election, (LogProvider)NullLogProvider.getInstance());
        toTest.init();
        ClusterMemberListener theListener = (ClusterMemberListener)listener.iterator().next();
        HAStateChangeListener probe = new HAStateChangeListener();
        toTest.addHighAvailabilityMemberListener((HighAvailabilityMemberListener)probe);
        theListener.coordinatorIsElected(me);
        theListener.memberIsAvailable("master", me, URI.create("ha://whatever"), StoreId.DEFAULT);
        Assert.assertThat((Object)toTest.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.MASTER));
        theListener.memberIsFailed(new InstanceId(2));
        Assert.assertThat((Object)listener.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)toTest.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.PENDING));
        Assert.assertThat((Object)probe.instanceStops, (Matcher)CoreMatchers.is((Object)true));
        ((AvailabilityGuard)Mockito.verify((Object)guard, (VerificationMode)Mockito.times((int)2))).deny((AvailabilityGuard.AvailabilityRequirement)Mockito.any(AvailabilityGuard.AvailabilityRequirement.class));
    }

    @Test
    public void whenInSlaveStateLosingQuorumShouldPutInPending() throws Throwable {
        InstanceId me = new InstanceId(1);
        InstanceId other = new InstanceId(2);
        SimpleHighAvailabilityMemberContext context = new SimpleHighAvailabilityMemberContext(me, false);
        AvailabilityGuard guard = (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class);
        ClusterMembers members = (ClusterMembers)Mockito.mock(ClusterMembers.class);
        ClusterMemberEvents events = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        LinkedList<ClusterMember> membersList = new LinkedList<ClusterMember>();
        ClusterMember otherMemberMock = (ClusterMember)Mockito.mock(ClusterMember.class);
        Mockito.when((Object)otherMemberMock.getInstanceId()).thenReturn((Object)other);
        Mockito.when((Object)otherMemberMock.isAlive()).thenReturn((Object)false);
        membersList.add(otherMemberMock);
        membersList.add(new ClusterMember(me));
        Mockito.when((Object)members.getMembers()).thenReturn(membersList);
        final HashSet listener = new HashSet();
        ((ClusterMemberEvents)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                listener.add((ClusterMemberListener)invocation.getArguments()[0]);
                return null;
            }
        }).when((Object)events)).addClusterMemberListener((ClusterMemberListener)Matchers.any());
        Election election = (Election)Mockito.mock(Election.class);
        HighAvailabilityMemberStateMachine toTest = new HighAvailabilityMemberStateMachine((HighAvailabilityMemberContext)context, guard, members, events, election, (LogProvider)NullLogProvider.getInstance());
        toTest.init();
        ClusterMemberListener theListener = (ClusterMemberListener)listener.iterator().next();
        HAStateChangeListener probe = new HAStateChangeListener();
        toTest.addHighAvailabilityMemberListener((HighAvailabilityMemberListener)probe);
        theListener.memberIsAvailable("master", other, URI.create("ha://whatever"), StoreId.DEFAULT);
        theListener.memberIsAvailable("slave", me, URI.create("ha://whatever2"), StoreId.DEFAULT);
        Assert.assertThat((Object)toTest.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.SLAVE));
        theListener.memberIsFailed(new InstanceId(2));
        Assert.assertThat((Object)listener.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)toTest.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.PENDING));
        Assert.assertThat((Object)probe.instanceStops, (Matcher)CoreMatchers.is((Object)true));
        ((AvailabilityGuard)Mockito.verify((Object)guard, (VerificationMode)Mockito.times((int)2))).deny((AvailabilityGuard.AvailabilityRequirement)Mockito.any(AvailabilityGuard.AvailabilityRequirement.class));
    }

    @Test
    public void whenInToMasterStateLosingQuorumShouldPutInPending() throws Throwable {
        InstanceId me = new InstanceId(1);
        InstanceId other = new InstanceId(2);
        SimpleHighAvailabilityMemberContext context = new SimpleHighAvailabilityMemberContext(me, false);
        AvailabilityGuard guard = (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class);
        ClusterMembers members = (ClusterMembers)Mockito.mock(ClusterMembers.class);
        ClusterMemberEvents events = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        LinkedList<ClusterMember> membersList = new LinkedList<ClusterMember>();
        ClusterMember otherMemberMock = (ClusterMember)Mockito.mock(ClusterMember.class);
        Mockito.when((Object)otherMemberMock.getInstanceId()).thenReturn((Object)other);
        Mockito.when((Object)otherMemberMock.isAlive()).thenReturn((Object)false);
        membersList.add(otherMemberMock);
        membersList.add(new ClusterMember(me));
        Mockito.when((Object)members.getMembers()).thenReturn(membersList);
        final HashSet listener = new HashSet();
        ((ClusterMemberEvents)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                listener.add((ClusterMemberListener)invocation.getArguments()[0]);
                return null;
            }
        }).when((Object)events)).addClusterMemberListener((ClusterMemberListener)Matchers.any());
        Election election = (Election)Mockito.mock(Election.class);
        HighAvailabilityMemberStateMachine toTest = new HighAvailabilityMemberStateMachine((HighAvailabilityMemberContext)context, guard, members, events, election, (LogProvider)NullLogProvider.getInstance());
        toTest.init();
        ClusterMemberListener theListener = (ClusterMemberListener)listener.iterator().next();
        HAStateChangeListener probe = new HAStateChangeListener();
        toTest.addHighAvailabilityMemberListener((HighAvailabilityMemberListener)probe);
        theListener.coordinatorIsElected(me);
        Assert.assertThat((Object)toTest.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.TO_MASTER));
        theListener.memberIsFailed(new InstanceId(2));
        Assert.assertThat((Object)listener.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)toTest.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.PENDING));
        Assert.assertThat((Object)probe.instanceStops, (Matcher)CoreMatchers.is((Object)true));
        ((AvailabilityGuard)Mockito.verify((Object)guard, (VerificationMode)Mockito.times((int)1))).deny((AvailabilityGuard.AvailabilityRequirement)Mockito.any(AvailabilityGuard.AvailabilityRequirement.class));
    }

    @Test
    public void whenInToSlaveStateLosingQuorumShouldPutInPending() throws Throwable {
        InstanceId me = new InstanceId(1);
        InstanceId other = new InstanceId(2);
        SimpleHighAvailabilityMemberContext context = new SimpleHighAvailabilityMemberContext(me, false);
        AvailabilityGuard guard = (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class);
        ClusterMembers members = (ClusterMembers)Mockito.mock(ClusterMembers.class);
        ClusterMemberEvents events = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        LinkedList<ClusterMember> membersList = new LinkedList<ClusterMember>();
        ClusterMember otherMemberMock = (ClusterMember)Mockito.mock(ClusterMember.class);
        Mockito.when((Object)otherMemberMock.getInstanceId()).thenReturn((Object)other);
        Mockito.when((Object)otherMemberMock.isAlive()).thenReturn((Object)false);
        membersList.add(otherMemberMock);
        membersList.add(new ClusterMember(me));
        Mockito.when((Object)members.getMembers()).thenReturn(membersList);
        final HashSet listener = new HashSet();
        ((ClusterMemberEvents)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                listener.add((ClusterMemberListener)invocation.getArguments()[0]);
                return null;
            }
        }).when((Object)events)).addClusterMemberListener((ClusterMemberListener)Matchers.any());
        Election election = (Election)Mockito.mock(Election.class);
        HighAvailabilityMemberStateMachine toTest = new HighAvailabilityMemberStateMachine((HighAvailabilityMemberContext)context, guard, members, events, election, (LogProvider)NullLogProvider.getInstance());
        toTest.init();
        ClusterMemberListener theListener = (ClusterMemberListener)listener.iterator().next();
        HAStateChangeListener probe = new HAStateChangeListener();
        toTest.addHighAvailabilityMemberListener((HighAvailabilityMemberListener)probe);
        theListener.memberIsAvailable("master", other, URI.create("ha://whatever"), StoreId.DEFAULT);
        Assert.assertThat((Object)toTest.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.TO_SLAVE));
        theListener.memberIsFailed(new InstanceId(2));
        Assert.assertThat((Object)listener.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)toTest.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.PENDING));
        Assert.assertThat((Object)probe.instanceStops, (Matcher)CoreMatchers.is((Object)true));
        ((AvailabilityGuard)Mockito.verify((Object)guard, (VerificationMode)Mockito.times((int)1))).deny((AvailabilityGuard.AvailabilityRequirement)Mockito.any(AvailabilityGuard.AvailabilityRequirement.class));
    }

    @Test
    public void whenSlaveOnlyIsElectedStayInPending() throws Throwable {
        InstanceId me = new InstanceId(1);
        SimpleHighAvailabilityMemberContext context = new SimpleHighAvailabilityMemberContext(me, true);
        AvailabilityGuard guard = (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class);
        ClusterMembers members = (ClusterMembers)Mockito.mock(ClusterMembers.class);
        ClusterMemberEvents events = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        final HashSet listener = new HashSet();
        ((ClusterMemberEvents)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                listener.add((ClusterMemberListener)invocation.getArguments()[0]);
                return null;
            }
        }).when((Object)events)).addClusterMemberListener((ClusterMemberListener)Matchers.any());
        Election election = (Election)Mockito.mock(Election.class);
        HighAvailabilityMemberStateMachine toTest = new HighAvailabilityMemberStateMachine((HighAvailabilityMemberContext)context, guard, members, events, election, (LogProvider)NullLogProvider.getInstance());
        toTest.init();
        ClusterMemberListener theListener = (ClusterMemberListener)listener.iterator().next();
        theListener.coordinatorIsElected(me);
        Assert.assertThat((Object)toTest.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.PENDING));
    }

    private static final class HAStateChangeListener
    implements HighAvailabilityMemberListener {
        boolean masterIsElected = false;
        boolean masterIsAvailable = false;
        boolean slaveIsAvailable = false;
        boolean instanceStops = false;
        HighAvailabilityMemberChangeEvent lastEvent = null;

        private HAStateChangeListener() {
        }

        public void masterIsElected(HighAvailabilityMemberChangeEvent event) {
            this.masterIsElected = true;
            this.masterIsAvailable = false;
            this.slaveIsAvailable = false;
            this.instanceStops = false;
            this.lastEvent = event;
        }

        public void masterIsAvailable(HighAvailabilityMemberChangeEvent event) {
            this.masterIsElected = false;
            this.masterIsAvailable = true;
            this.slaveIsAvailable = false;
            this.instanceStops = false;
            this.lastEvent = event;
        }

        public void slaveIsAvailable(HighAvailabilityMemberChangeEvent event) {
            this.masterIsElected = false;
            this.masterIsAvailable = false;
            this.slaveIsAvailable = true;
            this.instanceStops = false;
            this.lastEvent = event;
        }

        public void instanceStops(HighAvailabilityMemberChangeEvent event) {
            this.masterIsElected = false;
            this.masterIsAvailable = false;
            this.slaveIsAvailable = false;
            this.instanceStops = true;
            this.lastEvent = event;
        }
    }
}

