/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.ha;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.junit.Assert;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.ExecutorLifecycleAdapter;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.client.Clusters;
import org.neo4j.cluster.client.ClustersXMLSerializer;
import org.neo4j.cluster.com.NetworkReceiver;
import org.neo4j.cluster.com.NetworkSender;
import org.neo4j.cluster.member.ClusterMemberEvents;
import org.neo4j.cluster.member.ClusterMemberListener;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectInputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectOutputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectStreamFactory;
import org.neo4j.cluster.protocol.cluster.Cluster;
import org.neo4j.cluster.protocol.election.ElectionCredentialsProvider;
import org.neo4j.cluster.protocol.election.NotElectableElectionCredentialsProvider;
import org.neo4j.cluster.protocol.heartbeat.Heartbeat;
import org.neo4j.function.Function;
import org.neo4j.function.Predicate;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.graphdb.factory.TestHighlyAvailableGraphDatabaseFactory;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.UpdatePullerClient;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.ha.cluster.member.ClusterMember;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.kernel.ha.com.master.Slaves;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.w3c.dom.Document;

public class ClusterManager
extends LifecycleAdapter {
    private final File root;
    private final Map<String, String> commonConfig;
    private final Map<Integer, Map<String, String>> instanceConfig;
    private final Map<String, ManagedCluster> clusterMap = new HashMap<String, ManagedCluster>();
    private final Provider clustersProvider;
    private final HighlyAvailableGraphDatabaseFactory dbFactory;
    private final StoreDirInitializer storeDirInitializer;
    LifeSupport life;

    public ClusterManager(Provider clustersProvider, File root, Map<String, String> commonConfig, Map<Integer, Map<String, String>> instanceConfig, HighlyAvailableGraphDatabaseFactory dbFactory) {
        this.clustersProvider = clustersProvider;
        this.root = root;
        this.commonConfig = commonConfig;
        this.instanceConfig = instanceConfig;
        this.dbFactory = dbFactory;
        this.storeDirInitializer = null;
    }

    public ClusterManager(Builder builder) {
        this.clustersProvider = builder.provider;
        this.root = builder.root;
        this.commonConfig = builder.commonConfig;
        this.instanceConfig = builder.instanceConfig;
        this.dbFactory = builder.factory;
        this.storeDirInitializer = builder.initializer;
    }

    public ClusterManager(Provider clustersProvider, File root, Map<String, String> commonConfig, Map<Integer, Map<String, String>> instanceConfig) {
        this(clustersProvider, root, commonConfig, instanceConfig, new TestHighlyAvailableGraphDatabaseFactory());
    }

    public ClusterManager(Provider clustersProvider, File root, Map<String, String> commonConfig) {
        this(clustersProvider, root, commonConfig, Collections.emptyMap(), new TestHighlyAvailableGraphDatabaseFactory());
    }

    public static Provider fromXml(final URI clustersXml) {
        return new Provider(){

            @Override
            public Clusters clusters() throws Exception {
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document clustersXmlDoc = documentBuilder.parse(clustersXml.toURL().openStream());
                return new ClustersXMLSerializer(documentBuilder).read(clustersXmlDoc);
            }
        };
    }

    public static Provider clusterOfSize(int memberCount) {
        Clusters.Cluster cluster = new Clusters.Cluster("neo4j.ha");
        for (int i = 0; i < memberCount; ++i) {
            cluster.getMembers().add(new Clusters.Member(5001 + i, true));
        }
        Clusters clusters = new Clusters();
        clusters.getClusters().add(cluster);
        return ClusterManager.provided(clusters);
    }

    public static Provider clusterWithAdditionalClients(int haMemberCount, int additionalClientCount) {
        Clusters.Cluster cluster = new Clusters.Cluster("neo4j.ha");
        int counter = 0;
        int i = 0;
        while (i < haMemberCount) {
            cluster.getMembers().add(new Clusters.Member(5001 + counter, true));
            ++i;
            ++counter;
        }
        i = 0;
        while (i < additionalClientCount) {
            cluster.getMembers().add(new Clusters.Member(5001 + counter, false));
            ++i;
            ++counter;
        }
        Clusters clusters = new Clusters();
        clusters.getClusters().add(cluster);
        return ClusterManager.provided(clusters);
    }

    public static Provider clusterWithAdditionalArbiters(int haMemberCount, int arbiterCount) {
        Clusters.Cluster cluster = new Clusters.Cluster("neo4j.ha");
        int counter = 0;
        int i = 0;
        while (i < arbiterCount) {
            cluster.getMembers().add(new Clusters.Member(5001 + counter, false));
            ++i;
            ++counter;
        }
        i = 0;
        while (i < haMemberCount) {
            cluster.getMembers().add(new Clusters.Member(5001 + counter, true));
            ++i;
            ++counter;
        }
        Clusters clusters = new Clusters();
        clusters.getClusters().add(cluster);
        return ClusterManager.provided(clusters);
    }

    public static Provider provided(final Clusters clusters) {
        return new Provider(){

            @Override
            public Clusters clusters() throws Throwable {
                return clusters;
            }
        };
    }

    public static Predicate<ManagedCluster> masterSeesSlavesAsAvailable(final int count) {
        return new Predicate<ManagedCluster>(){

            public boolean test(ManagedCluster cluster) {
                return Iterables.count((Iterable)((Slaves)cluster.getMaster().getDependencyResolver().resolveDependency(Slaves.class)).getSlaves()) >= (long)count;
            }

            public String toString() {
                return "Master should see " + count + " slaves as available";
            }
        };
    }

    public static Predicate<ManagedCluster> masterSeesAllSlavesAsAvailable() {
        return new Predicate<ManagedCluster>(){

            public boolean test(ManagedCluster cluster) {
                return Iterables.count((Iterable)((Slaves)cluster.getMaster().getDependencyResolver().resolveDependency(Slaves.class)).getSlaves()) >= (long)(cluster.size() - 1);
            }

            public String toString() {
                return "Master should see all slaves as available";
            }
        };
    }

    public static Predicate<ManagedCluster> masterAvailable(HighlyAvailableGraphDatabase ... except) {
        final HashSet<HighlyAvailableGraphDatabase> exceptSet = new HashSet<HighlyAvailableGraphDatabase>(Arrays.asList(except));
        return new Predicate<ManagedCluster>(){

            public boolean test(ManagedCluster cluster) {
                for (HighlyAvailableGraphDatabase graphDatabaseService : cluster.getAllMembers()) {
                    if (exceptSet.contains(graphDatabaseService) || !graphDatabaseService.isAvailable(0L) || !graphDatabaseService.isMaster()) continue;
                    return true;
                }
                return false;
            }

            public String toString() {
                return "There's an available master";
            }
        };
    }

    public static Predicate<ManagedCluster> masterSeesMembers(final int count) {
        return new Predicate<ManagedCluster>(){

            public boolean test(ManagedCluster cluster) {
                ClusterMembers members = (ClusterMembers)cluster.getMaster().getDependencyResolver().resolveDependency(ClusterMembers.class);
                return Iterables.count((Iterable)members.getMembers()) == (long)count;
            }

            public String toString() {
                return "Master should see " + count + " members";
            }
        };
    }

    public static Predicate<ManagedCluster> allSeesAllAsAvailable() {
        return new Predicate<ManagedCluster>(){

            public boolean test(ManagedCluster cluster) {
                if (!ClusterManager.allSeesAllAsJoined().test((Object)cluster)) {
                    return false;
                }
                for (HighlyAvailableGraphDatabase database : cluster.getAllMembers()) {
                    ClusterMembers members = (ClusterMembers)database.getDependencyResolver().resolveDependency(ClusterMembers.class);
                    for (ClusterMember clusterMember : members.getMembers()) {
                        if (!clusterMember.getHARole().equals("UNKNOWN")) continue;
                        return false;
                    }
                }
                for (HighlyAvailableGraphDatabase database : cluster.getAllMembers()) {
                    Log log = ((LogService)database.getDependencyResolver().resolveDependency(LogService.class)).getInternalLog(this.getClass());
                    log.debug(this.toString());
                }
                return true;
            }

            public String toString() {
                return "All instances should see all others as available";
            }
        };
    }

    public static Predicate<ManagedCluster> allSeesAllAsJoined() {
        return new Predicate<ManagedCluster>(){

            public boolean test(ManagedCluster cluster) {
                int nrOfMembers = cluster.size();
                for (HighlyAvailableGraphDatabase database : cluster.getAllMembers()) {
                    ClusterMembers members = (ClusterMembers)database.getDependencyResolver().resolveDependency(ClusterMembers.class);
                    if (Iterables.count((Iterable)members.getMembers()) >= (long)nrOfMembers) continue;
                    return false;
                }
                for (ClusterMembers clusterMembers : cluster.getArbiters()) {
                    if (Iterables.count((Iterable)clusterMembers.getMembers()) >= (long)nrOfMembers) continue;
                    return false;
                }
                return true;
            }

            public String toString() {
                return "All instances should see all others as joined";
            }
        };
    }

    public static Predicate<ManagedCluster> allAvailabilityGuardsReleased() {
        return new Predicate<ManagedCluster>(){

            public boolean test(ManagedCluster item) {
                for (HighlyAvailableGraphDatabaseProxy member : item.members.values()) {
                    try {
                        member.get().beginTx().close();
                    }
                    catch (TransactionFailureException e) {
                        return false;
                    }
                }
                return true;
            }
        };
    }

    public static String stateToString(ManagedCluster cluster) {
        StringBuilder buf = new StringBuilder("\n");
        for (HighlyAvailableGraphDatabase database : cluster.getAllMembers()) {
            ClusterClient client = (ClusterClient)database.getDependencyResolver().resolveDependency(ClusterClient.class);
            buf.append("Instance ").append(client.getServerId()).append(":State ").append(database.getInstanceState()).append(" (").append(client.getClusterServer()).append("):").append("\n");
            ClusterMembers members = (ClusterMembers)database.getDependencyResolver().resolveDependency(ClusterMembers.class);
            for (ClusterMember clusterMember : members.getMembers()) {
                buf.append("  ").append(clusterMember.getInstanceId()).append(":").append(clusterMember.getHARole()).append(" (is alive = ").append(clusterMember.isAlive()).append(")").append("\n");
            }
        }
        return buf.toString();
    }

    public void start() throws Throwable {
        Clusters clusters = this.clustersProvider.clusters();
        this.life = new LifeSupport();
        this.life.start();
        for (int i = 0; i < clusters.getClusters().size(); ++i) {
            Clusters.Cluster cluster = (Clusters.Cluster)clusters.getClusters().get(i);
            ManagedCluster managedCluster = new ManagedCluster(cluster);
            this.clusterMap.put(cluster.getName(), managedCluster);
            this.life.add((Object)managedCluster);
        }
    }

    public void stop() throws Throwable {
        this.life.stop();
    }

    public void shutdown() throws Throwable {
        this.life.shutdown();
    }

    private <T> T instance(Class<T> classToFind, Iterable<?> from) {
        for (Object item : from) {
            if (!classToFind.isAssignableFrom(item.getClass())) continue;
            return (T)item;
        }
        Assert.fail((String)"Couldn't find the network instance to fail. Internal field, so fragile sensitive to changes though");
        return null;
    }

    private Field accessible(Field field) {
        field.setAccessible(true);
        return field;
    }

    public ManagedCluster getCluster(String name) {
        if (!this.clusterMap.containsKey(name)) {
            throw new IllegalArgumentException(name);
        }
        return this.clusterMap.get(name);
    }

    public ManagedCluster getDefaultCluster() {
        return this.getCluster("neo4j.ha");
    }

    protected void config(GraphDatabaseBuilder builder, String clusterName, InstanceId serverId) {
    }

    protected void insertInitialData(GraphDatabaseService db, String name, InstanceId serverId) {
    }

    private class StartDatabaseAgainKit
    implements RepairKit {
        private final InstanceId serverId;
        private final ManagedCluster cluster;

        public StartDatabaseAgainKit(ManagedCluster cluster, InstanceId serverId) {
            this.cluster = cluster;
            this.serverId = serverId;
        }

        @Override
        public HighlyAvailableGraphDatabase repair() throws Throwable {
            this.cluster.startMember(this.serverId);
            return this.cluster.getMemberByServerId(this.serverId);
        }
    }

    private class StartNetworkAgainKit
    implements RepairKit {
        private final HighlyAvailableGraphDatabase db;
        private final Iterable<Lifecycle> stoppedServices;

        StartNetworkAgainKit(HighlyAvailableGraphDatabase db, Iterable<Lifecycle> stoppedServices) {
            this.db = db;
            this.stoppedServices = stoppedServices;
        }

        @Override
        public HighlyAvailableGraphDatabase repair() throws Throwable {
            for (Lifecycle stoppedService : this.stoppedServices) {
                stoppedService.start();
            }
            return this.db;
        }
    }

    public class ManagedCluster
    extends LifecycleAdapter {
        private final Clusters.Cluster spec;
        private final String name;
        private final Map<InstanceId, HighlyAvailableGraphDatabaseProxy> members = new ConcurrentHashMap<InstanceId, HighlyAvailableGraphDatabaseProxy>();
        private final List<ClusterMembers> arbiters = new ArrayList<ClusterMembers>();

        ManagedCluster(Clusters.Cluster spec) throws URISyntaxException, IOException {
            this.spec = spec;
            this.name = spec.getName();
            for (int i = 0; i < spec.getMembers().size(); ++i) {
                this.startMember(new InstanceId(i + 1));
            }
            for (HighlyAvailableGraphDatabaseProxy member : this.members.values()) {
                ClusterManager.this.insertInitialData((GraphDatabaseService)member.get(), this.name, (InstanceId)((Config)member.get().getDependencyResolver().resolveDependency(Config.class)).get(ClusterSettings.server_id));
            }
        }

        public String getInitialHostsConfigString() {
            StringBuilder result = new StringBuilder();
            for (HighlyAvailableGraphDatabase member : this.getAllMembers()) {
                result.append(result.length() > 0 ? "," : "").append(":").append(((ClusterClient)member.getDependencyResolver().resolveDependency(ClusterClient.class)).getClusterServer().getPort());
            }
            return result.toString();
        }

        public void stop() throws Throwable {
            for (HighlyAvailableGraphDatabaseProxy member : this.members.values()) {
                member.get().shutdown();
            }
        }

        public Iterable<HighlyAvailableGraphDatabase> getAllMembers() {
            return Iterables.map((Function)new Function<HighlyAvailableGraphDatabaseProxy, HighlyAvailableGraphDatabase>(){

                public HighlyAvailableGraphDatabase apply(HighlyAvailableGraphDatabaseProxy from) {
                    return from.get();
                }
            }, this.members.values());
        }

        public Iterable<ClusterMembers> getArbiters() {
            return this.arbiters;
        }

        public HighlyAvailableGraphDatabase getMaster() {
            for (HighlyAvailableGraphDatabase graphDatabaseService : this.getAllMembers()) {
                if (!graphDatabaseService.isAvailable(0L) || !graphDatabaseService.isMaster()) continue;
                return graphDatabaseService;
            }
            throw new IllegalStateException("No master found in cluster " + this.name + ClusterManager.stateToString(this));
        }

        public HighlyAvailableGraphDatabase getAnySlave(HighlyAvailableGraphDatabase ... except) {
            HashSet<HighlyAvailableGraphDatabase> exceptSet = new HashSet<HighlyAvailableGraphDatabase>(Arrays.asList(except));
            for (HighlyAvailableGraphDatabase graphDatabaseService : this.getAllMembers()) {
                if (graphDatabaseService.getInstanceState() != HighAvailabilityMemberState.SLAVE || exceptSet.contains(graphDatabaseService)) continue;
                return graphDatabaseService;
            }
            throw new IllegalStateException("No slave found in cluster " + this.name + ClusterManager.stateToString(this));
        }

        public HighlyAvailableGraphDatabase getMemberByServerId(InstanceId serverId) {
            HighlyAvailableGraphDatabase db = this.members.get(serverId).get();
            if (db == null) {
                throw new IllegalStateException("Db " + serverId + " not found at the moment in " + this.name + ClusterManager.stateToString(this));
            }
            return db;
        }

        public RepairKit shutdown(HighlyAvailableGraphDatabase db) {
            this.assertMember(db);
            InstanceId serverId = (InstanceId)((Config)db.getDependencyResolver().resolveDependency(Config.class)).get(ClusterSettings.server_id);
            this.members.remove(serverId);
            ClusterManager.this.life.remove((Object)db);
            db.shutdown();
            return new StartDatabaseAgainKit(this, serverId);
        }

        private void assertMember(HighlyAvailableGraphDatabase db) {
            for (HighlyAvailableGraphDatabaseProxy highlyAvailableGraphDatabaseProxy : this.members.values()) {
                if (!highlyAvailableGraphDatabaseProxy.get().equals(db)) continue;
                return;
            }
            throw new IllegalArgumentException("Db " + db + " not a member of this cluster " + this.name + ClusterManager.stateToString(this));
        }

        public RepairKit fail(HighlyAvailableGraphDatabase db) throws Throwable {
            this.assertMember(db);
            ClusterClient clusterClient = (ClusterClient)db.getDependencyResolver().resolveDependency(ClusterClient.class);
            LifeSupport clusterClientLife = (LifeSupport)ClusterManager.this.accessible(clusterClient.getClass().getDeclaredField("life")).get(clusterClient);
            NetworkReceiver receiver = (NetworkReceiver)ClusterManager.this.instance(NetworkReceiver.class, clusterClientLife.getLifecycleInstances());
            receiver.stop();
            ExecutorLifecycleAdapter statemachineExecutor = (ExecutorLifecycleAdapter)ClusterManager.this.instance(ExecutorLifecycleAdapter.class, clusterClientLife.getLifecycleInstances());
            statemachineExecutor.stop();
            NetworkSender sender = (NetworkSender)ClusterManager.this.instance(NetworkSender.class, clusterClientLife.getLifecycleInstances());
            sender.stop();
            ArrayList<Lifecycle> stoppedServices = new ArrayList<Lifecycle>();
            stoppedServices.add((Lifecycle)sender);
            stoppedServices.add((Lifecycle)statemachineExecutor);
            stoppedServices.add((Lifecycle)receiver);
            return new StartNetworkAgainKit(db, stoppedServices);
        }

        private void startMember(InstanceId serverId) throws URISyntaxException, IOException {
            Clusters.Member member = (Clusters.Member)this.spec.getMembers().get(serverId.toIntegerIndex() - 1);
            StringBuilder initialHosts = new StringBuilder(((Clusters.Member)this.spec.getMembers().get(0)).getHost());
            for (int i = 1; i < this.spec.getMembers().size(); ++i) {
                initialHosts.append(",").append(((Clusters.Member)this.spec.getMembers().get(i)).getHost());
            }
            File parent = new File(ClusterManager.this.root, this.name);
            URI clusterUri = new URI("cluster://" + member.getHost());
            if (member.isFullHaMember()) {
                int clusterPort = clusterUri.getPort();
                int haPort = clusterUri.getPort() + 3000;
                File storeDir = new File(parent, "server" + serverId);
                if (ClusterManager.this.storeDirInitializer != null) {
                    ClusterManager.this.storeDirInitializer.initializeStoreDir(serverId.toIntegerIndex(), storeDir);
                }
                GraphDatabaseBuilder builder = ClusterManager.this.dbFactory.newHighlyAvailableDatabaseBuilder(storeDir.getAbsolutePath());
                builder.setConfig(ClusterSettings.cluster_name, this.name);
                builder.setConfig(ClusterSettings.initial_hosts, initialHosts.toString());
                builder.setConfig(ClusterSettings.server_id, serverId + "");
                builder.setConfig(ClusterSettings.cluster_server, "0.0.0.0:" + clusterPort);
                builder.setConfig(HaSettings.ha_server, ":" + haPort);
                builder.setConfig(OnlineBackupSettings.online_backup_enabled, "false");
                builder.setConfig(ClusterManager.this.commonConfig);
                if (ClusterManager.this.instanceConfig.containsKey(serverId.toIntegerIndex())) {
                    builder.setConfig((Map)ClusterManager.this.instanceConfig.get(serverId.toIntegerIndex()));
                }
                ClusterManager.this.config(builder, this.name, serverId);
                final HighlyAvailableGraphDatabaseProxy graphDatabase = new HighlyAvailableGraphDatabaseProxy(builder);
                this.members.put(serverId, graphDatabase);
                ClusterManager.this.life.add((Object)new LifecycleAdapter(){

                    public void stop() throws Throwable {
                        graphDatabase.get().shutdown();
                    }
                });
            } else {
                Map config = MapUtil.stringMap((String[])new String[]{ClusterSettings.cluster_name.name(), this.name, ClusterSettings.initial_hosts.name(), initialHosts.toString(), ClusterSettings.server_id.name(), serverId + "", ClusterSettings.cluster_server.name(), "0.0.0.0:" + clusterUri.getPort()});
                Config config1 = new Config(config, new Class[]{GraphDatabaseFacadeFactory.Configuration.class, GraphDatabaseSettings.class});
                ObjectStreamFactory objectStreamFactory = new ObjectStreamFactory();
                ClusterClient clusterClient = new ClusterClient(new Monitors(), ClusterClient.adapt((Config)config1), (LogService)NullLogService.getInstance(), (ElectionCredentialsProvider)new NotElectableElectionCredentialsProvider(), (ObjectInputStreamFactory)objectStreamFactory, (ObjectOutputStreamFactory)objectStreamFactory);
                this.arbiters.add(new ClusterMembers((Cluster)clusterClient, (Heartbeat)clusterClient, new ClusterMemberEvents(){

                    public void addClusterMemberListener(ClusterMemberListener listener) {
                    }

                    public void removeClusterMemberListener(ClusterMemberListener listener) {
                    }
                }, clusterClient.getServerId()));
                ClusterManager.this.life.add(new FutureLifecycleAdapter<ClusterClient>(clusterClient));
            }
        }

        public void await(Predicate<ManagedCluster> predicate) {
            this.await(predicate, 60);
        }

        public void await(Predicate<ManagedCluster> predicate, int maxSeconds) {
            long end = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(maxSeconds);
            while (System.currentTimeMillis() < end) {
                if (predicate.test((Object)this)) {
                    return;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {}
            }
            String state = ClusterManager.stateToString(this);
            throw new IllegalStateException(String.format("Awaited condition never met, waited %s secondes for %s:%n%s", maxSeconds, predicate, state));
        }

        public int size() {
            return this.spec.getMembers().size();
        }

        public InstanceId getServerId(HighlyAvailableGraphDatabase member) {
            this.assertMember(member);
            return (InstanceId)((Config)member.getDependencyResolver().resolveDependency(Config.class)).get(ClusterSettings.server_id);
        }

        public File getStoreDir(HighlyAvailableGraphDatabase member) {
            this.assertMember(member);
            return member.getStoreDirectory();
        }

        public void sync(HighlyAvailableGraphDatabase ... except) throws InterruptedException {
            HashSet<HighlyAvailableGraphDatabase> exceptSet = new HashSet<HighlyAvailableGraphDatabase>(Arrays.asList(except));
            for (HighlyAvailableGraphDatabase db : this.getAllMembers()) {
                if (exceptSet.contains(db)) continue;
                UpdatePullerClient client = (UpdatePullerClient)db.getDependencyResolver().resolveDependency(UpdatePullerClient.class);
                try {
                    if (!db.isAvailable(60000L)) continue;
                    client.pullUpdates();
                }
                catch (Exception e) {
                    throw new IllegalStateException(ClusterManager.stateToString(this), e);
                }
            }
        }

        public void info(String message) {
            for (HighlyAvailableGraphDatabase db : this.getAllMembers()) {
                LogService logService = (LogService)db.getDependencyResolver().resolveDependency(LogService.class);
                Log messagesLog = logService.getInternalLog(HighlyAvailableGraphDatabase.class);
                messagesLog.info(message);
            }
        }
    }

    private static final class FutureLifecycleAdapter<T extends Lifecycle>
    extends LifecycleAdapter {
        private final T wrapped;
        private final ExecutorService starter;
        private Future<Void> currentFuture;

        public FutureLifecycleAdapter(T toWrap) {
            this.wrapped = toWrap;
            this.starter = Executors.newFixedThreadPool(1);
        }

        public void init() throws Throwable {
            this.currentFuture = this.starter.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        FutureLifecycleAdapter.this.wrapped.init();
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException(throwable);
                    }
                    return null;
                }
            });
        }

        public void start() throws Throwable {
            this.currentFuture.get();
            this.currentFuture = this.starter.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        FutureLifecycleAdapter.this.wrapped.start();
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException(throwable);
                    }
                    return null;
                }
            });
        }

        public void stop() throws Throwable {
            this.currentFuture.get();
            this.currentFuture = this.starter.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        FutureLifecycleAdapter.this.wrapped.stop();
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException(throwable);
                    }
                    return null;
                }
            });
        }

        public void shutdown() throws Throwable {
            this.currentFuture = this.starter.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        FutureLifecycleAdapter.this.wrapped.shutdown();
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException(throwable);
                    }
                    return null;
                }
            });
            this.currentFuture.get();
            this.starter.shutdownNow();
        }
    }

    private static final class HighlyAvailableGraphDatabaseProxy {
        private final ExecutorService executor;
        private GraphDatabaseService result;
        private Future<GraphDatabaseService> untilThen;

        public HighlyAvailableGraphDatabaseProxy(final GraphDatabaseBuilder graphDatabaseBuilder) {
            Callable<GraphDatabaseService> starter = new Callable<GraphDatabaseService>(){

                @Override
                public GraphDatabaseService call() throws Exception {
                    return graphDatabaseBuilder.newGraphDatabase();
                }
            };
            this.executor = Executors.newFixedThreadPool(1);
            this.untilThen = this.executor.submit(starter);
        }

        public HighlyAvailableGraphDatabase get() {
            if (this.result == null) {
                try {
                    this.result = this.untilThen.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    this.executor.shutdownNow();
                }
            }
            return (HighlyAvailableGraphDatabase)this.result;
        }
    }

    public static class Builder {
        private final File root;
        private final Map<Integer, Map<String, String>> instanceConfig = new HashMap<Integer, Map<String, String>>();
        private Provider provider = ClusterManager.clusterOfSize(3);
        private Map<String, String> commonConfig = Collections.emptyMap();
        private HighlyAvailableGraphDatabaseFactory factory = new TestHighlyAvailableGraphDatabaseFactory();
        private StoreDirInitializer initializer;

        public Builder(File root) {
            this.root = root;
        }

        public Builder withSeedDir(final File seedDir) {
            return this.withStoreDirInitializer(new StoreDirInitializer(){

                @Override
                public void initializeStoreDir(int serverId, File storeDir) throws IOException {
                    FileUtils.copyRecursively((File)seedDir, (File)storeDir);
                }
            });
        }

        public Builder withStoreDirInitializer(StoreDirInitializer initializer) {
            this.initializer = initializer;
            return this;
        }

        public Builder withDbFactory(HighlyAvailableGraphDatabaseFactory dbFactory) {
            this.factory = dbFactory;
            return this;
        }

        public Builder withProvider(Provider provider) {
            this.provider = provider;
            return this;
        }

        public Builder withCommonConfig(Map<String, String> commonConfig) {
            this.commonConfig = commonConfig;
            return this;
        }

        public Builder withInstanceConfig(int instanceNr, Map<String, String> instanceConfig) {
            this.instanceConfig.put(instanceNr, instanceConfig);
            return this;
        }

        public ClusterManager build() {
            return new ClusterManager(this);
        }
    }

    public static interface RepairKit {
        public HighlyAvailableGraphDatabase repair() throws Throwable;
    }

    public static interface Provider {
        public Clusters clusters() throws Throwable;
    }

    public static interface StoreDirInitializer {
        public void initializeStoreDir(int var1, File var2) throws IOException;
    }
}

