/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.TargetDirectory;

@Ignore(value="build failures make this block forever")
public class TestClusterClientPadding {
    @Rule
    public TargetDirectory.TestDirectory testDirectory = TargetDirectory.testDirForTest(this.getClass());
    private ClusterManager clusterManager;
    private ClusterManager.ManagedCluster cluster;

    @Before
    public void before() throws Throwable {
        this.clusterManager = new ClusterManager(ClusterManager.clusterWithAdditionalClients((int)2, (int)1), this.testDirectory.directory("dbs"), MapUtil.stringMap((String[])new String[0]));
        this.clusterManager.start();
        this.cluster = this.clusterManager.getDefaultCluster();
        this.cluster.await(ClusterManager.masterAvailable((HighlyAvailableGraphDatabase[])new HighlyAvailableGraphDatabase[0]));
        this.cluster.await(ClusterManager.masterSeesMembers((int)3));
        this.cluster.await(ClusterManager.allSeesAllAsJoined());
    }

    @After
    public void after() throws Throwable {
        this.clusterManager.shutdown();
    }

    @Test
    public void additionalClusterClientCanHelpBreakTiesWhenMasterIsShutDown() throws Throwable {
        HighlyAvailableGraphDatabase sittingMaster = this.cluster.getMaster();
        this.cluster.shutdown(sittingMaster);
        this.cluster.await(ClusterManager.masterAvailable((HighlyAvailableGraphDatabase[])new HighlyAvailableGraphDatabase[]{sittingMaster}));
    }

    @Test
    public void additionalClusterClientCanHelpBreakTiesWhenMasterFails() throws Throwable {
        HighlyAvailableGraphDatabase sittingMaster = this.cluster.getMaster();
        this.cluster.fail(sittingMaster);
        this.cluster.await(ClusterManager.masterAvailable((HighlyAvailableGraphDatabase[])new HighlyAvailableGraphDatabase[]{sittingMaster}));
    }
}

