/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cluster.InstanceId;
import org.neo4j.function.Consumer;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.TransactionTemplate;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.test.ha.ClusterRule;

public class TxPushStrategyConfigIT {
    @Rule
    public final ClusterRule clusterRule = new ClusterRule(this.getClass());
    private static final int MASTER = 1;
    private static final int FIRST_SLAVE = 2;
    private static final int SECOND_SLAVE = 3;
    private static final int THIRD_SLAVE = 4;
    private InstanceId[] machineIds;

    @Test
    public void shouldPushToSlavesInDescendingOrder() throws Exception {
        ClusterManager.ManagedCluster cluster = this.startCluster(4, 2, "fixed");
        for (int i = 0; i < 5; ++i) {
            this.createTransactionOnMaster(cluster);
            this.assertLastTransactions(cluster, this.lastTx(4, 2L + (long)i));
            this.assertLastTransactions(cluster, this.lastTx(3, 2L + (long)i));
            this.assertLastTransactions(cluster, this.lastTx(2, 1L));
        }
    }

    @Test
    public void twoRoundRobin() throws Exception {
        ClusterManager.ManagedCluster cluster = this.startCluster(4, 2, "round_robin");
        this.createTransactionOnMaster(cluster);
        this.assertLastTransactions(cluster, this.lastTx(2, 2L), this.lastTx(3, 2L), this.lastTx(4, 1L));
        this.createTransactionOnMaster(cluster);
        this.assertLastTransactions(cluster, this.lastTx(2, 2L), this.lastTx(3, 3L), this.lastTx(4, 3L));
        this.createTransactionOnMaster(cluster);
        this.assertLastTransactions(cluster, this.lastTx(2, 4L), this.lastTx(3, 3L), this.lastTx(4, 4L));
    }

    @Test
    public void shouldPushToOneLessSlaveOnSlaveCommit() throws Exception {
        ClusterManager.ManagedCluster cluster = this.startCluster(4, 2, "fixed");
        this.createTransactionOn(cluster, new InstanceId(2));
        this.assertLastTransactions(cluster, this.lastTx(1, 2L), this.lastTx(2, 2L), this.lastTx(3, 1L), this.lastTx(4, 2L));
        this.createTransactionOn(cluster, new InstanceId(3));
        this.assertLastTransactions(cluster, this.lastTx(1, 3L), this.lastTx(2, 2L), this.lastTx(3, 3L), this.lastTx(4, 3L));
        this.createTransactionOn(cluster, new InstanceId(4));
        this.assertLastTransactions(cluster, this.lastTx(1, 4L), this.lastTx(2, 2L), this.lastTx(3, 4L), this.lastTx(4, 4L));
    }

    @Test
    public void slavesListGetsUpdatedWhenSlaveLeavesNicely() throws Exception {
        ClusterManager.ManagedCluster cluster = this.startCluster(3, 1, "fixed");
        cluster.shutdown(cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]));
        cluster.await(ClusterManager.masterSeesSlavesAsAvailable((int)1));
    }

    @Test
    public void slaveListIsCorrectAfterMasterSwitch() throws Exception {
        ClusterManager.ManagedCluster cluster = this.startCluster(3, 1, "fixed");
        cluster.shutdown(cluster.getMaster());
        cluster.await(ClusterManager.masterAvailable((HighlyAvailableGraphDatabase[])new HighlyAvailableGraphDatabase[0]));
        HighlyAvailableGraphDatabase newMaster = cluster.getMaster();
        cluster.await(ClusterManager.masterSeesSlavesAsAvailable((int)1));
        this.createTransaction(cluster, (GraphDatabaseAPI)newMaster);
        this.assertLastTransactions(cluster, this.lastTx(2, 2L), this.lastTx(3, 2L));
    }

    @Test
    public void slavesListGetsUpdatedWhenSlaveRageQuits() throws Throwable {
        ClusterManager.ManagedCluster cluster = this.startCluster(3, 1, "fixed");
        cluster.fail(cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]));
        cluster.await(ClusterManager.masterSeesSlavesAsAvailable((int)1));
    }

    private ClusterManager.ManagedCluster startCluster(int memberCount, int pushFactor, String pushStrategy) throws Exception {
        ClusterManager.ManagedCluster cluster = this.clusterRule.provider(ClusterManager.clusterOfSize((int)memberCount)).config(HaSettings.tx_push_factor, "" + pushFactor).config(HaSettings.tx_push_strategy, pushStrategy).availabilityChecks(Arrays.asList(ClusterManager.allSeesAllAsAvailable())).startCluster();
        this.mapMachineIds(cluster);
        return cluster;
    }

    private void mapMachineIds(final ClusterManager.ManagedCluster cluster) {
        this.machineIds = new InstanceId[cluster.size()];
        this.machineIds[0] = cluster.getServerId(cluster.getMaster());
        ArrayList<HighlyAvailableGraphDatabase> slaves = new ArrayList<HighlyAvailableGraphDatabase>();
        for (HighlyAvailableGraphDatabase hadb : cluster.getAllMembers()) {
            if (hadb.isMaster()) continue;
            slaves.add(hadb);
        }
        Collections.sort(slaves, new Comparator<HighlyAvailableGraphDatabase>(){

            @Override
            public int compare(HighlyAvailableGraphDatabase o1, HighlyAvailableGraphDatabase o2) {
                return cluster.getServerId(o1).compareTo(cluster.getServerId(o2));
            }
        });
        Iterator iter = slaves.iterator();
        int i = 1;
        while (iter.hasNext()) {
            this.machineIds[i] = cluster.getServerId((HighlyAvailableGraphDatabase)iter.next());
            ++i;
        }
    }

    private void assertLastTransactions(ClusterManager.ManagedCluster cluster, LastTxMapping ... transactionMappings) {
        StringBuilder failures = new StringBuilder();
        for (LastTxMapping mapping : transactionMappings) {
            HighlyAvailableGraphDatabase db = cluster.getMemberByServerId(mapping.serverId);
            mapping.format(failures, this.getLastTx((GraphDatabaseAPI)db));
        }
        Assert.assertTrue((String)failures.toString(), (failures.length() == 0 ? 1 : 0) != 0);
    }

    private long getLastTx(GraphDatabaseAPI db) {
        return ((TransactionIdStore)db.getDependencyResolver().resolveDependency(TransactionIdStore.class)).getLastCommittedTransactionId();
    }

    private LastTxMapping lastTx(int serverIndex, long txId) {
        InstanceId serverId = this.machineIds[serverIndex - 1];
        return new LastTxMapping(serverId, txId);
    }

    private void createTransactionOnMaster(ClusterManager.ManagedCluster cluster) {
        this.createTransaction(cluster, (GraphDatabaseAPI)cluster.getMaster());
    }

    private void createTransactionOn(ClusterManager.ManagedCluster cluster, InstanceId serverId) {
        this.createTransaction(cluster, (GraphDatabaseAPI)cluster.getMemberByServerId(serverId));
    }

    private void createTransaction(final ClusterManager.ManagedCluster cluster, final GraphDatabaseAPI db) {
        TransactionTemplate template = new TransactionTemplate().with((GraphDatabaseService)db).retries(10).backoff(1L, TimeUnit.SECONDS).monitor((TransactionTemplate.Monitor)new TransactionTemplate.Monitor.Adapter(){

            public void failure(Throwable ex) {
                cluster.await(ClusterManager.allSeesAllAsAvailable());
                TxPushStrategyConfigIT.this.mapMachineIds(cluster);
            }
        });
        template.execute((Consumer)new Consumer<Transaction>(){

            public void accept(Transaction transaction) {
                db.createNode();
            }
        });
    }

    private static class LastTxMapping {
        private final InstanceId serverId;
        private final long txId;

        public LastTxMapping(InstanceId serverId, long txId) {
            this.serverId = serverId;
            this.txId = txId;
        }

        public void format(StringBuilder failures, long txId) {
            if (txId != this.txId) {
                if (failures.length() > 0) {
                    failures.append(", ");
                }
                failures.append(String.format("tx id on server:%d, expected [%d] but was [%d]", this.serverId.toIntegerIndex(), this.txId, txId));
            }
        }
    }
}

