/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.PullerFactory;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.ha.UpdatePullerModeSwitcher;
import org.neo4j.kernel.ha.cluster.ModeSwitcherNotifier;

public class UpdatePullerModeSwitcherTest {
    private UpdatePullerModeSwitcher modeSwitcher;
    private PullerFactory pullersFactory;
    private DelegateInvocationHandler invocationHandler;
    private ModeSwitcherNotifier switcherNotifier;

    @Before
    public void setUp() {
        this.switcherNotifier = (ModeSwitcherNotifier)Mockito.mock(ModeSwitcherNotifier.class);
        this.invocationHandler = (DelegateInvocationHandler)Mockito.mock(DelegateInvocationHandler.class);
        this.pullersFactory = (PullerFactory)Mockito.mock(PullerFactory.class);
        this.modeSwitcher = new UpdatePullerModeSwitcher(this.switcherNotifier, this.invocationHandler, this.pullersFactory);
    }

    @Test
    public void masterUpdatePuller() {
        UpdatePuller masterPuller = this.modeSwitcher.getMasterImpl();
        Assert.assertEquals((Object)UpdatePuller.NONE, (Object)masterPuller);
    }

    @Test
    public void slaveUpdatePuller() {
        UpdatePuller updatePuller = (UpdatePuller)Mockito.mock(UpdatePuller.class);
        Mockito.when((Object)this.pullersFactory.createUpdatePuller()).thenReturn((Object)updatePuller);
        UpdatePuller slavePuller = this.modeSwitcher.getSlaveImpl();
        Assert.assertEquals((Object)updatePuller, (Object)slavePuller);
    }
}

