/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.com.master;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.neo4j.com.RequestContext;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.cluster.ConversationSPI;
import org.neo4j.kernel.ha.com.master.Conversation;
import org.neo4j.kernel.ha.com.master.ConversationManager;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.collection.TimedRepository;

@RunWith(value=MockitoJUnitRunner.class)
public class ConversationManagerTest {
    @Mock
    private ConversationSPI conversationSPI;
    @Mock
    private Config config;
    private ConversationManager conversationManager;

    @Test
    public void testStart() throws Exception {
        JobScheduler.JobHandle reaperJobHandle = (JobScheduler.JobHandle)Mockito.mock(JobScheduler.JobHandle.class);
        Mockito.when((Object)this.config.get(HaSettings.lock_read_timeout)).thenReturn((Object)1L);
        Mockito.when((Object)this.conversationSPI.scheduleRecurringJob((JobScheduler.Group)Matchers.any(JobScheduler.Group.class), ((Long)Matchers.any(Long.class)).longValue(), (Runnable)Matchers.any(Runnable.class))).thenReturn((Object)reaperJobHandle);
        this.conversationManager = this.getConversationManager();
        this.conversationManager.start();
        Assert.assertNotNull((Object)this.conversationManager.conversations);
        ((ConversationSPI)Mockito.verify((Object)this.conversationSPI)).scheduleRecurringJob((JobScheduler.Group)Matchers.any(JobScheduler.Group.class), ((Long)Matchers.any(Long.class)).longValue(), (Runnable)Matchers.any(Runnable.class));
    }

    @Test
    public void testStop() throws Exception {
        JobScheduler.JobHandle reaperJobHandle = (JobScheduler.JobHandle)Mockito.mock(JobScheduler.JobHandle.class);
        Mockito.when((Object)this.config.get(HaSettings.lock_read_timeout)).thenReturn((Object)1L);
        Mockito.when((Object)this.conversationSPI.scheduleRecurringJob((JobScheduler.Group)Matchers.any(JobScheduler.Group.class), ((Long)Matchers.any(Long.class)).longValue(), (Runnable)Matchers.any(Runnable.class))).thenReturn((Object)reaperJobHandle);
        this.conversationManager = this.getConversationManager();
        this.conversationManager.start();
        this.conversationManager.stop();
        Assert.assertNull((Object)this.conversationManager.conversations);
        ((JobScheduler.JobHandle)Mockito.verify((Object)reaperJobHandle)).cancel(false);
    }

    @Test
    public void testConversationWorkflow() throws Exception {
        TimedRepository conversationStorage;
        JobScheduler.JobHandle reaperJobHandle = (JobScheduler.JobHandle)Mockito.mock(JobScheduler.JobHandle.class);
        Mockito.when((Object)this.config.get(HaSettings.lock_read_timeout)).thenReturn((Object)1L);
        Mockito.when((Object)this.conversationSPI.scheduleRecurringJob((JobScheduler.Group)Matchers.any(JobScheduler.Group.class), ((Long)Matchers.any(Long.class)).longValue(), (Runnable)Matchers.any(Runnable.class))).thenReturn((Object)reaperJobHandle);
        RequestContext requestContext = this.getRequestContext();
        this.conversationManager = this.getConversationManager();
        this.conversationManager.conversations = conversationStorage = (TimedRepository)Mockito.mock(TimedRepository.class);
        this.conversationManager.begin(requestContext);
        this.conversationManager.acquire(requestContext);
        this.conversationManager.release(requestContext);
        this.conversationManager.end(requestContext);
        InOrder conversationOrder = Mockito.inOrder((Object[])new Object[]{conversationStorage});
        ((TimedRepository)conversationOrder.verify((Object)conversationStorage)).begin((Object)requestContext);
        ((TimedRepository)conversationOrder.verify((Object)conversationStorage)).acquire((Object)requestContext);
        ((TimedRepository)conversationOrder.verify((Object)conversationStorage)).release((Object)requestContext);
        ((TimedRepository)conversationOrder.verify((Object)conversationStorage)).end((Object)requestContext);
    }

    @Test
    public void testConversationStop() {
        RequestContext requestContext = this.getRequestContext();
        this.conversationManager = this.getConversationManager();
        Conversation conversation = (Conversation)Mockito.mock(Conversation.class);
        Mockito.when((Object)conversation.isActive()).thenReturn((Object)true);
        TimedRepository conversationStorage = (TimedRepository)Mockito.mock(TimedRepository.class);
        Mockito.when((Object)conversationStorage.end((Object)requestContext)).thenReturn((Object)conversation);
        this.conversationManager.conversations = conversationStorage;
        this.conversationManager.stop(requestContext);
        ((TimedRepository)Mockito.verify((Object)conversationStorage)).end((Object)requestContext);
        ((Conversation)Mockito.verify((Object)conversation)).stop();
    }

    private RequestContext getRequestContext() {
        return new RequestContext(1L, 1, 1, 1L, 1L);
    }

    private ConversationManager getConversationManager() {
        return new ConversationManager(this.conversationSPI, this.config, 1000, 5000);
    }
}

