/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.id;

import java.io.File;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.id.HaIdGeneratorFactory;
import org.neo4j.kernel.ha.id.IdAllocation;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdRange;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class HaIdGeneratorFactoryTest {
    private Master master;
    private DelegateInvocationHandler<Master> masterDelegate;
    private EphemeralFileSystemAbstraction fs;
    private HaIdGeneratorFactory fac;

    @Test
    public void slaveIdGeneratorShouldReturnFromAssignedRange() throws Exception {
        IdAllocation firstResult = new IdAllocation(new IdRange(new long[0], 42L, 123), 123L, 0L);
        Response<IdAllocation> response = this.response(firstResult, new IdAllocation[0]);
        Mockito.when((Object)this.master.allocateIds((RequestContext)Matchers.any(RequestContext.class), (IdType)Matchers.any(IdType.class))).thenReturn(response);
        IdGenerator gen = this.switchToSlave();
        for (long i = firstResult.getIdRange().getRangeStart(); i < (long)firstResult.getIdRange().getRangeLength(); ++i) {
            Assert.assertEquals((long)i, (long)gen.nextId());
        }
        ((Master)Mockito.verify((Object)this.master, (VerificationMode)Mockito.times((int)1))).allocateIds((RequestContext)Matchers.any(RequestContext.class), (IdType)Matchers.eq((Object)IdType.NODE));
    }

    @Test
    public void slaveIdGeneratorShouldAskForMoreWhenRangeIsOver() throws Exception {
        long i;
        IdAllocation firstResult = new IdAllocation(new IdRange(new long[0], 42L, 123), 165L, 0L);
        IdAllocation secondResult = new IdAllocation(new IdRange(new long[0], 1042L, 223), 1265L, 0L);
        Response<IdAllocation> response = this.response(firstResult, secondResult);
        Mockito.when((Object)this.master.allocateIds((RequestContext)Matchers.any(RequestContext.class), (IdType)Matchers.any(IdType.class))).thenReturn(response);
        IdGenerator gen = this.switchToSlave();
        long startAt = firstResult.getIdRange().getRangeStart();
        long forThatMany = firstResult.getIdRange().getRangeLength();
        for (i = startAt; i < startAt + forThatMany; ++i) {
            Assert.assertEquals((long)i, (long)gen.nextId());
        }
        ((Master)Mockito.verify((Object)this.master, (VerificationMode)Mockito.times((int)1))).allocateIds((RequestContext)Matchers.any(RequestContext.class), (IdType)Matchers.eq((Object)IdType.NODE));
        startAt = secondResult.getIdRange().getRangeStart();
        forThatMany = secondResult.getIdRange().getRangeLength();
        for (i = startAt; i < startAt + forThatMany; ++i) {
            Assert.assertEquals((long)i, (long)gen.nextId());
        }
        ((Master)Mockito.verify((Object)this.master, (VerificationMode)Mockito.times((int)2))).allocateIds((RequestContext)Matchers.any(RequestContext.class), (IdType)Matchers.eq((Object)IdType.NODE));
    }

    @Test
    public void shouldUseDefraggedIfPresent() throws Exception {
        long[] defragIds = new long[]{42L, 27172828L, 314159L};
        IdAllocation firstResult = new IdAllocation(new IdRange(defragIds, 0L, 0), 0L, (long)defragIds.length);
        Response<IdAllocation> response = this.response(firstResult, new IdAllocation[0]);
        Mockito.when((Object)this.master.allocateIds((RequestContext)Matchers.any(RequestContext.class), (IdType)Matchers.any(IdType.class))).thenReturn(response);
        IdGenerator gen = this.switchToSlave();
        for (long defragId : defragIds) {
            Assert.assertEquals((long)defragId, (long)gen.nextId());
        }
    }

    @Test
    public void shouldMoveFromDefraggedToRange() throws Exception {
        long[] defragIds = new long[]{42L, 27172828L, 314159L};
        IdAllocation firstResult = new IdAllocation(new IdRange(defragIds, 0L, 10), 100L, (long)defragIds.length);
        Response<IdAllocation> response = this.response(firstResult, new IdAllocation[0]);
        Mockito.when((Object)this.master.allocateIds((RequestContext)Matchers.any(RequestContext.class), (IdType)Matchers.any(IdType.class))).thenReturn(response);
        IdGenerator gen = this.switchToSlave();
        for (long defragId : defragIds) {
            Assert.assertEquals((long)defragId, (long)gen.nextId());
        }
    }

    @Test
    public void slaveShouldNeverAllowReducingHighId() throws Exception {
        int highIdFromAllocation = 123;
        IdAllocation firstResult = new IdAllocation(new IdRange(new long[0], 42L, 123), 123L, 0L);
        Response<IdAllocation> response = this.response(firstResult, new IdAllocation[0]);
        Mockito.when((Object)this.master.allocateIds((RequestContext)Matchers.any(RequestContext.class), (IdType)Matchers.any(IdType.class))).thenReturn(response);
        IdGenerator gen = this.switchToSlave();
        int highIdFromUpdatedRecord = 124;
        gen.setHighId(124L);
        gen.nextId();
        Assert.assertEquals((long)124L, (long)gen.getHighId());
    }

    @Before
    public void before() {
        this.master = (Master)Mockito.mock(Master.class);
        this.masterDelegate = new DelegateInvocationHandler(Master.class);
        this.fs = new EphemeralFileSystemAbstraction();
        this.fac = new HaIdGeneratorFactory(this.masterDelegate, (LogProvider)NullLogProvider.getInstance(), (RequestContextFactory)Mockito.mock(RequestContextFactory.class), (FileSystemAbstraction)this.fs);
    }

    private Response<IdAllocation> response(IdAllocation firstValue, IdAllocation ... additionalValues) {
        Response response = (Response)Mockito.mock(Response.class);
        Mockito.when((Object)response.response()).thenReturn((Object)firstValue, (Object[])additionalValues);
        return response;
    }

    private IdGenerator switchToSlave() {
        this.fac.switchToSlave();
        IdGenerator gen = this.fac.open(new File("someFile"), 10, IdType.NODE, 1L);
        this.masterDelegate.setDelegate((Object)this.master);
        return gen;
    }
}

