/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.IOException;
import java.util.Arrays;
import org.neo4j.function.ThrowingLongUnaryOperator;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.NoSuchTransactionException;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;

public class TransactionChecksumLookup
implements ThrowingLongUnaryOperator<IOException> {
    private final TransactionIdStore transactionIdStore;
    private final LogicalTransactionStore logicalTransactionStore;

    public TransactionChecksumLookup(TransactionIdStore transactionIdStore, LogicalTransactionStore logicalTransactionStore) {
        this.transactionIdStore = transactionIdStore;
        this.logicalTransactionStore = logicalTransactionStore;
    }

    public long applyAsLong(long txId) throws IOException {
        long[] lastCommittedTransaction = this.transactionIdStore.getLastCommittedTransaction();
        if (lastCommittedTransaction[0] == txId) {
            return lastCommittedTransaction[1];
        }
        try {
            return this.logicalTransactionStore.getMetadataFor(txId).getChecksum();
        }
        catch (NoSuchTransactionException e) {
            long[] lastUpgradeTransaction = this.transactionIdStore.getUpgradeTransaction();
            if (lastUpgradeTransaction[0] == txId) {
                return lastUpgradeTransaction[1];
            }
            throw (NoSuchTransactionException)Exceptions.withMessage((Throwable)e, (String)(e.getMessage() + " | transaction id store says last transaction is " + Arrays.toString(lastCommittedTransaction) + " and last upgrade transaction is " + Arrays.toString(lastUpgradeTransaction)));
        }
    }
}

