/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.member.ClusterMemberAvailability;
import org.neo4j.com.ServerUtil;
import org.neo4j.function.BiFunction;
import org.neo4j.function.Factory;
import org.neo4j.function.Function;
import org.neo4j.function.Supplier;
import org.neo4j.helpers.Clock;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.com.master.ConversationManager;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.master.MasterServer;
import org.neo4j.kernel.ha.com.master.SlaveFactory;
import org.neo4j.kernel.ha.id.HaIdGeneratorFactory;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.transaction.TransactionCounters;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.logging.Log;

public class SwitchToMaster
implements AutoCloseable {
    private LogService logService;
    Factory<ConversationManager> conversationManagerFactory;
    Function<ConversationManager, Master> masterFactory;
    BiFunction<Master, ConversationManager, MasterServer> masterServerFactory;
    private TransactionCounters transactionCounters;
    private Log userLog;
    private HaIdGeneratorFactory idGeneratorFactory;
    private Config config;
    private Supplier<SlaveFactory> slaveFactorySupplier;
    private DelegateInvocationHandler<Master> masterDelegateHandler;
    private ClusterMemberAvailability clusterMemberAvailability;
    private Supplier<NeoStoreDataSource> dataSourceSupplier;

    public SwitchToMaster(LogService logService, HaIdGeneratorFactory idGeneratorFactory, Config config, Supplier<SlaveFactory> slaveFactorySupplier, Factory<ConversationManager> conversationManagerFactory, Function<ConversationManager, Master> masterFactory, BiFunction<Master, ConversationManager, MasterServer> masterServerFactory, DelegateInvocationHandler<Master> masterDelegateHandler, ClusterMemberAvailability clusterMemberAvailability, Supplier<NeoStoreDataSource> dataSourceSupplier, TransactionCounters transactionCounters) {
        this.logService = logService;
        this.conversationManagerFactory = conversationManagerFactory;
        this.masterFactory = masterFactory;
        this.masterServerFactory = masterServerFactory;
        this.transactionCounters = transactionCounters;
        this.userLog = logService.getUserLog(this.getClass());
        this.idGeneratorFactory = idGeneratorFactory;
        this.config = config;
        this.slaveFactorySupplier = slaveFactorySupplier;
        this.masterDelegateHandler = masterDelegateHandler;
        this.clusterMemberAvailability = clusterMemberAvailability;
        this.dataSourceSupplier = dataSourceSupplier;
    }

    public URI switchToMaster(LifeSupport haCommunicationLife, URI me) {
        this.userLog.info("I am %s, moving to master", new Object[]{this.myId()});
        long deadline = Clock.SYSTEM_CLOCK.currentTimeMillis() + (Long)this.config.get(HaSettings.state_switch_timeout);
        while (this.transactionCounters.getNumberOfActiveTransactions() > 0L && Clock.SYSTEM_CLOCK.currentTimeMillis() < deadline) {
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
        }
        this.idGeneratorFactory.switchToMaster();
        NeoStoreDataSource neoStoreXaDataSource = (NeoStoreDataSource)this.dataSourceSupplier.get();
        neoStoreXaDataSource.afterModeSwitch();
        ConversationManager conversationManager = (ConversationManager)((Object)this.conversationManagerFactory.newInstance());
        Master master = (Master)this.masterFactory.apply((Object)conversationManager);
        MasterServer masterServer = (MasterServer)((Object)this.masterServerFactory.apply((Object)master, (Object)conversationManager));
        haCommunicationLife.add((Object)master);
        haCommunicationLife.add((Object)masterServer);
        this.masterDelegateHandler.setDelegate(master);
        haCommunicationLife.start();
        URI masterHaURI = this.getMasterUri(me, masterServer);
        this.clusterMemberAvailability.memberIsAvailable("master", masterHaURI, neoStoreXaDataSource.getStoreId());
        this.userLog.info("I am %s, successfully moved to master", new Object[]{this.myId()});
        ((SlaveFactory)this.slaveFactorySupplier.get()).setStoreId(neoStoreXaDataSource.getStoreId());
        return masterHaURI;
    }

    private URI getMasterUri(URI me, MasterServer masterServer) {
        String hostname = ServerUtil.getHostString((InetSocketAddress)masterServer.getSocketAddress()).contains("0.0.0.0") ? me.getHost() : ServerUtil.getHostString((InetSocketAddress)masterServer.getSocketAddress());
        int port = masterServer.getSocketAddress().getPort();
        return URI.create("ha://" + hostname + ":" + port + "?serverId=" + this.myId());
    }

    private InstanceId myId() {
        return (InstanceId)this.config.get(ClusterSettings.server_id);
    }

    @Override
    public void close() throws Exception {
        this.logService = null;
        this.userLog = null;
        this.conversationManagerFactory = null;
        this.masterFactory = null;
        this.masterServerFactory = null;
        this.idGeneratorFactory = null;
        this.config = null;
        this.slaveFactorySupplier = null;
        this.masterDelegateHandler = null;
        this.clusterMemberAvailability = null;
        this.dataSourceSupplier = null;
    }
}

