/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.io.File;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.TargetDirectory;

public class HaCacheIT {
    private static final int DENSE_NODE = 10;
    @Rule
    public TargetDirectory.TestDirectory root = TargetDirectory.testDirForTest(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldUpdateSlaveCacheWhenRemovingRelationshipGroupFromDenseNode() throws Throwable {
        ClusterManager manager = new ClusterManager(ClusterManager.clusterOfSize((int)3), this.root.directory(), MapUtil.stringMap((String[])new String[]{HaSettings.tx_push_factor.name(), "2", GraphDatabaseSettings.dense_node_threshold.name(), "10"}));
        try {
            Object db2;
            long nodeId;
            manager.start();
            ClusterManager.ManagedCluster cluster = manager.getDefaultCluster();
            cluster.await(ClusterManager.masterAvailable((HighlyAvailableGraphDatabase[])new HighlyAvailableGraphDatabase[0]));
            cluster.await(ClusterManager.masterSeesAllSlavesAsAvailable());
            HighlyAvailableGraphDatabase master = cluster.getMaster();
            try (Transaction tx = master.beginTx();){
                Node node = master.createNode();
                for (int i = 0; i < 10; ++i) {
                    node.createRelationshipTo(master.createNode(), (RelationshipType)DynamicRelationshipType.withName((String)"FOO"));
                }
                master.createNode().createRelationshipTo(node, (RelationshipType)DynamicRelationshipType.withName((String)"BAR"));
                tx.success();
                nodeId = node.getId();
            }
            int count = 0;
            for (Object db2 : cluster.getAllMembers()) {
                Transaction tx = db2.beginTx();
                Throwable throwable = null;
                try {
                    int these = IteratorUtil.count((Iterable)db2.getNodeById(nodeId).getRelationships());
                    Assert.assertTrue((String)String.format("expected=%s, count here=%s", count, these), (these != 0 && (count == 0 || these == count) ? 1 : 0) != 0);
                    count = these;
                    tx.success();
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
                finally {
                    if (tx == null) continue;
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    tx.close();
                }
            }
            Transaction tx = master.beginTx();
            db2 = null;
            try {
                for (Relationship relationship : master.getNodeById(nodeId).getRelationships(new RelationshipType[]{DynamicRelationshipType.withName((String)"BAR")})) {
                    relationship.delete();
                }
                tx.success();
            }
            catch (Throwable throwable) {
                db2 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (db2 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable x2) {
                            ((Throwable)db2).addSuppressed(x2);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
            HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
            try (Transaction tx2 = slave.beginTx();){
                ArrayList<String> relationships = new ArrayList<String>();
                for (Relationship relationship : slave.getNodeById(nodeId).getRelationships()) {
                    relationships.add(String.format("(%d)-[%d:%s]->(%d)", relationship.getStartNode().getId(), relationship.getId(), relationship.getType().name(), relationship.getEndNode().getId()));
                }
                Assert.assertEquals((String)this.joinLines(relationships), (long)(count - 1), (long)relationships.size());
                Assert.assertEquals((long)(count - 1), (long)IteratorUtil.count((Iterable)slave.getNodeById(nodeId).getRelationships()));
                tx2.success();
            }
        }
        finally {
            manager.shutdown();
        }
    }

    @Test
    public void duplicatePropertyWhenAddingChangingAPropertyFromSlaveAndMasterRespectively() throws Throwable {
        File storeDir = this.root.directory("ha-cluster");
        FileUtils.deleteRecursively((File)storeDir);
        ClusterManager clusterManager = new ClusterManager(new ClusterManager.Builder(storeDir).withProvider(ClusterManager.clusterOfSize((int)3)));
        clusterManager.start();
        ClusterManager.ManagedCluster cluster = clusterManager.getDefaultCluster();
        cluster.await(ClusterManager.allSeesAllAsAvailable());
        long id = this.init((GraphDatabaseService)cluster.getMaster());
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        try (Transaction tx = slave.beginTx();){
            Node node = slave.getNodeById(id);
            node.setProperty("1", (Object)1);
            tx.success();
        }
        Thread.sleep(100L);
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        try (Transaction tx = master.beginTx();){
            Node node = master.getNodeById(id);
            node.setProperty("1", (Object)0);
            tx.success();
        }
        clusterManager.stop();
        clusterManager.shutdown();
        File masterStoreDir = new File(storeDir, "neo4j.ha/server1");
        ConsistencyCheckService.Result result = new ConsistencyCheckService().runFullConsistencyCheck(masterStoreDir, new Config(), ProgressMonitorFactory.NONE, (LogProvider)NullLogProvider.getInstance(), false);
        Assert.assertTrue((boolean)result.isSuccessful());
    }

    private long init(GraphDatabaseService db) {
        long id;
        try (Transaction tx = db.beginTx();){
            Node theNode = db.createNode();
            id = theNode.getId();
            for (int i = 0; i < 1; ++i) {
                Node node = db.createNode();
                node.setProperty("" + i, (Object)("" + i));
            }
            tx.success();
        }
        tx = db.beginTx();
        var5_3 = null;
        try {
            Node node = db.getNodeById(id);
            node.setProperty("0", (Object)0);
            tx.success();
        }
        catch (Throwable throwable) {
            var5_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var5_3.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        return id;
    }

    private String joinLines(Iterable<String> lines) {
        StringBuilder result = new StringBuilder();
        for (String line : lines) {
            result.append("\n\t").append(line);
        }
        return result.toString();
    }
}

