/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.io.File;
import java.net.URI;
import java.util.logging.Level;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.LoggerRule;
import org.neo4j.test.TargetDirectory;

@Ignore(value="Fails too often")
public class MultipleClusterTest {
    @Rule
    public LoggerRule logging = new LoggerRule(Level.OFF);
    @Rule
    public TargetDirectory.TestDirectory testDirectory = TargetDirectory.testDirForTest(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void runTwoClusters() throws Throwable {
        File root = this.testDirectory.directory("cluster");
        ClusterManager clusterManager = new ClusterManager(ClusterManager.fromXml((URI)this.getClass().getResource("/twoclustertest.xml").toURI()), root, MapUtil.stringMap((String[])new String[0]));
        try {
            Transaction transaction;
            clusterManager.start();
            ClusterManager.ManagedCluster cluster1 = clusterManager.getCluster("neo4j.ha");
            HighlyAvailableGraphDatabase master = cluster1.getMaster();
            this.logging.getLogger().info("CREATE NODE");
            Transaction tx = master.beginTx();
            Node node = master.createNode();
            node.setProperty("cluster", (Object)"neo4j.ha");
            long cluster1NodeId = node.getId();
            this.logging.getLogger().info("CREATED NODE");
            tx.success();
            tx.close();
            ClusterManager.ManagedCluster cluster2 = clusterManager.getCluster("neo4j.ha2");
            HighlyAvailableGraphDatabase master2 = cluster2.getMaster();
            this.logging.getLogger().info("CREATE NODE");
            Transaction tx2 = master2.beginTx();
            Node node2 = master2.createNode();
            node2.setProperty("cluster", (Object)"neo4j.ha2");
            long cluster2NodeId = node2.getId();
            this.logging.getLogger().info("CREATED NODE");
            tx2.success();
            tx2.close();
            for (HighlyAvailableGraphDatabase highlyAvailableGraphDatabase : cluster1.getAllMembers()) {
                ((UpdatePuller)highlyAvailableGraphDatabase.getDependencyResolver().resolveDependency(UpdatePuller.class)).pullUpdates();
                transaction = highlyAvailableGraphDatabase.beginTx();
                Assert.assertEquals((Object)"neo4j.ha", (Object)highlyAvailableGraphDatabase.getNodeById(cluster1NodeId).getProperty("cluster"));
                transaction.close();
            }
            for (HighlyAvailableGraphDatabase highlyAvailableGraphDatabase : cluster2.getAllMembers()) {
                ((UpdatePuller)highlyAvailableGraphDatabase.getDependencyResolver().resolveDependency(UpdatePuller.class)).pullUpdates();
                transaction = highlyAvailableGraphDatabase.beginTx();
                Assert.assertEquals((Object)"neo4j.ha2", (Object)highlyAvailableGraphDatabase.getNodeById(cluster2NodeId).getProperty("cluster"));
                transaction.close();
            }
        }
        finally {
            clusterManager.stop();
        }
    }
}

