/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.TestHighlyAvailableGraphDatabaseFactory;
import org.neo4j.graphdb.index.Index;
import org.neo4j.helpers.SillyUtils;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.impl.util.Listener;
import org.neo4j.kernel.impl.util.StoreUtil;
import org.neo4j.kernel.lifecycle.LifeRule;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.tooling.GlobalGraphOperations;

public class TestBranchedData {
    @Rule
    public final LifeRule life = new LifeRule(true);
    @Rule
    public final TargetDirectory.TestDirectory directory = TargetDirectory.testDirForTest(this.getClass());

    @Test
    public void migrationOfBranchedDataDirectories() throws Exception {
        long[] timestamps = new long[3];
        for (int i = 0; i < timestamps.length; ++i) {
            this.startDbAndCreateNode();
            timestamps[i] = this.moveAwayToLookLikeOldBranchedDirectory();
            Thread.sleep(1L);
        }
        File dir = this.directory.directory();
        new TestHighlyAvailableGraphDatabaseFactory().newEmbeddedDatabaseBuilder(dir).setConfig(ClusterSettings.server_id, "1").setConfig(ClusterSettings.initial_hosts, "localhost:5001").newGraphDatabase().shutdown();
        for (long timestamp : timestamps) {
            Assert.assertFalse((String)("directory branched-" + timestamp + " still exists."), (boolean)new File(dir, "branched-" + timestamp).exists());
            Assert.assertTrue((String)("directory " + timestamp + " is not there"), (boolean)StoreUtil.getBranchedDataDirectory((File)dir, (long)timestamp).exists());
        }
    }

    @Test
    public void shouldCopyStoreFromMasterIfBranched() throws Throwable {
        File dir = this.directory.directory();
        ClusterManager clusterManager = (ClusterManager)this.life.add((Lifecycle)new ClusterManager(ClusterManager.clusterOfSize((int)2), dir, MapUtil.stringMap((String[])new String[0])));
        ClusterManager.ManagedCluster cluster = clusterManager.getDefaultCluster();
        cluster.await(ClusterManager.allSeesAllAsAvailable());
        this.createNode((GraphDatabaseService)cluster.getMaster(), "A", new Listener[0]);
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        String storeDir = slave.getStoreDir();
        ClusterManager.RepairKit starter = cluster.shutdown(slave);
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        this.createNode((GraphDatabaseService)master, "B1", new Listener[0]);
        this.createNode((GraphDatabaseService)master, "C", new Listener[0]);
        this.createNodeOffline(storeDir, "B2");
        slave = starter.repair();
        cluster.await(ClusterManager.allSeesAllAsAvailable());
        slave.beginTx().close();
    }

    @Test
    public void shouldCopyStoreFromMasterIfBranchedInLiveScenario() throws Throwable {
        File dir = this.directory.directory();
        ClusterManager clusterManager = (ClusterManager)this.life.add((Lifecycle)new ClusterManager(ClusterManager.clusterOfSize((int)3), dir, MapUtil.stringMap((String[])new String[]{HaSettings.tx_push_factor.name(), "0", HaSettings.pull_interval.name(), "0"})));
        ClusterManager.ManagedCluster cluster = clusterManager.getDefaultCluster();
        cluster.await(ClusterManager.allSeesAllAsAvailable());
        HighlyAvailableGraphDatabase thor = cluster.getMaster();
        String indexName = "valhalla";
        this.createNode((GraphDatabaseService)thor, "A", this.andIndexInto(indexName));
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        this.createNode((GraphDatabaseService)thor, "B1", this.andIndexInto(indexName));
        HighlyAvailableGraphDatabase odin = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        cluster.info(String.format("%n   ==== TAMPERING WITH " + thor + "'s CABLES ====%n", new Object[0]));
        ClusterManager.RepairKit thorRepairKit = cluster.fail(thor);
        cluster.await(ClusterManager.masterAvailable((HighlyAvailableGraphDatabase[])new HighlyAvailableGraphDatabase[]{thor}));
        this.createNode((GraphDatabaseService)odin, "B2", this.andIndexInto(indexName));
        Assert.assertTrue((boolean)odin.isMaster());
        Set odinLuceneFilesBefore = IteratorUtil.asSet(this.gatherLuceneFiles(odin, indexName));
        char prefix = 'C';
        while (!this.changed(odinLuceneFilesBefore, IteratorUtil.asSet(this.gatherLuceneFiles(odin, indexName)))) {
            this.createNodes((GraphDatabaseService)odin, String.valueOf(prefix), 10000, this.andIndexInto(indexName));
            cluster.force(new HighlyAvailableGraphDatabase[0]);
            prefix = (char)(prefix + '\u0001');
        }
        cluster.info(String.format("%n   ==== REPAIRING CABLES ====%n", new Object[0]));
        thorRepairKit.repair();
        while (thor.isMaster()) {
            Thread.sleep(100L);
        }
        cluster.await(ClusterManager.masterSeesAllSlavesAsAvailable());
        Assert.assertFalse((boolean)thor.isMaster());
        for (int i = 0; i < 3; ++i) {
            this.createNodes((GraphDatabaseService)odin, String.valueOf("" + i), 100000, this.andIndexInto(indexName));
            cluster.sync(new HighlyAvailableGraphDatabase[0]);
            cluster.force(new HighlyAvailableGraphDatabase[0]);
        }
        Assert.assertFalse((boolean)this.hasNode((GraphDatabaseService)thor, "B1"));
        Assert.assertTrue((boolean)this.hasNode((GraphDatabaseService)thor, "B2"));
        Assert.assertTrue((boolean)this.hasNode((GraphDatabaseService)thor, "C-0"));
        Assert.assertTrue((boolean)this.hasNode((GraphDatabaseService)thor, "0-0"));
        Assert.assertTrue((boolean)this.hasNode((GraphDatabaseService)odin, "0-0"));
    }

    private boolean changed(Set<File> before, Set<File> after) {
        return !before.containsAll(after) && !after.containsAll(before);
    }

    private Collection<File> gatherLuceneFiles(HighlyAvailableGraphDatabase db, String indexName) throws IOException {
        ArrayList<File> result = new ArrayList<File>();
        NeoStoreDataSource ds = (NeoStoreDataSource)db.getDependencyResolver().resolveDependency(NeoStoreDataSource.class);
        try (ResourceIterator files = ds.listStoreFiles(false);){
            while (files.hasNext()) {
                File file = (File)files.next();
                if (!file.getPath().contains(indexName)) continue;
                result.add(file);
            }
        }
        return result;
    }

    private Listener<Node> andIndexInto(final String indexName) {
        return new Listener<Node>(){

            public void receive(Node node) {
                Index index = node.getGraphDatabase().index().forNodes(indexName);
                for (String key : node.getPropertyKeys()) {
                    index.add((PropertyContainer)node, key, node.getProperty(key));
                }
            }
        };
    }

    private boolean hasNode(GraphDatabaseService db, String nodeName) {
        try (Transaction tx = db.beginTx();){
            for (Node node : GlobalGraphOperations.at((GraphDatabaseService)db).getAllNodes()) {
                if (!nodeName.equals(node.getProperty("name", null))) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNodeOffline(String storeDir, String name) {
        GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabase(storeDir);
        try {
            this.createNode(db, name, new Listener[0]);
        }
        finally {
            db.shutdown();
        }
    }

    private void createNode(GraphDatabaseService db, String name, Listener<Node> ... additional) {
        try (Transaction tx = db.beginTx();){
            Node node = this.createNamedNode(db, name);
            for (Listener<Node> listener : additional) {
                listener.receive((Object)node);
            }
            tx.success();
        }
    }

    private void createNodes(GraphDatabaseService db, String namePrefix, int count, Listener<Node> ... additional) {
        try (Transaction tx = db.beginTx();){
            for (int i = 0; i < count; ++i) {
                Node node = this.createNamedNode(db, namePrefix + "-" + i);
                for (Listener<Node> listener : additional) {
                    listener.receive((Object)node);
                }
            }
            tx.success();
        }
    }

    private Node createNamedNode(GraphDatabaseService db, String name) {
        Node node = db.createNode();
        node.setProperty("name", (Object)name);
        return node;
    }

    private long moveAwayToLookLikeOldBranchedDirectory() throws IOException {
        File dir = this.directory.directory();
        long timestamp = System.currentTimeMillis();
        File branchDir = new File(dir, "branched-" + timestamp);
        Assert.assertTrue((String)("create directory: " + branchDir), (boolean)branchDir.mkdirs());
        for (File file : (File[])SillyUtils.nonNull((Object)dir.listFiles())) {
            String fileName = file.getName();
            if (fileName.equals("messages.log") || file.getName().startsWith("branched-")) continue;
            Assert.assertTrue((boolean)FileUtils.renameFile((File)file, (File)new File(branchDir, file.getName())));
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startDbAndCreateNode() {
        GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabase(this.directory.absolutePath());
        try (Transaction tx = db.beginTx();){
            db.createNode();
            tx.success();
        }
        finally {
            db.shutdown();
        }
    }
}

