/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.io.PrintStream;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.ha.BeginTx;
import org.neo4j.ha.FinishTx;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.qa.tooling.DumpProcessInformationRule;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.ha.ClusterRule;

public class TransactionConstraintsIT {
    @Rule
    public final ClusterRule clusterRule = new ClusterRule(this.getClass()).config(HaSettings.pull_interval, "0");
    protected ClusterManager.ManagedCluster cluster;
    private static final String PROPERTY_KEY = "name";
    private static final String PROPERTY_VALUE = "yo";
    private static final String LABEL = "Person";
    @Rule
    public DumpProcessInformationRule dumpInfo = new DumpProcessInformationRule(1L, TimeUnit.MINUTES, new DumpProcessInformationRule.Dump[]{DumpProcessInformationRule.localVm((PrintStream)System.out)});

    @Before
    public void setup() throws Exception {
        this.cluster = this.clusterRule.startCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void startTxAsSlaveAndFinishItAfterHavingSwitchedToMasterShouldNotSucceed() throws Exception {
        HighlyAvailableGraphDatabase db = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        this.takeTheLeadInAnEventualMasterSwitch((GraphDatabaseService)db);
        Transaction tx = db.beginTx();
        try {
            db.createNode().setProperty(PROPERTY_KEY, (Object)"slave");
            tx.success();
        }
        finally {
            this.cluster.shutdown(this.cluster.getMaster());
            this.assertFinishGetsTransactionFailure(tx);
        }
        this.cluster.await(ClusterManager.masterAvailable((HighlyAvailableGraphDatabase[])new HighlyAvailableGraphDatabase[0]));
        Assert.assertEquals((Object)db, (Object)this.cluster.getMaster());
        this.awaitFullyOperational((GraphDatabaseService)db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void startTxAsSlaveAndFinishItAfterAnotherMasterBeingAvailableShouldNotSucceed() throws Exception {
        HighlyAvailableGraphDatabase db = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        Transaction tx = db.beginTx();
        try {
            db.createNode().setProperty(PROPERTY_KEY, (Object)"slave");
            tx.success();
        }
        catch (Throwable throwable) {
            HighlyAvailableGraphDatabase theOtherSlave = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[]{db});
            this.takeTheLeadInAnEventualMasterSwitch((GraphDatabaseService)theOtherSlave);
            this.cluster.shutdown(this.cluster.getMaster());
            this.assertFinishGetsTransactionFailure(tx);
            throw throwable;
        }
        HighlyAvailableGraphDatabase theOtherSlave = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[]{db});
        this.takeTheLeadInAnEventualMasterSwitch((GraphDatabaseService)theOtherSlave);
        this.cluster.shutdown(this.cluster.getMaster());
        this.assertFinishGetsTransactionFailure(tx);
        this.cluster.await(ClusterManager.masterAvailable((HighlyAvailableGraphDatabase[])new HighlyAvailableGraphDatabase[0]));
        Assert.assertFalse((boolean)db.isMaster());
        Assert.assertTrue((boolean)theOtherSlave.isMaster());
        this.awaitFullyOperational((GraphDatabaseService)db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void slaveShouldNotBeAbleToProduceAnInvalidTransaction() throws Exception {
        HighlyAvailableGraphDatabase aSlave = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        Node node = this.createMiniTree((GraphDatabaseService)aSlave);
        Transaction tx = aSlave.beginTx();
        try {
            node.delete();
            tx.success();
        }
        finally {
            this.assertFinishGetsTransactionFailure(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void masterShouldNotBeAbleToProduceAnInvalidTransaction() throws Exception {
        HighlyAvailableGraphDatabase master = this.cluster.getMaster();
        Node node = this.createMiniTree((GraphDatabaseService)master);
        Transaction tx = master.beginTx();
        try {
            node.delete();
            tx.success();
        }
        finally {
            this.assertFinishGetsTransactionFailure(tx);
        }
    }

    @Test
    public void writeOperationOnSlaveHasToBePerformedWithinTransaction() throws Exception {
        HighlyAvailableGraphDatabase aSlave = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        try {
            aSlave.createNode();
            Assert.fail((String)"Shouldn't be able to do a write operation outside a transaction");
        }
        catch (NotInTransactionException notInTransactionException) {
            // empty catch block
        }
    }

    @Test
    public void writeOperationOnMasterHasToBePerformedWithinTransaction() throws Exception {
        HighlyAvailableGraphDatabase master = this.cluster.getMaster();
        try {
            master.createNode();
            Assert.fail((String)"Shouldn't be able to do a write operation outside a transaction");
        }
        catch (NotInTransactionException notInTransactionException) {
            // empty catch block
        }
    }

    @Test
    public void slaveShouldNotBeAbleToModifyNodeDeletedOnMaster() throws Exception {
        HighlyAvailableGraphDatabase aSlave = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        Node node = this.createNode((GraphDatabaseService)aSlave, new String[0]);
        this.deleteNode(this.cluster.getMaster(), node.getId());
        try (Transaction slaveTransaction = aSlave.beginTx();){
            node.setProperty(PROPERTY_KEY, (Object)"test");
            Assert.fail((String)"Shouldn't be able to modify a node deleted on master");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void deadlockDetectionInvolvingTwoSlaves() throws Exception {
        HighlyAvailableGraphDatabase slave1 = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        this.deadlockDetectionBetween(slave1, this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[]{slave1}));
    }

    @Test
    public void deadlockDetectionInvolvingSlaveAndMaster() throws Exception {
        this.deadlockDetectionBetween(this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]), this.cluster.getMaster());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deadlockDetectionBetween(HighlyAvailableGraphDatabase slave1, HighlyAvailableGraphDatabase slave2) throws Exception {
        Node commonNode;
        try (Transaction tx = slave1.beginTx();){
            commonNode = slave1.createNode();
            tx.success();
        }
        OtherThreadExecutor thread2 = new OtherThreadExecutor("T2", (Object)slave2);
        Transaction tx1 = slave1.beginTx();
        Transaction tx2 = (Transaction)thread2.execute((OtherThreadExecutor.WorkerCommand)new BeginTx());
        tx1.acquireReadLock((PropertyContainer)commonNode);
        thread2.execute((OtherThreadExecutor.WorkerCommand)new AcquireReadLockOnReferenceNode(tx2, commonNode));
        Future writeLockFuture = thread2.executeDontWait((OtherThreadExecutor.WorkerCommand)new AcquireWriteLock(tx2, new Callable<Node>(){

            @Override
            public Node call() throws Exception {
                return commonNode;
            }
        }));
        for (int i = 0; i < 10; ++i) {
            thread2.waitUntilThreadState(new Thread.State[]{Thread.State.TIMED_WAITING, Thread.State.WAITING});
            Thread.sleep(2L);
        }
        try {
            tx1.acquireWriteLock((PropertyContainer)commonNode);
            writeLockFuture.get();
            Assert.fail((String)"Deadlock exception should have been thrown");
        }
        catch (DeadlockDetectedException e) {
        }
        finally {
            tx1.close();
        }
        thread2.execute((OtherThreadExecutor.WorkerCommand)new FinishTx(tx2, true));
        thread2.close();
    }

    @Test
    public void createdSchemaConstraintsMustBeRetainedAcrossModeSwitches() throws Throwable {
        HighlyAvailableGraphDatabase master = this.cluster.getMaster();
        this.createConstraint(master, LABEL, PROPERTY_KEY);
        this.createNode((GraphDatabaseService)master, LABEL).getId();
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        ClusterManager.RepairKit originalMasterRepairKit = this.cluster.fail(master);
        this.cluster.await(ClusterManager.masterAvailable((HighlyAvailableGraphDatabase[])new HighlyAvailableGraphDatabase[]{master}));
        this.takeTheLeadInAnEventualMasterSwitch((GraphDatabaseService)this.cluster.getMaster());
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        Thread.sleep(30000L);
        originalMasterRepairKit.repair();
        this.cluster.await(ClusterManager.allSeesAllAsAvailable());
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        this.cluster.stop();
        for (HighlyAvailableGraphDatabase instance : this.cluster.getAllMembers()) {
            GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabase(instance.getStoreDir());
            Label label = DynamicLabel.label((String)LABEL);
            try (Transaction tx = db.beginTx();){
                Node node = db.createNode(new Label[]{label});
                node.setProperty(PROPERTY_KEY, (Object)"yo1");
                tx.success();
            }
            tx = db.beginTx();
            var8_8 = null;
            try {
                ConstraintDefinition constraint = (ConstraintDefinition)IteratorUtil.single((Iterable)db.schema().getConstraints(label));
                constraint.drop();
                tx.success();
            }
            catch (Throwable throwable) {
                var8_8 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var8_8 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable x2) {
                            var8_8.addSuppressed(x2);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
            db.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="Known issue where locks acquired from Transaction#acquireXXXLock() methods doesn't get properly released when calling Lock#release() method")
    @Test
    public void manuallyAcquireAndReleaseTransactionLock() throws Exception {
        HighlyAvailableGraphDatabase master = this.cluster.getMaster();
        OtherThreadExecutor masterWorker = new OtherThreadExecutor("master worker", (Object)master);
        final Node node = this.createNode((GraphDatabaseService)master, new String[0]);
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        HighlyAvailableGraphDatabase slave = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        try (Transaction slaveTx = slave.beginTx();){
            Lock lock = slaveTx.acquireWriteLock((PropertyContainer)slave.getNodeById(node.getId()));
            lock.release();
            Transaction masterTx = (Transaction)masterWorker.execute((OtherThreadExecutor.WorkerCommand)new BeginTx());
            masterWorker.execute((OtherThreadExecutor.WorkerCommand)new AcquireWriteLock(masterTx, new Callable<Node>(){

                @Override
                public Node call() throws Exception {
                    return node;
                }
            }), 1L, TimeUnit.SECONDS);
        }
        finally {
            masterWorker.close();
        }
    }

    private void takeTheLeadInAnEventualMasterSwitch(GraphDatabaseService db) {
        this.createNode(db, new String[0]);
    }

    private Node createNode(GraphDatabaseService db, String ... labels) {
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            for (String label : labels) {
                node.addLabel(DynamicLabel.label((String)label));
            }
            node.setProperty(PROPERTY_KEY, (Object)PROPERTY_VALUE);
            tx.success();
            Node node2 = node;
            return node2;
        }
    }

    private void createConstraint(HighlyAvailableGraphDatabase db, String label, String propertyName) {
        try (Transaction tx = db.beginTx();){
            db.schema().constraintFor(DynamicLabel.label((String)label)).assertPropertyIsUnique(propertyName).create();
            tx.success();
        }
    }

    private Node createMiniTree(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            Node root = db.createNode();
            root.createRelationshipTo(db.createNode(), (RelationshipType)MyRelTypes.TEST);
            root.createRelationshipTo(db.createNode(), (RelationshipType)MyRelTypes.TEST);
            tx.success();
            Node node = root;
            return node;
        }
    }

    private void deleteNode(HighlyAvailableGraphDatabase db, long id) {
        try (Transaction tx = db.beginTx();){
            db.getNodeById(id).delete();
            tx.success();
        }
    }

    private void assertFinishGetsTransactionFailure(Transaction tx) {
        try {
            tx.close();
            Assert.fail((String)"Transaction shouldn't be able to finish");
        }
        catch (TransactionFailureException transactionFailureException) {
            // empty catch block
        }
    }

    private void awaitFullyOperational(GraphDatabaseService db) throws InterruptedException {
        long endTime = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(1L);
        int i = 0;
        while (System.currentTimeMillis() < endTime) {
            try {
                this.doABogusTransaction(db);
                break;
            }
            catch (Exception e) {
                if (i > 0 && i % 10 == 0) {
                    e.printStackTrace();
                }
                Thread.sleep(1000L);
                ++i;
            }
        }
    }

    private void doABogusTransaction(GraphDatabaseService db) throws Exception {
        try (Transaction ignore = db.beginTx();){
            db.createNode();
        }
    }

    private static class AcquireWriteLock
    implements OtherThreadExecutor.WorkerCommand<HighlyAvailableGraphDatabase, Lock> {
        private final Transaction tx;
        private final Callable<Node> callable;

        public AcquireWriteLock(Transaction tx, Callable<Node> callable) {
            this.tx = tx;
            this.callable = callable;
        }

        public Lock doWork(HighlyAvailableGraphDatabase state) throws Exception {
            return this.tx.acquireWriteLock((PropertyContainer)this.callable.call());
        }
    }

    private static class AcquireReadLockOnReferenceNode
    implements OtherThreadExecutor.WorkerCommand<HighlyAvailableGraphDatabase, Lock> {
        private final Transaction tx;
        private final Node commonNode;

        public AcquireReadLockOnReferenceNode(Transaction tx, Node commonNode) {
            this.tx = tx;
            this.commonNode = commonNode;
        }

        public Lock doWork(HighlyAvailableGraphDatabase state) {
            return this.tx.acquireReadLock((PropertyContainer)this.commonNode);
        }
    }
}

