/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.com.RequestContext;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.com.master.ConversationManager;
import org.neo4j.kernel.ha.com.master.HandshakeResult;
import org.neo4j.kernel.ha.com.master.InvalidEpochException;
import org.neo4j.kernel.ha.com.master.MasterImpl;
import org.neo4j.kernel.ha.com.master.MasterImplTest;
import org.neo4j.kernel.ha.id.IdAllocation;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.store.id.IdRange;

public class MasterEpochTest {
    @Test
    public void shouldFailSubsequentRequestsAfterAllocateIdsAfterMasterSwitch() throws Throwable {
        MasterImpl.SPI spi = MasterImplTest.mockedSpi();
        IdAllocation servedIdAllocation = this.idAllocation(0L, 999);
        Mockito.when((Object)spi.allocateIds((IdType)Matchers.any(IdType.class))).thenReturn((Object)servedIdAllocation);
        Mockito.when((Object)spi.getTransactionChecksum(Matchers.anyLong())).thenReturn((Object)10L);
        StoreId storeId = new StoreId();
        MasterImpl master = new MasterImpl(spi, (ConversationManager)Mockito.mock(ConversationManager.class), (MasterImpl.Monitor)Mockito.mock(MasterImpl.Monitor.class), new Config(MapUtil.stringMap((String[])new String[]{ClusterSettings.server_id.name(), "1"})));
        HandshakeResult handshake = (HandshakeResult)master.handshake(1L, storeId).response();
        master.start();
        IdAllocation idAllocation = (IdAllocation)master.allocateIds(this.context(handshake.epoch()), IdType.NODE).response();
        Assert.assertEquals((long)servedIdAllocation.getHighestIdInUse(), (long)idAllocation.getHighestIdInUse());
        try {
            master.allocateIds(this.context(handshake.epoch() + 1L), IdType.NODE);
            Assert.fail((String)"Should fail with invalid epoch");
        }
        catch (InvalidEpochException e) {
            // empty catch block
        }
    }

    private IdAllocation idAllocation(long from, int length) {
        return new IdAllocation(new IdRange(PrimitiveLongCollections.EMPTY_LONG_ARRAY, from, length), from + (long)length, 0L);
    }

    private RequestContext context(long epoch) {
        return new RequestContext(epoch, 0, 0, 0L, 0L);
    }
}

