/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.Collections;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.kernel.ha.SlaveTransactionCommitProcess;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;

public class SlaveTransactionCommitProcessTest {
    @Test
    public void shouldForwardLockIdentifierToMaster() throws Exception {
        Master master = (Master)Mockito.mock(Master.class);
        RequestContextFactory reqFactory = (RequestContextFactory)Mockito.mock(RequestContextFactory.class);
        Response response = (Response)Mockito.mock(Response.class);
        Mockito.when((Object)response.response()).thenReturn((Object)1L);
        Mockito.when((Object)master.commit((RequestContext)Matchers.any(RequestContext.class), (TransactionRepresentation)Matchers.any(TransactionRepresentation.class))).thenReturn((Object)response);
        SlaveTransactionCommitProcess process = new SlaveTransactionCommitProcess(master, reqFactory);
        PhysicalTransactionRepresentation tx = new PhysicalTransactionRepresentation(Collections.emptyList());
        tx.setHeader(new byte[0], 1, 1, 1L, 1L, 1L, 1337);
        process.commit((TransactionRepresentation)tx, new LockGroup(), CommitEvent.NULL, TransactionApplicationMode.INTERNAL);
        ((RequestContextFactory)Mockito.verify((Object)reqFactory)).newRequestContext(1337);
    }
}

