/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.LastUpdateTime;
import org.neo4j.kernel.ha.SlaveUpdatePuller;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.InvalidEpochException;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.slave.InvalidEpochExceptionHandler;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.CleanupRule;

public class SlaveUpdatePullerTest {
    private final InstanceId instanceId = new InstanceId(1);
    private final Config config = (Config)Mockito.mock(Config.class);
    private final AvailabilityGuard availabilityGuard = (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class);
    private final LastUpdateTime lastUpdateTime = (LastUpdateTime)Mockito.mock(LastUpdateTime.class);
    private final Master master = (Master)Mockito.mock(Master.class);
    private final AssertableLogProvider logProvider = new AssertableLogProvider();
    private final RequestContextFactory requestContextFactory = (RequestContextFactory)Mockito.mock(RequestContextFactory.class);
    private final InvalidEpochExceptionHandler invalidEpochHandler = (InvalidEpochExceptionHandler)Mockito.mock(InvalidEpochExceptionHandler.class);
    private final SlaveUpdatePuller updatePuller = new SlaveUpdatePuller(this.requestContextFactory, this.master, this.lastUpdateTime, (LogProvider)this.logProvider, this.instanceId, this.availabilityGuard, this.invalidEpochHandler);
    @Rule
    public final CleanupRule cleanup = new CleanupRule();

    @Before
    public void setup() throws Throwable {
        Mockito.when((Object)this.config.get(HaSettings.pull_interval)).thenReturn((Object)1000L);
        Mockito.when((Object)this.config.get(ClusterSettings.server_id)).thenReturn((Object)this.instanceId);
        Mockito.when((Object)this.availabilityGuard.isAvailable(org.mockito.Matchers.anyLong())).thenReturn((Object)true);
        this.updatePuller.init();
        this.updatePuller.start();
    }

    @Test
    public void shouldStopPullingAfterStop() throws Throwable {
        this.updatePuller.pullUpdates();
        ((LastUpdateTime)Mockito.verify((Object)this.lastUpdateTime, (VerificationMode)Mockito.times((int)1))).setLastUpdateTime(org.mockito.Matchers.anyLong());
        ((AvailabilityGuard)Mockito.verify((Object)this.availabilityGuard, (VerificationMode)Mockito.times((int)1))).isAvailable(org.mockito.Matchers.anyLong());
        ((Master)Mockito.verify((Object)this.master, (VerificationMode)Mockito.times((int)1))).pullUpdates((RequestContext)org.mockito.Matchers.any());
        this.updatePuller.shutdown();
        this.updatePuller.pullUpdates();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.lastUpdateTime, this.availabilityGuard});
    }

    @Test
    public void keepPullingUpdatesOnConsecutiveCalls() throws Throwable {
        this.updatePuller.pullUpdates();
        ((LastUpdateTime)Mockito.verify((Object)this.lastUpdateTime, (VerificationMode)Mockito.times((int)1))).setLastUpdateTime(org.mockito.Matchers.anyLong());
        ((AvailabilityGuard)Mockito.verify((Object)this.availabilityGuard, (VerificationMode)Mockito.times((int)1))).isAvailable(org.mockito.Matchers.anyLong());
        ((Master)Mockito.verify((Object)this.master, (VerificationMode)Mockito.times((int)1))).pullUpdates((RequestContext)org.mockito.Matchers.any());
        this.updatePuller.pullUpdates();
        ((LastUpdateTime)Mockito.verify((Object)this.lastUpdateTime, (VerificationMode)Mockito.times((int)2))).setLastUpdateTime(org.mockito.Matchers.anyLong());
        ((AvailabilityGuard)Mockito.verify((Object)this.availabilityGuard, (VerificationMode)Mockito.times((int)2))).isAvailable(org.mockito.Matchers.anyLong());
        ((Master)Mockito.verify((Object)this.master, (VerificationMode)Mockito.times((int)2))).pullUpdates((RequestContext)org.mockito.Matchers.any());
    }

    @Test
    public void falseOnTryPullUpdatesOnInactivePuller() throws Throwable {
        this.updatePuller.shutdown();
        boolean result = this.updatePuller.tryPullUpdates();
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void shouldThrowIfPullerInitiallyInactiveStrict() throws Throwable {
        UpdatePuller.Condition condition = (UpdatePuller.Condition)Mockito.mock(UpdatePuller.Condition.class);
        this.updatePuller.shutdown();
        try {
            this.updatePuller.pullUpdates(condition, true);
            Assert.fail((String)"Should have thrown");
        }
        catch (IllegalStateException e) {
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{condition});
        }
    }

    @Test
    public void shouldThrowIfPullerBecomesInactiveWhileWaitingStrict() throws Exception {
        UpdatePuller.Condition condition = (UpdatePuller.Condition)Mockito.mock(UpdatePuller.Condition.class);
        Mockito.when((Object)condition.evaluate(org.mockito.Matchers.anyInt(), org.mockito.Matchers.anyInt())).thenAnswer((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                SlaveUpdatePullerTest.this.updatePuller.shutdown();
                return false;
            }
        });
        try {
            this.updatePuller.pullUpdates(condition, true);
            Assert.fail((String)"Should have thrown");
        }
        catch (IllegalStateException e) {
            ((UpdatePuller.Condition)Mockito.verify((Object)condition)).evaluate(org.mockito.Matchers.anyInt(), org.mockito.Matchers.anyInt());
        }
    }

    @Test
    public void shouldHandleInvalidEpochByNotifyingItsHandler() throws Exception {
        ((Master)Mockito.doThrow(InvalidEpochException.class).when((Object)this.master)).pullUpdates((RequestContext)org.mockito.Matchers.any(RequestContext.class));
        this.updatePuller.pullUpdates();
        ((InvalidEpochExceptionHandler)Mockito.verify((Object)this.invalidEpochHandler)).handle();
    }

    @Test
    public void shouldCopeWithHardExceptionsLikeOutOfMemory() throws Exception {
        OutOfMemoryError oom = new OutOfMemoryError();
        Mockito.when((Object)this.master.pullUpdates((RequestContext)org.mockito.Matchers.any(RequestContext.class))).thenThrow(new Throwable[]{oom}).thenReturn((Object)Response.EMPTY);
        this.updatePuller.pullUpdates();
        this.logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(SlaveUpdatePuller.class).error(Matchers.any(String.class), Matchers.sameInstance((Object)oom))});
        this.updatePuller.pullUpdates();
    }
}

