/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.cluster.InstanceId;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.LastUpdateTime;
import org.neo4j.kernel.ha.PullerFactory;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.ha.UpdatePullerModeSwitcher;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberStateMachine;
import org.neo4j.kernel.ha.cluster.ModeSwitcherNotifier;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.slave.InvalidEpochExceptionHandler;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.LogProvider;

public class UpdatePullerModeSwitcherTest {
    private UpdatePullerModeSwitcher modeSwitcher;

    @Before
    public void setUp() {
        ModeSwitcherNotifier switcherNotifier = (ModeSwitcherNotifier)Mockito.mock(ModeSwitcherNotifier.class);
        DelegateInvocationHandler invocationHandler = (DelegateInvocationHandler)Mockito.mock(DelegateInvocationHandler.class);
        PullerFactory pullersFactory = new PullerFactory((RequestContextFactory)Mockito.mock(RequestContextFactory.class), (Master)Mockito.mock(Master.class), (LastUpdateTime)Mockito.mock(LastUpdateTime.class), (LogProvider)Mockito.mock(LogProvider.class), (InstanceId)Mockito.mock(InstanceId.class), (InvalidEpochExceptionHandler)Mockito.mock(InvalidEpochExceptionHandler.class), 42L, (JobScheduler)Mockito.mock(JobScheduler.class), (DependencyResolver)Mockito.mock(DependencyResolver.class), (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class), (HighAvailabilityMemberStateMachine)Mockito.mock(HighAvailabilityMemberStateMachine.class));
        this.modeSwitcher = new UpdatePullerModeSwitcher(switcherNotifier, invocationHandler, pullersFactory);
    }

    @Test
    public void masterUpdatePuller() {
        LifeSupport life = (LifeSupport)Mockito.mock(LifeSupport.class);
        UpdatePuller masterPuller = this.modeSwitcher.getMasterImpl(life);
        Assert.assertEquals((Object)UpdatePuller.NONE, (Object)masterPuller);
        Mockito.verifyZeroInteractions((Object[])new Object[]{life});
    }

    @Test
    public void slaveUpdatePuller() {
        LifeSupport life = (LifeSupport)Mockito.spy((Object)new LifeSupport());
        UpdatePuller slavePuller = this.modeSwitcher.getSlaveImpl(life);
        Assert.assertNotNull((Object)slavePuller);
        ((LifeSupport)Mockito.verify((Object)life, (VerificationMode)Mockito.times((int)1))).add((Lifecycle)slavePuller);
    }
}

