/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.member.ClusterMemberAvailability;
import org.neo4j.cluster.member.ClusterMemberEvents;
import org.neo4j.cluster.member.ClusterMemberListener;
import org.neo4j.cluster.protocol.election.Election;
import org.neo4j.com.ResourceReleaser;
import org.neo4j.com.Response;
import org.neo4j.com.storecopy.StoreCopyClient;
import org.neo4j.function.Function;
import org.neo4j.function.Suppliers;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.MasterClient214;
import org.neo4j.kernel.ha.PullerFactory;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.ha.cluster.AbstractModeSwitcher;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberChangeEvent;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberContext;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberListener;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberStateMachine;
import org.neo4j.kernel.ha.cluster.HighAvailabilityModeSwitcher;
import org.neo4j.kernel.ha.cluster.HighAvailabilityModeSwitcherTest;
import org.neo4j.kernel.ha.cluster.ModeSwitcherNotifier;
import org.neo4j.kernel.ha.cluster.SimpleHighAvailabilityMemberContext;
import org.neo4j.kernel.ha.cluster.SwitchToMaster;
import org.neo4j.kernel.ha.cluster.SwitchToSlave;
import org.neo4j.kernel.ha.cluster.member.ClusterMember;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.HandshakeResult;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.master.Slave;
import org.neo4j.kernel.ha.com.slave.MasterClient;
import org.neo4j.kernel.ha.com.slave.MasterClientResolver;
import org.neo4j.kernel.ha.com.slave.SlaveServer;
import org.neo4j.kernel.ha.id.HaIdGeneratorFactory;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.transaction.DeadSimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.TransactionCounters;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class HighAvailabilityMemberStateMachineTest {
    @Test
    public void shouldStartFromPending() throws Exception {
        HighAvailabilityMemberContext context = (HighAvailabilityMemberContext)Mockito.mock(HighAvailabilityMemberContext.class);
        AvailabilityGuard guard = (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class);
        ClusterMembers members = (ClusterMembers)Mockito.mock(ClusterMembers.class);
        ClusterMemberEvents events = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        Election election = (Election)Mockito.mock(Election.class);
        HighAvailabilityMemberStateMachine toTest = new HighAvailabilityMemberStateMachine(context, guard, members, events, election, (LogProvider)NullLogProvider.getInstance());
        Assert.assertThat((Object)toTest.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.PENDING));
    }

    @Test
    public void shouldMoveToToMasterFromPendingOnMasterElectedForItself() throws Throwable {
        InstanceId me = new InstanceId(1);
        SimpleHighAvailabilityMemberContext context = new SimpleHighAvailabilityMemberContext(me, false);
        AvailabilityGuard guard = (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class);
        ClusterMembers members = (ClusterMembers)Mockito.mock(ClusterMembers.class);
        ClusterMemberEvents events = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        final HashSet listener = new HashSet();
        ((ClusterMemberEvents)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                listener.add((ClusterMemberListener)invocation.getArguments()[0]);
                return null;
            }
        }).when((Object)events)).addClusterMemberListener((ClusterMemberListener)Matchers.any());
        Election election = (Election)Mockito.mock(Election.class);
        HighAvailabilityMemberStateMachine toTest = new HighAvailabilityMemberStateMachine((HighAvailabilityMemberContext)context, guard, members, events, election, (LogProvider)NullLogProvider.getInstance());
        toTest.init();
        ClusterMemberListener theListener = (ClusterMemberListener)listener.iterator().next();
        theListener.coordinatorIsElected(me);
        Assert.assertThat((Object)listener.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)toTest.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.TO_MASTER));
    }

    @Test
    public void shouldRemainToPendingOnMasterElectedForSomeoneElse() throws Throwable {
        InstanceId me = new InstanceId(1);
        SimpleHighAvailabilityMemberContext context = new SimpleHighAvailabilityMemberContext(me, false);
        AvailabilityGuard guard = (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class);
        ClusterMembers members = (ClusterMembers)Mockito.mock(ClusterMembers.class);
        ClusterMemberEvents events = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        final HashSet listener = new HashSet();
        ((ClusterMemberEvents)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                listener.add((ClusterMemberListener)invocation.getArguments()[0]);
                return null;
            }
        }).when((Object)events)).addClusterMemberListener((ClusterMemberListener)Matchers.any());
        Election election = (Election)Mockito.mock(Election.class);
        HighAvailabilityMemberStateMachine toTest = new HighAvailabilityMemberStateMachine((HighAvailabilityMemberContext)context, guard, members, events, election, (LogProvider)NullLogProvider.getInstance());
        toTest.init();
        ClusterMemberListener theListener = (ClusterMemberListener)listener.iterator().next();
        theListener.coordinatorIsElected(new InstanceId(2));
        Assert.assertThat((Object)listener.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)toTest.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.PENDING));
    }

    @Test
    public void shouldSwitchToToSlaveOnMasterAvailableForSomeoneElse() throws Throwable {
        InstanceId me = new InstanceId(1);
        SimpleHighAvailabilityMemberContext context = new SimpleHighAvailabilityMemberContext(me, false);
        AvailabilityGuard guard = (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class);
        ClusterMembers members = (ClusterMembers)Mockito.mock(ClusterMembers.class);
        ClusterMemberEvents events = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        final HashSet listener = new HashSet();
        ((ClusterMemberEvents)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                listener.add((ClusterMemberListener)invocation.getArguments()[0]);
                return null;
            }
        }).when((Object)events)).addClusterMemberListener((ClusterMemberListener)Matchers.any());
        Election election = (Election)Mockito.mock(Election.class);
        HighAvailabilityMemberStateMachine toTest = new HighAvailabilityMemberStateMachine((HighAvailabilityMemberContext)context, guard, members, events, election, (LogProvider)NullLogProvider.getInstance());
        toTest.init();
        ClusterMemberListener theListener = (ClusterMemberListener)listener.iterator().next();
        HAStateChangeListener probe = new HAStateChangeListener();
        toTest.addHighAvailabilityMemberListener((HighAvailabilityMemberListener)probe);
        theListener.memberIsAvailable("master", new InstanceId(2), URI.create("ha://whatever"), StoreId.DEFAULT);
        Assert.assertThat((Object)listener.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)toTest.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.TO_SLAVE));
        Assert.assertThat((Object)probe.masterIsAvailable, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void whenInMasterStateLosingQuorumShouldPutInPending() throws Throwable {
        InstanceId me = new InstanceId(1);
        InstanceId other = new InstanceId(2);
        SimpleHighAvailabilityMemberContext context = new SimpleHighAvailabilityMemberContext(me, false);
        AvailabilityGuard guard = (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class);
        ClusterMembers members = (ClusterMembers)Mockito.mock(ClusterMembers.class);
        ClusterMemberEvents events = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        LinkedList<ClusterMember> membersList = new LinkedList<ClusterMember>();
        ClusterMember otherMemberMock = (ClusterMember)Mockito.mock(ClusterMember.class);
        Mockito.when((Object)otherMemberMock.getInstanceId()).thenReturn((Object)other);
        Mockito.when((Object)otherMemberMock.isAlive()).thenReturn((Object)false);
        membersList.add(otherMemberMock);
        membersList.add(new ClusterMember(me));
        Mockito.when((Object)members.getMembers()).thenReturn(membersList);
        final HashSet listener = new HashSet();
        ((ClusterMemberEvents)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                listener.add((ClusterMemberListener)invocation.getArguments()[0]);
                return null;
            }
        }).when((Object)events)).addClusterMemberListener((ClusterMemberListener)Matchers.any());
        Election election = (Election)Mockito.mock(Election.class);
        HighAvailabilityMemberStateMachine toTest = new HighAvailabilityMemberStateMachine((HighAvailabilityMemberContext)context, guard, members, events, election, (LogProvider)NullLogProvider.getInstance());
        toTest.init();
        ClusterMemberListener theListener = (ClusterMemberListener)listener.iterator().next();
        HAStateChangeListener probe = new HAStateChangeListener();
        toTest.addHighAvailabilityMemberListener((HighAvailabilityMemberListener)probe);
        theListener.coordinatorIsElected(me);
        theListener.memberIsAvailable("master", me, URI.create("ha://whatever"), StoreId.DEFAULT);
        Assert.assertThat((Object)toTest.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.MASTER));
        theListener.memberIsFailed(new InstanceId(2));
        Assert.assertThat((Object)listener.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)toTest.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.PENDING));
        Assert.assertThat((Object)probe.instanceStops, (Matcher)CoreMatchers.is((Object)true));
        ((AvailabilityGuard)Mockito.verify((Object)guard, (VerificationMode)Mockito.times((int)2))).require((AvailabilityGuard.AvailabilityRequirement)Matchers.any(AvailabilityGuard.AvailabilityRequirement.class));
    }

    @Test
    public void whenInSlaveStateLosingQuorumShouldPutInPending() throws Throwable {
        InstanceId me = new InstanceId(1);
        InstanceId other = new InstanceId(2);
        SimpleHighAvailabilityMemberContext context = new SimpleHighAvailabilityMemberContext(me, false);
        AvailabilityGuard guard = (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class);
        ClusterMembers members = (ClusterMembers)Mockito.mock(ClusterMembers.class);
        ClusterMemberEvents events = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        LinkedList<ClusterMember> membersList = new LinkedList<ClusterMember>();
        ClusterMember otherMemberMock = (ClusterMember)Mockito.mock(ClusterMember.class);
        Mockito.when((Object)otherMemberMock.getInstanceId()).thenReturn((Object)other);
        Mockito.when((Object)otherMemberMock.isAlive()).thenReturn((Object)false);
        membersList.add(otherMemberMock);
        membersList.add(new ClusterMember(me));
        Mockito.when((Object)members.getMembers()).thenReturn(membersList);
        final HashSet listener = new HashSet();
        ((ClusterMemberEvents)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                listener.add((ClusterMemberListener)invocation.getArguments()[0]);
                return null;
            }
        }).when((Object)events)).addClusterMemberListener((ClusterMemberListener)Matchers.any());
        Election election = (Election)Mockito.mock(Election.class);
        HighAvailabilityMemberStateMachine toTest = new HighAvailabilityMemberStateMachine((HighAvailabilityMemberContext)context, guard, members, events, election, (LogProvider)NullLogProvider.getInstance());
        toTest.init();
        ClusterMemberListener theListener = (ClusterMemberListener)listener.iterator().next();
        HAStateChangeListener probe = new HAStateChangeListener();
        toTest.addHighAvailabilityMemberListener((HighAvailabilityMemberListener)probe);
        theListener.memberIsAvailable("master", other, URI.create("ha://whatever"), StoreId.DEFAULT);
        theListener.memberIsAvailable("slave", me, URI.create("ha://whatever2"), StoreId.DEFAULT);
        Assert.assertThat((Object)toTest.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.SLAVE));
        theListener.memberIsFailed(new InstanceId(2));
        Assert.assertThat((Object)listener.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)toTest.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.PENDING));
        Assert.assertThat((Object)probe.instanceStops, (Matcher)CoreMatchers.is((Object)true));
        ((AvailabilityGuard)Mockito.verify((Object)guard, (VerificationMode)Mockito.times((int)2))).require((AvailabilityGuard.AvailabilityRequirement)Matchers.any(AvailabilityGuard.AvailabilityRequirement.class));
    }

    @Test
    public void whenInToMasterStateLosingQuorumShouldPutInPending() throws Throwable {
        InstanceId me = new InstanceId(1);
        InstanceId other = new InstanceId(2);
        SimpleHighAvailabilityMemberContext context = new SimpleHighAvailabilityMemberContext(me, false);
        AvailabilityGuard guard = (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class);
        ClusterMembers members = (ClusterMembers)Mockito.mock(ClusterMembers.class);
        ClusterMemberEvents events = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        LinkedList<ClusterMember> membersList = new LinkedList<ClusterMember>();
        ClusterMember otherMemberMock = (ClusterMember)Mockito.mock(ClusterMember.class);
        Mockito.when((Object)otherMemberMock.getInstanceId()).thenReturn((Object)other);
        Mockito.when((Object)otherMemberMock.isAlive()).thenReturn((Object)false);
        membersList.add(otherMemberMock);
        membersList.add(new ClusterMember(me));
        Mockito.when((Object)members.getMembers()).thenReturn(membersList);
        final HashSet listener = new HashSet();
        ((ClusterMemberEvents)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                listener.add((ClusterMemberListener)invocation.getArguments()[0]);
                return null;
            }
        }).when((Object)events)).addClusterMemberListener((ClusterMemberListener)Matchers.any());
        Election election = (Election)Mockito.mock(Election.class);
        HighAvailabilityMemberStateMachine toTest = new HighAvailabilityMemberStateMachine((HighAvailabilityMemberContext)context, guard, members, events, election, (LogProvider)NullLogProvider.getInstance());
        toTest.init();
        ClusterMemberListener theListener = (ClusterMemberListener)listener.iterator().next();
        HAStateChangeListener probe = new HAStateChangeListener();
        toTest.addHighAvailabilityMemberListener((HighAvailabilityMemberListener)probe);
        theListener.coordinatorIsElected(me);
        Assert.assertThat((Object)toTest.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.TO_MASTER));
        theListener.memberIsFailed(new InstanceId(2));
        Assert.assertThat((Object)listener.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)toTest.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.PENDING));
        Assert.assertThat((Object)probe.instanceStops, (Matcher)CoreMatchers.is((Object)true));
        ((AvailabilityGuard)Mockito.verify((Object)guard, (VerificationMode)Mockito.times((int)1))).require((AvailabilityGuard.AvailabilityRequirement)Matchers.any(AvailabilityGuard.AvailabilityRequirement.class));
    }

    @Test
    public void whenInToSlaveStateLosingQuorumShouldPutInPending() throws Throwable {
        InstanceId me = new InstanceId(1);
        InstanceId other = new InstanceId(2);
        SimpleHighAvailabilityMemberContext context = new SimpleHighAvailabilityMemberContext(me, false);
        AvailabilityGuard guard = (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class);
        ClusterMembers members = (ClusterMembers)Mockito.mock(ClusterMembers.class);
        ClusterMemberEvents events = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        LinkedList<ClusterMember> membersList = new LinkedList<ClusterMember>();
        ClusterMember otherMemberMock = (ClusterMember)Mockito.mock(ClusterMember.class);
        Mockito.when((Object)otherMemberMock.getInstanceId()).thenReturn((Object)other);
        Mockito.when((Object)otherMemberMock.isAlive()).thenReturn((Object)false);
        membersList.add(otherMemberMock);
        membersList.add(new ClusterMember(me));
        Mockito.when((Object)members.getMembers()).thenReturn(membersList);
        final HashSet listener = new HashSet();
        ((ClusterMemberEvents)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                listener.add((ClusterMemberListener)invocation.getArguments()[0]);
                return null;
            }
        }).when((Object)events)).addClusterMemberListener((ClusterMemberListener)Matchers.any());
        Election election = (Election)Mockito.mock(Election.class);
        HighAvailabilityMemberStateMachine toTest = new HighAvailabilityMemberStateMachine((HighAvailabilityMemberContext)context, guard, members, events, election, (LogProvider)NullLogProvider.getInstance());
        toTest.init();
        ClusterMemberListener theListener = (ClusterMemberListener)listener.iterator().next();
        HAStateChangeListener probe = new HAStateChangeListener();
        toTest.addHighAvailabilityMemberListener((HighAvailabilityMemberListener)probe);
        theListener.memberIsAvailable("master", other, URI.create("ha://whatever"), StoreId.DEFAULT);
        Assert.assertThat((Object)toTest.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.TO_SLAVE));
        theListener.memberIsFailed(new InstanceId(2));
        Assert.assertThat((Object)listener.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)toTest.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.PENDING));
        Assert.assertThat((Object)probe.instanceStops, (Matcher)CoreMatchers.is((Object)true));
        ((AvailabilityGuard)Mockito.verify((Object)guard, (VerificationMode)Mockito.times((int)1))).require((AvailabilityGuard.AvailabilityRequirement)Matchers.any(AvailabilityGuard.AvailabilityRequirement.class));
    }

    @Test
    public void whenSlaveOnlyIsElectedStayInPending() throws Throwable {
        InstanceId me = new InstanceId(1);
        SimpleHighAvailabilityMemberContext context = new SimpleHighAvailabilityMemberContext(me, true);
        AvailabilityGuard guard = (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class);
        ClusterMembers members = (ClusterMembers)Mockito.mock(ClusterMembers.class);
        ClusterMemberEvents events = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        final HashSet listener = new HashSet();
        ((ClusterMemberEvents)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                listener.add((ClusterMemberListener)invocation.getArguments()[0]);
                return null;
            }
        }).when((Object)events)).addClusterMemberListener((ClusterMemberListener)Matchers.any());
        Election election = (Election)Mockito.mock(Election.class);
        HighAvailabilityMemberStateMachine toTest = new HighAvailabilityMemberStateMachine((HighAvailabilityMemberContext)context, guard, members, events, election, (LogProvider)NullLogProvider.getInstance());
        toTest.init();
        ClusterMemberListener theListener = (ClusterMemberListener)listener.iterator().next();
        theListener.coordinatorIsElected(me);
        Assert.assertThat((Object)toTest.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.PENDING));
    }

    @Test
    public void whenHAModeSwitcherSwitchesToSlaveTheOtherModeSwitcherDoNotGetTheOldMasterClient() throws Throwable {
        InstanceId me = new InstanceId(1);
        StoreId storeId = new StoreId();
        HighAvailabilityMemberContext context = (HighAvailabilityMemberContext)Mockito.mock(HighAvailabilityMemberContext.class);
        Mockito.when((Object)context.getMyId()).thenReturn((Object)me);
        AvailabilityGuard guard = (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class);
        ClusterMembers members = (ClusterMembers)Mockito.mock(ClusterMembers.class);
        ClusterMember masterMember = (ClusterMember)Mockito.mock(ClusterMember.class);
        Mockito.when((Object)masterMember.getHARole()).thenReturn((Object)"master");
        Mockito.when((Object)masterMember.hasRole("master")).thenReturn((Object)true);
        Mockito.when((Object)masterMember.getInstanceId()).thenReturn((Object)new InstanceId(2));
        Mockito.when((Object)masterMember.getStoreId()).thenReturn((Object)storeId);
        Mockito.when((Object)members.getMembers()).thenReturn(Arrays.asList(new ClusterMember(me), masterMember));
        DependencyResolver dependencyResolver = (DependencyResolver)Mockito.mock(DependencyResolver.class);
        FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        Mockito.when((Object)fs.fileExists((File)Matchers.any(File.class))).thenReturn((Object)true);
        Mockito.when((Object)dependencyResolver.resolveDependency(FileSystemAbstraction.class)).thenReturn((Object)fs);
        Mockito.when((Object)dependencyResolver.resolveDependency(Monitors.class)).thenReturn((Object)new Monitors());
        NeoStoreDataSource dataSource = (NeoStoreDataSource)Mockito.mock(NeoStoreDataSource.class);
        Mockito.when((Object)dataSource.getDependencyResolver()).thenReturn((Object)dependencyResolver);
        Mockito.when((Object)dataSource.getStoreId()).thenReturn((Object)storeId);
        Mockito.when((Object)dependencyResolver.resolveDependency(NeoStoreDataSource.class)).thenReturn((Object)dataSource);
        Mockito.when((Object)dependencyResolver.resolveDependency(TransactionIdStore.class)).thenReturn((Object)new DeadSimpleTransactionIdStore());
        Mockito.when((Object)dependencyResolver.resolveDependency(ClusterMembers.class)).thenReturn((Object)members);
        UpdatePuller updatePuller = (UpdatePuller)Mockito.mock(UpdatePuller.class);
        Mockito.when((Object)updatePuller.tryPullUpdates()).thenReturn((Object)true);
        Mockito.when((Object)dependencyResolver.resolveDependency(UpdatePuller.class)).thenReturn((Object)updatePuller);
        ClusterMemberAvailability clusterMemberAvailability = (ClusterMemberAvailability)Mockito.mock(ClusterMemberAvailability.class);
        TriggerableClusterMemberEvents events = new TriggerableClusterMemberEvents();
        Election election = (Election)Mockito.mock(Election.class);
        HighAvailabilityMemberStateMachine toTest = new HighAvailabilityMemberStateMachine(context, guard, members, (ClusterMemberEvents)events, election, (LogProvider)NullLogProvider.getInstance());
        toTest.init();
        toTest.start();
        final DelegateInvocationHandler handler = new DelegateInvocationHandler(Master.class, (LogProvider)NullLogProvider.getInstance());
        MasterClientResolver masterClientResolver = (MasterClientResolver)Mockito.mock(MasterClientResolver.class);
        MasterClient masterClient = (MasterClient)Mockito.mock(MasterClient.class);
        Mockito.when((Object)masterClient.getProtocolVersion()).thenReturn((Object)MasterClient214.PROTOCOL_VERSION);
        Mockito.when((Object)masterClient.handshake(Matchers.anyLong(), (StoreId)Matchers.any(StoreId.class))).thenReturn((Object)new Response<HandshakeResult>(new HandshakeResult(0L, 42L), storeId, (ResourceReleaser)Mockito.mock(ResourceReleaser.class)){

            public void accept(Response.Handler handler) throws IOException {
            }

            public boolean hasTransactionsToBeApplied() {
                return false;
            }
        });
        Mockito.when((Object)masterClient.toString()).thenReturn((Object)"TheExpectedMasterClient!");
        Mockito.when((Object)masterClientResolver.instantiate(Matchers.anyString(), Matchers.anyInt(), (Monitors)Matchers.any(Monitors.class), (StoreId)Matchers.any(StoreId.class), (LifeSupport)Matchers.any(LifeSupport.class))).thenReturn((Object)masterClient);
        final CountDownLatch latch = new CountDownLatch(2);
        final AtomicBoolean switchedSuccessfully = new AtomicBoolean();
        SwitchToSlave.Monitor monitor = new SwitchToSlave.Monitor(){

            public void switchToSlaveStarted() {
            }

            public void switchToSlaveCompleted(boolean wasSuccessful) {
                switchedSuccessfully.set(wasSuccessful);
                latch.countDown();
            }

            public void storeCopyStarted() {
            }

            public void storeCopyCompleted(boolean wasSuccessful) {
            }

            public void catchupStarted() {
            }

            public void catchupCompleted() {
            }
        };
        Config config = new Config(Collections.singletonMap(ClusterSettings.server_id.name(), me.toString()));
        TransactionCounters transactionCounters = (TransactionCounters)Mockito.mock(TransactionCounters.class);
        Mockito.when((Object)transactionCounters.getNumberOfActiveTransactions()).thenReturn((Object)0L);
        PageCache pageCacheMock = (PageCache)Mockito.mock(PageCache.class);
        PagedFile pagedFileMock = (PagedFile)Mockito.mock(PagedFile.class);
        Mockito.when((Object)pagedFileMock.getLastPageId()).thenReturn((Object)1L);
        Mockito.when((Object)pageCacheMock.map((File)Matchers.any(File.class), Matchers.anyInt(), new OpenOption[0])).thenReturn((Object)pagedFileMock);
        TransactionIdStore transactionIdStoreMock = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        Mockito.when((Object)transactionIdStoreMock.getLastCommittedTransaction()).thenReturn((Object)new TransactionId(0L, 0L));
        SwitchToSlave switchToSlave = new SwitchToSlave(new File(""), (LogService)NullLogService.getInstance(), (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class), members, config, dependencyResolver, (HaIdGeneratorFactory)Mockito.mock(HaIdGeneratorFactory.class), handler, (ClusterMemberAvailability)Mockito.mock(ClusterMemberAvailability.class), (RequestContextFactory)Mockito.mock(RequestContextFactory.class), (PullerFactory)Mockito.mock(PullerFactory.class, (Answer)Mockito.RETURNS_MOCKS), Iterables.empty(), masterClientResolver, monitor, (StoreCopyClient.Monitor)new StoreCopyClient.Monitor.Adapter(), Suppliers.singleton((Object)dataSource), Suppliers.singleton((Object)transactionIdStoreMock), (Function)new Function<Slave, SlaveServer>(){

            public SlaveServer apply(Slave slave) throws RuntimeException {
                SlaveServer mock = (SlaveServer)Mockito.mock(SlaveServer.class);
                Mockito.when((Object)mock.getSocketAddress()).thenReturn((Object)new InetSocketAddress("localhost", 123));
                return mock;
            }
        }, updatePuller, pageCacheMock, (Monitors)Mockito.mock(Monitors.class), transactionCounters);
        HighAvailabilityModeSwitcher haModeSwitcher = new HighAvailabilityModeSwitcher(switchToSlave, (SwitchToMaster)Mockito.mock(SwitchToMaster.class), election, clusterMemberAvailability, (ClusterClient)Mockito.mock(ClusterClient.class), HighAvailabilityModeSwitcherTest.storeSupplierMock(), me, (LogService)NullLogService.getInstance());
        haModeSwitcher.init();
        haModeSwitcher.start();
        haModeSwitcher.listeningAt(URI.create("http://localhost:12345"));
        toTest.addHighAvailabilityMemberListener((HighAvailabilityMemberListener)haModeSwitcher);
        final AtomicReference<Object> ref = new AtomicReference<Object>(null);
        AbstractModeSwitcher<Object> otherModeSwitcher = new AbstractModeSwitcher<Object>((ModeSwitcherNotifier)haModeSwitcher, (DelegateInvocationHandler)Mockito.mock(DelegateInvocationHandler.class)){

            protected Object getSlaveImpl(LifeSupport life) {
                Master master = (Master)handler.cement();
                ref.set(master);
                latch.countDown();
                return null;
            }

            protected Object getMasterImpl(LifeSupport life) {
                return null;
            }
        };
        otherModeSwitcher.init();
        otherModeSwitcher.start();
        events.switchToSlave(me);
        latch.await();
        Assert.assertTrue((String)"mode switch failed", (boolean)switchedSuccessfully.get());
        MasterClient expected = masterClient;
        Master actual = ref.get();
        String expected1 = expected.toString();
        String actual1 = actual.toString();
        Assert.assertEquals((Object)expected1, (Object)actual1);
        toTest.stop();
        toTest.shutdown();
        haModeSwitcher.stop();
        haModeSwitcher.shutdown();
        otherModeSwitcher.stop();
        otherModeSwitcher.shutdown();
    }

    private static class TriggerableClusterMemberEvents
    implements ClusterMemberEvents {
        private ClusterMemberListener listener;

        private TriggerableClusterMemberEvents() {
        }

        public void addClusterMemberListener(ClusterMemberListener listener) {
            this.listener = listener;
        }

        public void removeClusterMemberListener(ClusterMemberListener listener) {
        }

        public void switchToSlave(InstanceId me) {
            InstanceId someOneElseThanMyself = new InstanceId(me.toIntegerIndex() + 1);
            this.listener.memberIsAvailable("master", someOneElseThanMyself, URI.create("cluster://127.0.0.1:2390?serverId=2"), null);
            this.listener.memberIsAvailable("slave", me, null, null);
        }
    }

    private static final class HAStateChangeListener
    implements HighAvailabilityMemberListener {
        boolean masterIsElected = false;
        boolean masterIsAvailable = false;
        boolean slaveIsAvailable = false;
        boolean instanceStops = false;
        HighAvailabilityMemberChangeEvent lastEvent = null;

        private HAStateChangeListener() {
        }

        public void masterIsElected(HighAvailabilityMemberChangeEvent event) {
            this.masterIsElected = true;
            this.masterIsAvailable = false;
            this.slaveIsAvailable = false;
            this.instanceStops = false;
            this.lastEvent = event;
        }

        public void masterIsAvailable(HighAvailabilityMemberChangeEvent event) {
            this.masterIsElected = false;
            this.masterIsAvailable = true;
            this.slaveIsAvailable = false;
            this.instanceStops = false;
            this.lastEvent = event;
        }

        public void slaveIsAvailable(HighAvailabilityMemberChangeEvent event) {
            this.masterIsElected = false;
            this.masterIsAvailable = false;
            this.slaveIsAvailable = true;
            this.instanceStops = false;
            this.lastEvent = event;
        }

        public void instanceStops(HighAvailabilityMemberChangeEvent event) {
            this.masterIsElected = false;
            this.masterIsAvailable = false;
            this.slaveIsAvailable = false;
            this.instanceStops = true;
            this.lastEvent = event;
        }
    }
}

