/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster.member;

import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.TargetDirectory;
import org.neo4j.tooling.GlobalGraphOperations;

public class HighAvailabilitySlavesIT {
    @Rule
    public final TargetDirectory.TestDirectory testDirectory = TargetDirectory.testDirForTest(this.getClass());
    private ClusterManager clusterManager;

    @After
    public void after() throws Throwable {
        this.clusterManager.stop();
    }

    @Test
    public void transactionsGetsPushedToSlaves() throws Throwable {
        this.clusterManager = new ClusterManager(ClusterManager.clusterOfSize((int)3), this.testDirectory.directory("dbs"), MapUtil.stringMap((String[])new String[]{HaSettings.tx_push_factor.name(), "2"}));
        this.clusterManager.start();
        ClusterManager.ManagedCluster cluster = this.clusterManager.getDefaultCluster();
        String name = "a node";
        long node = this.createNode(cluster.getMaster(), name);
        for (HighlyAvailableGraphDatabase db : cluster.getAllMembers()) {
            Transaction transaction = db.beginTx();
            Throwable throwable = null;
            try {
                Assert.assertEquals((long)node, (long)this.getNodeByName(db, name));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (transaction == null) continue;
                if (throwable != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                transaction.close();
            }
        }
    }

    private long getNodeByName(HighlyAvailableGraphDatabase db, String name) {
        for (Node node : GlobalGraphOperations.at((GraphDatabaseService)db).getAllNodes()) {
            if (!name.equals(node.getProperty("name", null))) continue;
            return node.getId();
        }
        Assert.fail((String)("No node '" + name + "' found in " + db));
        return 0L;
    }

    private long createNode(HighlyAvailableGraphDatabase db, String name) {
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            node.setProperty("name", (Object)name);
            tx.success();
            long l = node.getId();
            return l;
        }
    }
}

