/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.index;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cluster.InstanceId;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.index.AutoIndexer;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.TargetDirectory;

public class AutoIndexConfigIT {
    @Rule
    public final TargetDirectory.TestDirectory testDirectory = TargetDirectory.testDirForTest(this.getClass());
    private ClusterManager.ManagedCluster cluster;
    private ClusterManager clusterManager;

    public void startCluster(int size) throws Throwable {
        this.clusterManager = new ClusterManager(ClusterManager.clusterOfSize((int)size), this.testDirectory.directory("dbs"), MapUtil.stringMap((String[])new String[0])){

            protected void config(GraphDatabaseBuilder builder, String clusterName, InstanceId serverId) {
                builder.setConfig("jmx.port", "" + (9912 + serverId.toIntegerIndex()));
                builder.setConfig(HaSettings.ha_server, ":" + (1136 + serverId.toIntegerIndex()));
            }
        };
        this.clusterManager.start();
        this.cluster = this.clusterManager.getDefaultCluster();
    }

    @After
    public void stopCluster() throws Throwable {
        this.clusterManager.stop();
    }

    @Test
    public void programmaticConfigShouldSurviveMasterSwitches() throws Throwable {
        String propertyToIndex = "programmatic-property";
        this.startCluster(3);
        HighlyAvailableGraphDatabase slave = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        AutoIndexer originalAutoIndex = slave.index().getNodeAutoIndexer();
        originalAutoIndex.setEnabled(true);
        originalAutoIndex.startAutoIndexingProperty(propertyToIndex);
        this.cluster.shutdown(this.cluster.getMaster());
        this.cluster.await(ClusterManager.masterAvailable((HighlyAvailableGraphDatabase[])new HighlyAvailableGraphDatabase[0]));
        AutoIndexer newAutoIndex = slave.index().getNodeAutoIndexer();
        Assert.assertThat((Object)newAutoIndex.isEnabled(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)newAutoIndex.getAutoIndexedProperties(), (Matcher)CoreMatchers.hasItem((Object)propertyToIndex));
    }
}

