/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.com.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.com.TransactionNotPresentOnMasterException;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.com.master.Conversation;
import org.neo4j.kernel.ha.com.master.ConversationManager;
import org.neo4j.kernel.ha.com.master.HandshakeResult;
import org.neo4j.kernel.ha.com.master.InvalidEpochException;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.id.IdAllocation;
import org.neo4j.kernel.ha.lock.LockResult;
import org.neo4j.kernel.ha.lock.LockStatus;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.transaction.IllegalResourceException;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.util.collection.ConcurrentAccessException;
import org.neo4j.kernel.impl.util.collection.NoSuchEntryException;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class MasterImpl
extends LifecycleAdapter
implements Master {
    private final SPI spi;
    private final Config config;
    private final Monitor monitor;
    private final long epoch;
    private ConversationManager conversationManager;

    public MasterImpl(SPI spi, ConversationManager conversationManager, Monitor monitor, Config config) {
        this.spi = spi;
        this.config = config;
        this.monitor = monitor;
        this.conversationManager = conversationManager;
        this.epoch = this.generateEpoch();
    }

    private long generateEpoch() {
        return (long)((InstanceId)this.config.get(ClusterSettings.server_id)).toIntegerIndex() << 48 | System.currentTimeMillis();
    }

    public void start() throws Throwable {
        this.conversationManager.start();
    }

    public void stop() {
        this.conversationManager.stop();
    }

    private void assertCorrectEpoch(RequestContext context) {
        if (this.epoch != context.getEpoch()) {
            throw new InvalidEpochException(this.epoch, context.getEpoch());
        }
    }

    @Override
    public Response<IdAllocation> allocateIds(RequestContext context, IdType idType) {
        this.assertCorrectEpoch(context);
        IdAllocation result = this.spi.allocateIds(idType);
        return this.spi.packEmptyResponse(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response<Long> commit(RequestContext context, TransactionRepresentation preparedTransaction) throws IOException, TransactionFailureException {
        this.assertCorrectEpoch(context);
        if (context.getEventIdentifier() == -1) {
            try (Conversation conversation = this.conversationManager.acquire();){
                Response<Long> response = this.commit0(context, preparedTransaction, conversation.getLocks());
                return response;
            }
        }
        Conversation conversation = this.conversationManager.acquire(context);
        Locks.Client locks = conversation.getLocks();
        try {
            Response<Long> response = this.commit0(context, preparedTransaction, locks);
            this.conversationManager.release(context);
            return response;
        }
        catch (Throwable throwable) {
            try {
                this.conversationManager.release(context);
                throw throwable;
            }
            catch (ConcurrentAccessException | NoSuchEntryException e) {
                throw new TransactionNotPresentOnMasterException(context);
            }
        }
    }

    private Response<Long> commit0(RequestContext context, TransactionRepresentation preparedTransaction, Locks.Client locks) throws IOException, TransactionFailureException {
        if (locks.trySharedLock((Locks.ResourceType)ResourceTypes.SCHEMA, ResourceTypes.schemaResource())) {
            long txId = this.spi.applyPreparedTransaction(preparedTransaction);
            return this.spi.packTransactionObligationResponse(context, txId);
        }
        throw new TransactionFailureException((Status)Status.Schema.ModifiedConcurrently, "Failed to commit, because another transaction is making schema changes. Slave commits are disallowed while schema changes are being committed. Retrying the transaction should yield a successful result.", new Object[0]);
    }

    @Override
    public Response<Integer> createRelationshipType(RequestContext context, String name) {
        this.assertCorrectEpoch(context);
        return this.spi.packTransactionObligationResponse(context, this.spi.createRelationshipType(name));
    }

    @Override
    public Response<Integer> createPropertyKey(RequestContext context, String name) {
        this.assertCorrectEpoch(context);
        return this.spi.packTransactionObligationResponse(context, this.spi.getOrCreateProperty(name));
    }

    @Override
    public Response<Integer> createLabel(RequestContext context, String name) {
        this.assertCorrectEpoch(context);
        return this.spi.packTransactionObligationResponse(context, this.spi.getOrCreateLabel(name));
    }

    @Override
    public Response<Void> pullUpdates(RequestContext context) {
        return this.spi.packTransactionStreamResponse(context, null);
    }

    @Override
    public Response<HandshakeResult> handshake(long txId, StoreId storeId) {
        try {
            long checksum = this.spi.getTransactionChecksum(txId);
            return this.spi.packEmptyResponse(new HandshakeResult(checksum, this.epoch));
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't get master ID for transaction id " + txId, e);
        }
    }

    @Override
    public Response<Void> copyStore(RequestContext requestContext, StoreWriter writer) {
        RequestContext context;
        try (StoreWriter storeWriter = writer;){
            context = this.spi.flushStoresAndStreamStoreFiles(storeWriter);
        }
        return this.spi.packTransactionStreamResponse(context, null);
    }

    @Override
    public Response<Void> newLockSession(RequestContext context) throws TransactionFailureException {
        this.monitor.initializeTx(context);
        if (!this.spi.isAccessible()) {
            throw new TransactionFailureException((Status)Status.General.DatabaseUnavailable, "Database is currently not available", new Object[0]);
        }
        this.assertCorrectEpoch(context);
        try {
            this.conversationManager.begin(context);
        }
        catch (ConcurrentAccessException e) {
            throw new TransactionFailureException((Status)Status.Transaction.ConcurrentRequest, (Throwable)e, "The lock session requested to start is already in use. Please retry your request in a few seconds.", new Object[0]);
        }
        return this.spi.packTransactionObligationResponse(context, null);
    }

    @Override
    public Response<Void> endLockSession(RequestContext context, boolean success) {
        this.assertCorrectEpoch(context);
        this.conversationManager.end(context);
        return this.spi.packTransactionObligationResponse(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response<LockResult> acquireExclusiveLock(RequestContext context, Locks.ResourceType type, long ... resourceIds) {
        Locks.Client session;
        this.assertCorrectEpoch(context);
        try {
            session = this.conversationManager.acquire(context).getLocks();
        }
        catch (ConcurrentAccessException | NoSuchEntryException throwable) {
            return this.spi.packTransactionObligationResponse(context, new LockResult("Unable to acquire exclusive lock: " + throwable.getMessage()));
        }
        try {
            for (long resourceId : resourceIds) {
                session.acquireExclusive(type, resourceId);
            }
            Response<LockResult> response = this.spi.packTransactionObligationResponse(context, new LockResult(LockStatus.OK_LOCKED));
            return response;
        }
        catch (DeadlockDetectedException deadlockDetectedException) {
            Response<LockResult> response = this.spi.packTransactionObligationResponse(context, new LockResult("Can't acquire exclusive lock, because it would have caused a deadlock: " + deadlockDetectedException.getMessage()));
            return response;
        }
        catch (IllegalResourceException illegalResourceException) {
            Response<LockResult> response = this.spi.packTransactionObligationResponse(context, new LockResult(LockStatus.NOT_LOCKED));
            return response;
        }
        finally {
            this.conversationManager.release(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response<LockResult> acquireSharedLock(RequestContext context, Locks.ResourceType type, long ... resourceIds) {
        Locks.Client session;
        this.assertCorrectEpoch(context);
        try {
            session = this.conversationManager.acquire(context).getLocks();
        }
        catch (ConcurrentAccessException | NoSuchEntryException throwable) {
            return this.spi.packTransactionObligationResponse(context, new LockResult("Unable to acquire shared lock: " + throwable.getMessage()));
        }
        try {
            for (long resourceId : resourceIds) {
                session.acquireShared(type, resourceId);
            }
            Response<LockResult> response = this.spi.packTransactionObligationResponse(context, new LockResult(LockStatus.OK_LOCKED));
            return response;
        }
        catch (DeadlockDetectedException deadlockDetectedException) {
            Response<LockResult> response = this.spi.packTransactionObligationResponse(context, new LockResult(deadlockDetectedException.getMessage()));
            return response;
        }
        catch (IllegalResourceException illegalResourceException) {
            Response<LockResult> response = this.spi.packTransactionObligationResponse(context, new LockResult(LockStatus.NOT_LOCKED));
            return response;
        }
        finally {
            this.conversationManager.release(context);
        }
    }

    public Map<Integer, Collection<RequestContext>> getOngoingTransactions() {
        HashMap<Integer, Collection<RequestContext>> result = new HashMap<Integer, Collection<RequestContext>>();
        Set<RequestContext> contexts = this.conversationManager.getActiveContexts();
        for (RequestContext context : contexts.toArray(new RequestContext[contexts.size()])) {
            ArrayList<RequestContext> txs = (ArrayList<RequestContext>)result.get(context.machineId());
            if (txs == null) {
                txs = new ArrayList<RequestContext>();
                result.put(context.machineId(), txs);
            }
            txs.add(context);
        }
        return result;
    }

    public static interface SPI {
        public boolean isAccessible();

        public IdAllocation allocateIds(IdType var1);

        public StoreId storeId();

        public long applyPreparedTransaction(TransactionRepresentation var1) throws IOException, TransactionFailureException;

        public Integer createRelationshipType(String var1);

        public long getTransactionChecksum(long var1) throws IOException;

        public RequestContext flushStoresAndStreamStoreFiles(StoreWriter var1);

        public <T> Response<T> packEmptyResponse(T var1);

        public <T> Response<T> packTransactionStreamResponse(RequestContext var1, T var2);

        public <T> Response<T> packTransactionObligationResponse(RequestContext var1, T var2);

        public int getOrCreateLabel(String var1);

        public int getOrCreateProperty(String var1);
    }

    public static interface Monitor {
        public void initializeTx(RequestContext var1);
    }
}

