/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.lock;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.lock.LocalDeadlockDetectedException;
import org.neo4j.kernel.ha.lock.LockResult;
import org.neo4j.kernel.ha.lock.SlaveLockManager;
import org.neo4j.kernel.impl.locking.AcquireLockTimeoutException;
import org.neo4j.kernel.impl.locking.LockManager;
import org.neo4j.kernel.impl.locking.LockType;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;

class SlaveLocksClient
implements Locks.Client {
    private final Master master;
    private final Locks.Client client;
    private final Locks localLockManager;
    private final RequestContextFactory requestContextFactory;
    private final AvailabilityGuard availabilityGuard;
    private final SlaveLockManager.Configuration config;
    private final Map<Locks.ResourceType, Map<Long, AtomicInteger>> sharedLocks;
    private final Map<Locks.ResourceType, Map<Long, AtomicInteger>> exclusiveLocks;
    private boolean initialized = false;

    public SlaveLocksClient(Master master, Locks.Client local, Locks localLockManager, RequestContextFactory requestContextFactory, AvailabilityGuard availabilityGuard, SlaveLockManager.Configuration config) {
        this.master = master;
        this.client = local;
        this.localLockManager = localLockManager;
        this.requestContextFactory = requestContextFactory;
        this.availabilityGuard = availabilityGuard;
        this.config = config;
        this.sharedLocks = new HashMap<Locks.ResourceType, Map<Long, AtomicInteger>>();
        this.exclusiveLocks = new HashMap<Locks.ResourceType, Map<Long, AtomicInteger>>();
    }

    private Map<Long, AtomicInteger> getLockMap(Map<Locks.ResourceType, Map<Long, AtomicInteger>> resourceMap, Locks.ResourceType resourceType) {
        Map<Long, AtomicInteger> lockMap = resourceMap.get(resourceType);
        if (lockMap == null) {
            lockMap = new HashMap<Long, AtomicInteger>();
            resourceMap.put(resourceType, lockMap);
        }
        return lockMap;
    }

    public void acquireShared(Locks.ResourceType resourceType, long resourceId) throws AcquireLockTimeoutException {
        Map<Long, AtomicInteger> lockMap = this.getLockMap(this.sharedLocks, resourceType);
        AtomicInteger preExistingLock = lockMap.get(resourceId);
        if (preExistingLock != null) {
            preExistingLock.incrementAndGet();
        } else if (this.getReadLockOnMaster(resourceType, resourceId)) {
            if (this.client.trySharedLock(resourceType, resourceId)) {
                lockMap.put(resourceId, new AtomicInteger(1));
            } else {
                throw new LocalDeadlockDetectedException(this.client, this.localLockManager, resourceType, resourceId, LockType.READ);
            }
        }
    }

    public void acquireExclusive(Locks.ResourceType resourceType, long resourceId) throws AcquireLockTimeoutException {
        Map<Long, AtomicInteger> lockMap = this.getLockMap(this.exclusiveLocks, resourceType);
        AtomicInteger preExistingLock = lockMap.get(resourceId);
        if (preExistingLock != null) {
            preExistingLock.incrementAndGet();
        } else if (this.acquireExclusiveOnMaster(resourceType, resourceId)) {
            if (this.client.tryExclusiveLock(resourceType, resourceId)) {
                lockMap.put(resourceId, new AtomicInteger(1));
            } else {
                throw new LocalDeadlockDetectedException(this.client, this.localLockManager, resourceType, resourceId, LockType.WRITE);
            }
        }
    }

    public boolean tryExclusiveLock(Locks.ResourceType resourceType, long resourceId) {
        throw this.newUnsupportedDirectTryLockUsageException();
    }

    public boolean trySharedLock(Locks.ResourceType resourceType, long resourceId) {
        throw this.newUnsupportedDirectTryLockUsageException();
    }

    public void releaseShared(Locks.ResourceType resourceType, long resourceId) {
        Map<Long, AtomicInteger> lockMap = this.getLockMap(this.sharedLocks, resourceType);
        AtomicInteger counter = lockMap.get(resourceId);
        if (counter == null) {
            throw new IllegalStateException(this + " cannot release lock it does not hold: EXCLUSIVE " + resourceType + "[" + resourceId + "]");
        }
        if (counter.decrementAndGet() == 0) {
            lockMap.remove(resourceId);
            this.client.releaseShared(resourceType, resourceId);
        }
    }

    public void releaseExclusive(Locks.ResourceType resourceType, long resourceId) {
        Map<Long, AtomicInteger> lockMap = this.getLockMap(this.exclusiveLocks, resourceType);
        AtomicInteger counter = lockMap.get(resourceId);
        if (counter == null) {
            throw new IllegalStateException(this + " cannot release lock it does not hold: EXCLUSIVE " + resourceType + "[" + resourceId + "]");
        }
        if (counter.decrementAndGet() == 0) {
            lockMap.remove(resourceId);
            this.client.releaseExclusive(resourceType, resourceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAll() {
        this.sharedLocks.clear();
        this.exclusiveLocks.clear();
        this.client.releaseAll();
        if (this.initialized) {
            Response<Void> ignored = this.master.endLockSession(this.newRequestContextFor(this.client), true);
            Throwable throwable = null;
            if (ignored != null) {
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                } else {
                    ignored.close();
                }
            }
            this.initialized = false;
        }
    }

    public void stop() {
        throw new UnsupportedOperationException("Lock client stop is unsupported on slave side.");
    }

    public void close() {
        this.releaseAll();
        this.client.close();
    }

    public int getLockSessionId() {
        return this.initialized ? this.client.getLockSessionId() : -1;
    }

    private boolean getReadLockOnMaster(Locks.ResourceType resourceType, long resourceId) {
        if (resourceType == ResourceTypes.NODE || resourceType == ResourceTypes.RELATIONSHIP || resourceType == ResourceTypes.GRAPH_PROPS || resourceType == ResourceTypes.LEGACY_INDEX) {
            this.makeSureTxHasBeenInitialized();
            RequestContext requestContext = this.newRequestContextFor(this);
            try (Response<LockResult> response = this.master.acquireSharedLock(requestContext, resourceType, resourceId);){
                boolean bl = this.receiveLockResponse(response);
                return bl;
            }
        }
        return true;
    }

    private boolean acquireExclusiveOnMaster(Locks.ResourceType resourceType, long resourceId) {
        this.makeSureTxHasBeenInitialized();
        RequestContext requestContext = this.newRequestContextFor(this);
        try (Response<LockResult> response = this.master.acquireExclusiveLock(requestContext, resourceType, resourceId);){
            boolean bl = this.receiveLockResponse(response);
            return bl;
        }
    }

    private boolean receiveLockResponse(Response<LockResult> response) {
        LockResult result = (LockResult)response.response();
        switch (result.getStatus()) {
            case DEAD_LOCKED: {
                throw new DeadlockDetectedException(result.getDeadlockMessage());
            }
            case NOT_LOCKED: {
                throw new UnsupportedOperationException();
            }
            case OK_LOCKED: {
                break;
            }
            default: {
                throw new UnsupportedOperationException(result.toString());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeSureTxHasBeenInitialized() {
        try {
            this.availabilityGuard.await(this.config.getAvailabilityTimeout());
        }
        catch (AvailabilityGuard.UnavailableException e) {
            throw new RuntimeException(e.getMessage());
        }
        if (!this.initialized) {
            try {
                Response<Void> ignored = this.master.newLockSession(this.newRequestContextFor(this.client));
                Throwable throwable = null;
                if (ignored != null) {
                    if (throwable != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        ignored.close();
                    }
                }
            }
            catch (org.neo4j.kernel.api.exceptions.TransactionFailureException e) {
                throw new TransactionFailureException("Failed to acquire lock in cluster: " + e.getMessage(), (Throwable)e);
            }
            this.initialized = true;
        }
    }

    private RequestContext newRequestContextFor(Locks.Client client) {
        return this.requestContextFactory.newRequestContext(client.getLockSessionId());
    }

    private UnsupportedOperationException newUnsupportedDirectTryLockUsageException() {
        return new UnsupportedOperationException("At the time of adding \"try lock\" semantics there was no usage of " + this.getClass().getSimpleName() + " calling it directly. It was designed to be called on a local " + LockManager.class.getSimpleName() + " delegated to from within the waiting version");
    }
}

