/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.ha.ClusterRule;

public class TestClusterClientPadding {
    @Rule
    public ClusterRule clusterRule = new ClusterRule(this.getClass());
    private ClusterManager.ManagedCluster cluster;

    @Before
    public void setUp() throws Throwable {
        this.cluster = this.clusterRule.provider(ClusterManager.clusterWithAdditionalClients((int)2, (int)1)).availabilityChecks(ClusterManager.masterAvailable((HighlyAvailableGraphDatabase[])new HighlyAvailableGraphDatabase[0]), ClusterManager.masterSeesMembers((int)3), ClusterManager.allSeesAllAsJoined()).startCluster();
    }

    @Test
    public void additionalClusterClientCanHelpBreakTiesWhenMasterIsShutDown() throws Throwable {
        HighlyAvailableGraphDatabase sittingMaster = this.cluster.getMaster();
        this.cluster.shutdown(sittingMaster);
        this.cluster.await(ClusterManager.masterAvailable((HighlyAvailableGraphDatabase[])new HighlyAvailableGraphDatabase[]{sittingMaster}));
    }

    @Test
    public void additionalClusterClientCanHelpBreakTiesWhenMasterFails() throws Throwable {
        HighlyAvailableGraphDatabase sittingMaster = this.cluster.getMaster();
        this.cluster.fail(sittingMaster);
        this.cluster.await(ClusterManager.masterAvailable((HighlyAvailableGraphDatabase[])new HighlyAvailableGraphDatabase[]{sittingMaster}));
    }
}

